/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import androidx.annotation.Keep;
import com.google.firebase.perf.metrics.NetworkRequestMetricBuilder;
import com.google.firebase.perf.network.InstrumentApacheHttpResponseHandler;
import com.google.firebase.perf.network.NetworkRequestMetricBuilderUtil;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Timer;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public class FirebasePerfHttpClient {
    private FirebasePerfHttpClient() {
    }

    @Keep
    public static HttpResponse execute(HttpClient client, HttpUriRequest request) throws IOException {
        return FirebasePerfHttpClient.execute(client, request, new Timer(), TransportManager.getInstance());
    }

    @Keep
    public static HttpResponse execute(HttpClient client, HttpUriRequest request, HttpContext context) throws IOException {
        return FirebasePerfHttpClient.execute(client, request, context, new Timer(), TransportManager.getInstance());
    }

    @Keep
    public static <T> T execute(HttpClient client, HttpUriRequest request, ResponseHandler<T> responseHandler) throws IOException {
        return FirebasePerfHttpClient.execute(client, request, responseHandler, new Timer(), TransportManager.getInstance());
    }

    @Keep
    public static <T> T execute(HttpClient client, HttpUriRequest request, ResponseHandler<T> responseHandler, HttpContext context) throws IOException {
        return FirebasePerfHttpClient.execute(client, request, responseHandler, context, new Timer(), TransportManager.getInstance());
    }

    @Keep
    public static HttpResponse execute(HttpClient client, HttpHost target, HttpRequest request) throws IOException {
        return FirebasePerfHttpClient.execute(client, target, request, new Timer(), TransportManager.getInstance());
    }

    @Keep
    public static HttpResponse execute(HttpClient client, HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        return FirebasePerfHttpClient.execute(client, target, request, context, new Timer(), TransportManager.getInstance());
    }

    @Keep
    public static <T> T execute(HttpClient client, HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return FirebasePerfHttpClient.execute(client, target, request, responseHandler, new Timer(), TransportManager.getInstance());
    }

    @Keep
    public static <T> T execute(HttpClient client, HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        return FirebasePerfHttpClient.execute(client, target, request, responseHandler, context, new Timer(), TransportManager.getInstance());
    }

    static HttpResponse execute(HttpClient client, HttpUriRequest request, Timer timer, TransportManager transportManager) throws IOException {
        HttpResponse response = null;
        NetworkRequestMetricBuilder builder = NetworkRequestMetricBuilder.builder(transportManager);
        try {
            String contentType;
            builder.setUrl(request.getURI().toString()).setHttpMethod(request.getMethod());
            Long requestContentLength = NetworkRequestMetricBuilderUtil.getApacheHttpMessageContentLength((HttpMessage)request);
            if (requestContentLength != null) {
                builder.setRequestPayloadBytes(requestContentLength);
            }
            timer.reset();
            builder.setRequestStartTimeMicros(timer.getMicros());
            response = client.execute(request);
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            builder.setHttpResponseCode(response.getStatusLine().getStatusCode());
            Long responseContentLength = NetworkRequestMetricBuilderUtil.getApacheHttpMessageContentLength((HttpMessage)response);
            if (responseContentLength != null) {
                builder.setResponsePayloadBytes(responseContentLength);
            }
            if ((contentType = NetworkRequestMetricBuilderUtil.getApacheHttpResponseContentType(response)) != null) {
                builder.setResponseContentType(contentType);
            }
            builder.build();
        }
        catch (IOException e) {
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(builder);
            throw e;
        }
        return response;
    }

    static HttpResponse execute(HttpClient client, HttpUriRequest request, HttpContext context, Timer timer, TransportManager transportManager) throws IOException {
        HttpResponse response = null;
        NetworkRequestMetricBuilder builder = NetworkRequestMetricBuilder.builder(transportManager);
        try {
            String contentType;
            builder.setUrl(request.getURI().toString()).setHttpMethod(request.getMethod());
            Long requestContentLength = NetworkRequestMetricBuilderUtil.getApacheHttpMessageContentLength((HttpMessage)request);
            if (requestContentLength != null) {
                builder.setRequestPayloadBytes(requestContentLength);
            }
            timer.reset();
            builder.setRequestStartTimeMicros(timer.getMicros());
            response = client.execute(request, context);
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            builder.setHttpResponseCode(response.getStatusLine().getStatusCode());
            Long responseContentLength = NetworkRequestMetricBuilderUtil.getApacheHttpMessageContentLength((HttpMessage)response);
            if (responseContentLength != null) {
                builder.setResponsePayloadBytes(responseContentLength);
            }
            if ((contentType = NetworkRequestMetricBuilderUtil.getApacheHttpResponseContentType(response)) != null) {
                builder.setResponseContentType(contentType);
            }
            builder.build();
        }
        catch (IOException e) {
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(builder);
            throw e;
        }
        return response;
    }

    static <T> T execute(HttpClient client, HttpUriRequest request, ResponseHandler<T> responseHandler, Timer timer, TransportManager transportManager) throws IOException {
        NetworkRequestMetricBuilder builder = NetworkRequestMetricBuilder.builder(transportManager);
        try {
            builder.setUrl(request.getURI().toString()).setHttpMethod(request.getMethod());
            Long requestContentLength = NetworkRequestMetricBuilderUtil.getApacheHttpMessageContentLength((HttpMessage)request);
            if (requestContentLength != null) {
                builder.setRequestPayloadBytes(requestContentLength);
            }
            timer.reset();
            builder.setRequestStartTimeMicros(timer.getMicros());
            return (T)client.execute(request, new InstrumentApacheHttpResponseHandler<T>(responseHandler, timer, builder));
        }
        catch (IOException e) {
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(builder);
            throw e;
        }
    }

    static <T> T execute(HttpClient client, HttpUriRequest request, ResponseHandler<T> responseHandler, HttpContext context, Timer timer, TransportManager transportManager) throws IOException {
        NetworkRequestMetricBuilder builder = NetworkRequestMetricBuilder.builder(transportManager);
        try {
            builder.setUrl(request.getURI().toString()).setHttpMethod(request.getMethod());
            Long requestContentLength = NetworkRequestMetricBuilderUtil.getApacheHttpMessageContentLength((HttpMessage)request);
            if (requestContentLength != null) {
                builder.setRequestPayloadBytes(requestContentLength);
            }
            timer.reset();
            builder.setRequestStartTimeMicros(timer.getMicros());
            return (T)client.execute(request, new InstrumentApacheHttpResponseHandler<T>(responseHandler, timer, builder), context);
        }
        catch (IOException e) {
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(builder);
            throw e;
        }
    }

    static HttpResponse execute(HttpClient client, HttpHost target, HttpRequest request, Timer timer, TransportManager transportManager) throws IOException {
        HttpResponse response = null;
        NetworkRequestMetricBuilder builder = NetworkRequestMetricBuilder.builder(transportManager);
        try {
            String contentType;
            builder.setUrl(target.toURI() + request.getRequestLine().getUri()).setHttpMethod(request.getRequestLine().getMethod());
            Long requestContentLength = NetworkRequestMetricBuilderUtil.getApacheHttpMessageContentLength((HttpMessage)request);
            if (requestContentLength != null) {
                builder.setRequestPayloadBytes(requestContentLength);
            }
            timer.reset();
            builder.setRequestStartTimeMicros(timer.getMicros());
            response = client.execute(target, request);
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            builder.setHttpResponseCode(response.getStatusLine().getStatusCode());
            Long responseContentLength = NetworkRequestMetricBuilderUtil.getApacheHttpMessageContentLength((HttpMessage)response);
            if (responseContentLength != null) {
                builder.setResponsePayloadBytes(responseContentLength);
            }
            if ((contentType = NetworkRequestMetricBuilderUtil.getApacheHttpResponseContentType(response)) != null) {
                builder.setResponseContentType(contentType);
            }
            builder.build();
        }
        catch (IOException e) {
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(builder);
            throw e;
        }
        return response;
    }

    static HttpResponse execute(HttpClient client, HttpHost target, HttpRequest request, HttpContext context, Timer timer, TransportManager transportManager) throws IOException {
        HttpResponse response = null;
        NetworkRequestMetricBuilder builder = NetworkRequestMetricBuilder.builder(transportManager);
        try {
            String contentType;
            builder.setUrl(target.toURI() + request.getRequestLine().getUri()).setHttpMethod(request.getRequestLine().getMethod());
            Long requestContentLength = NetworkRequestMetricBuilderUtil.getApacheHttpMessageContentLength((HttpMessage)request);
            if (requestContentLength != null) {
                builder.setRequestPayloadBytes(requestContentLength);
            }
            timer.reset();
            builder.setRequestStartTimeMicros(timer.getMicros());
            response = client.execute(target, request, context);
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            builder.setHttpResponseCode(response.getStatusLine().getStatusCode());
            Long responseContentLength = NetworkRequestMetricBuilderUtil.getApacheHttpMessageContentLength((HttpMessage)response);
            if (responseContentLength != null) {
                builder.setResponsePayloadBytes(responseContentLength);
            }
            if ((contentType = NetworkRequestMetricBuilderUtil.getApacheHttpResponseContentType(response)) != null) {
                builder.setResponseContentType(contentType);
            }
            builder.build();
        }
        catch (IOException e) {
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(builder);
            throw e;
        }
        return response;
    }

    static <T> T execute(HttpClient client, HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, Timer timer, TransportManager transportManager) throws IOException {
        NetworkRequestMetricBuilder builder = NetworkRequestMetricBuilder.builder(transportManager);
        try {
            builder.setUrl(target.toURI() + request.getRequestLine().getUri()).setHttpMethod(request.getRequestLine().getMethod());
            Long requestContentLength = NetworkRequestMetricBuilderUtil.getApacheHttpMessageContentLength((HttpMessage)request);
            if (requestContentLength != null) {
                builder.setRequestPayloadBytes(requestContentLength);
            }
            timer.reset();
            builder.setRequestStartTimeMicros(timer.getMicros());
            return (T)client.execute(target, request, new InstrumentApacheHttpResponseHandler<T>(responseHandler, timer, builder));
        }
        catch (IOException e) {
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(builder);
            throw e;
        }
    }

    static <T> T execute(HttpClient client, HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context, Timer timer, TransportManager transportManager) throws IOException {
        NetworkRequestMetricBuilder builder = NetworkRequestMetricBuilder.builder(transportManager);
        try {
            builder.setUrl(target.toURI() + request.getRequestLine().getUri()).setHttpMethod(request.getRequestLine().getMethod());
            Long requestContentLength = NetworkRequestMetricBuilderUtil.getApacheHttpMessageContentLength((HttpMessage)request);
            if (requestContentLength != null) {
                builder.setRequestPayloadBytes(requestContentLength);
            }
            timer.reset();
            builder.setRequestStartTimeMicros(timer.getMicros());
            return (T)client.execute(target, request, new InstrumentApacheHttpResponseHandler<T>(responseHandler, timer, builder), context);
        }
        catch (IOException e) {
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(builder);
            throw e;
        }
    }
}

