/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.util;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.concurrent.TimeUnit;

public class Timer
implements Parcelable {
    private long timeInMicros;
    private long highResTime;
    public static final Parcelable.Creator<Timer> CREATOR = new Parcelable.Creator<Timer>(){

        public Timer createFromParcel(Parcel in) {
            return new Timer(in);
        }

        public Timer[] newArray(int size) {
            return new Timer[size];
        }
    };

    public Timer() {
        this.timeInMicros = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
        this.highResTime = System.nanoTime();
    }

    @VisibleForTesting
    public Timer(long time) {
        this.timeInMicros = time;
        this.highResTime = TimeUnit.MICROSECONDS.toNanos(time);
    }

    @VisibleForTesting
    public Timer(long time, long highResTime) {
        this.timeInMicros = time;
        this.highResTime = highResTime;
    }

    private Timer(Parcel in) {
        this.timeInMicros = in.readLong();
        this.highResTime = in.readLong();
    }

    public void reset() {
        this.timeInMicros = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
        this.highResTime = System.nanoTime();
    }

    public long getMicros() {
        return this.timeInMicros;
    }

    public long getDurationMicros() {
        return TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - this.highResTime);
    }

    public long getDurationMicros(@NonNull Timer end) {
        return TimeUnit.NANOSECONDS.toMicros(end.highResTime - this.highResTime);
    }

    public long getCurrentTimestampMicros() {
        return this.timeInMicros + this.getDurationMicros();
    }

    @VisibleForTesting
    public long getHighResTime() {
        return TimeUnit.NANOSECONDS.toMicros(this.highResTime);
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.timeInMicros);
        out.writeLong(this.highResTime);
    }

    public int describeContents() {
        return 0;
    }
}

