/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import androidx.annotation.Keep;
import com.google.firebase.perf.metrics.NetworkRequestMetricBuilder;
import com.google.firebase.perf.network.InstrumentOkHttpEnqueueCallback;
import com.google.firebase.perf.network.NetworkRequestMetricBuilderUtil;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Timer;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class FirebasePerfOkHttpClient {
    private FirebasePerfOkHttpClient() {
    }

    @Keep
    public static Response execute(Call call) throws IOException {
        Response response;
        NetworkRequestMetricBuilder builder = NetworkRequestMetricBuilder.builder(TransportManager.getInstance());
        Timer timer = new Timer();
        long startTimeMicros = timer.getMicros();
        try {
            response = call.execute();
            long responseCompletedTimeMicros = timer.getDurationMicros();
            FirebasePerfOkHttpClient.sendNetworkMetric(response, builder, startTimeMicros, responseCompletedTimeMicros);
        }
        catch (IOException e) {
            Request request = call.request();
            if (request != null) {
                String method;
                HttpUrl url = request.url();
                if (url != null) {
                    builder.setUrl(url.url().toString());
                }
                if ((method = request.method()) != null) {
                    builder.setHttpMethod(request.method());
                }
            }
            builder.setRequestStartTimeMicros(startTimeMicros);
            builder.setTimeToResponseCompletedMicros(timer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(builder);
            throw e;
        }
        return response;
    }

    @Keep
    public static void enqueue(Call call, Callback callback) {
        Timer timer = new Timer();
        long startTime = timer.getMicros();
        call.enqueue((Callback)new InstrumentOkHttpEnqueueCallback(callback, TransportManager.getInstance(), timer, startTime));
    }

    static void sendNetworkMetric(Response response, NetworkRequestMetricBuilder builder, long startTimeMicros, long responseCompletedTimeMicros) throws IOException {
        ResponseBody responseBody;
        long requestContentLength;
        Request request = response.request();
        if (request == null) {
            return;
        }
        builder.setUrl(request.url().url().toString());
        builder.setHttpMethod(request.method());
        RequestBody requestBody = request.body();
        if (requestBody != null && (requestContentLength = request.body().contentLength()) != -1L) {
            builder.setRequestPayloadBytes(requestContentLength);
        }
        if ((responseBody = response.body()) != null) {
            MediaType mediaType;
            long responseContentLength = responseBody.contentLength();
            if (responseContentLength != -1L) {
                builder.setResponsePayloadBytes(responseContentLength);
            }
            if ((mediaType = responseBody.contentType()) != null) {
                builder.setResponseContentType(mediaType.toString());
            }
        }
        builder.setHttpResponseCode(response.code());
        builder.setRequestStartTimeMicros(startTimeMicros);
        builder.setTimeToResponseCompletedMicros(responseCompletedTimeMicros);
        builder.build();
    }
}

