/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.internal.firebase-perf.zzav;
import com.google.android.gms.internal.firebase-perf.zzax;
import com.google.android.gms.internal.firebase-perf.zzbg;
import com.google.android.gms.internal.firebase-perf.zzbr;
import com.google.android.gms.internal.firebase-perf.zzcy;
import com.google.android.gms.internal.firebase-perf.zzep;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.internal.zzd;
import com.google.firebase.perf.provider.FirebasePerfProvider;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class AppStartTrace
implements Application.ActivityLifecycleCallbacks {
    private static final long zzfx = TimeUnit.MINUTES.toMicros(1L);
    private static volatile AppStartTrace zzfy;
    private boolean mRegistered = false;
    private zzd zzbs = null;
    private final zzav zzbt;
    private Context zzfz;
    private WeakReference<Activity> zzga;
    private WeakReference<Activity> zzgb;
    private boolean zzgc = false;
    private zzbg zzgd = null;
    private zzbg zzge = null;
    private zzbg zzgf = null;
    private boolean zzgg = false;

    @Keep
    public static void setLauncherActivityOnCreateTime(String string) {
    }

    @Keep
    public static void setLauncherActivityOnStartTime(String string) {
    }

    @Keep
    public static void setLauncherActivityOnResumeTime(String string) {
    }

    public static AppStartTrace zzcr() {
        if (zzfy != null) {
            return zzfy;
        }
        return AppStartTrace.zzb(null, new zzav());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AppStartTrace zzb(zzd zzd2, zzav zzav2) {
        if (zzfy != null) return zzfy;
        Class<AppStartTrace> clazz = AppStartTrace.class;
        synchronized (AppStartTrace.class) {
            if (zzfy != null) return zzfy;
            zzfy = new AppStartTrace(null, zzav2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzfy;
        }
    }

    private AppStartTrace(@Nullable zzd zzd2, @NonNull zzav zzav2) {
        this.zzbt = zzav2;
    }

    public final synchronized void zzc(@NonNull Context context) {
        if (this.mRegistered) {
            return;
        }
        Context context2 = context.getApplicationContext();
        if (context2 instanceof Application) {
            ((Application)context2).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.mRegistered = true;
            this.zzfz = context2;
        }
    }

    private final synchronized void zzcs() {
        if (!this.mRegistered) {
            return;
        }
        ((Application)this.zzfz).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.mRegistered = false;
    }

    public synchronized void onActivityCreated(Activity activity, Bundle bundle) {
        SessionManager.zzcn().zzc(zzbr.zzjk);
        if (this.zzgg || this.zzgd != null) {
            return;
        }
        this.zzga = new WeakReference<Activity>(activity);
        this.zzgd = new zzbg();
        if (FirebasePerfProvider.zzda().zza(this.zzgd) > zzfx) {
            this.zzgc = true;
        }
    }

    public synchronized void onActivityStarted(Activity activity) {
        if (this.zzgg || this.zzge != null || this.zzgc) {
            return;
        }
        this.zzge = new zzbg();
    }

    public synchronized void onActivityResumed(Activity activity) {
        if (this.zzgg || this.zzgf != null || this.zzgc) {
            return;
        }
        this.zzgb = new WeakReference<Activity>(activity);
        this.zzgf = new zzbg();
        zzbg zzbg2 = FirebasePerfProvider.zzda();
        Object object = activity.getClass().getName();
        long l = zzbg2.zza(this.zzgf);
        Log.d((String)"FirebasePerformance", (String)new StringBuilder(47 + String.valueOf(object).length()).append("onResume(): ").append((String)object).append(": ").append(l).append(" microseconds").toString());
        object = zzcy.zzgc().zzae(zzax.zzhu.toString()).zzak(zzbg2.zzdb()).zzal(zzbg2.zza(this.zzgf));
        ArrayList<zzcy> arrayList = new ArrayList<zzcy>(3);
        zzcy.zza zza2 = zzcy.zzgc().zzae(zzax.zzhv.toString()).zzak(zzbg2.zzdb()).zzal(zzbg2.zza(this.zzgd));
        arrayList.add((zzcy)((zzep)zza2.zzhy()));
        zza2 = zzcy.zzgc();
        zza2.zzae(zzax.zzhw.toString()).zzak(this.zzgd.zzdb()).zzal(this.zzgd.zza(this.zzge));
        arrayList.add((zzcy)((zzep)zza2.zzhy()));
        zza2 = zzcy.zzgc();
        zza2.zzae(zzax.zzhx.toString()).zzak(this.zzge.zzdb()).zzal(this.zzge.zza(this.zzgf));
        arrayList.add((zzcy)((zzep)zza2.zzhy()));
        ((zzcy.zza)object).zze(arrayList).zzb(SessionManager.zzcn().zzco().zzbr());
        if (this.zzbs == null) {
            this.zzbs = zzd.zzbc();
        }
        if (this.zzbs != null) {
            this.zzbs.zza((zzcy)((zzep)((zzep.zza)object).zzhy()), zzbr.zzjm);
        }
        if (this.mRegistered) {
            this.zzcs();
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public synchronized void onActivityStopped(Activity activity) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    static /* synthetic */ boolean zza(AppStartTrace appStartTrace, boolean bl) {
        appStartTrace.zzgg = true;
        return true;
    }

    public static final class zza
    implements Runnable {
        private final AppStartTrace zzgh;

        public zza(AppStartTrace appStartTrace) {
            this.zzgh = appStartTrace;
        }

        @Override
        public final void run() {
            if (this.zzgh.zzgd == null) {
                AppStartTrace.zza(this.zzgh, true);
            }
        }
    }
}

