/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-perf.zza;
import com.google.android.gms.internal.firebase-perf.zzaz;
import com.google.android.gms.internal.firebase-perf.zzbg;
import com.google.android.gms.internal.firebase-perf.zzg;
import com.google.android.gms.internal.firebase-perf.zzh;
import com.google.android.gms.internal.firebase-perf.zzq;
import com.google.android.gms.internal.firebase-perf.zzr;
import com.google.android.gms.internal.firebase-perf.zzu;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.perf.internal.zzaa;
import com.google.firebase.perf.internal.zzab;
import com.google.firebase.perf.internal.zzac;
import com.google.firebase.perf.internal.zzy;
import com.google.firebase.perf.internal.zzz;
import com.google.firebase.perf.provider.FirebasePerfProvider;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Keep
public class RemoteConfigManager {
    private static final RemoteConfigManager zzfh = new RemoteConfigManager();
    private static final long zzfi = TimeUnit.SECONDS.toMicros(30L);
    private static final long zzfj = TimeUnit.HOURS.toMillis(12L);
    private boolean zzfk = false;
    private boolean zzfl = false;
    private long zzfm = 0L;
    private zzg<zzu<String, Long>> zzfn = zzh.zza(zzy.zzfs);
    private zzu<String, Long> zzfo = zzu.zzj();
    private final FirebaseRemoteConfig zzfp;
    private final Executor zzfq;
    private final zzbg zzfr;

    private RemoteConfigManager() {
        this(new ThreadPoolExecutor(0, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()), FirebaseRemoteConfig.getInstance(), FirebasePerfProvider.zzda());
    }

    @VisibleForTesting
    private RemoteConfigManager(Executor executor, FirebaseRemoteConfig firebaseRemoteConfig, zzbg zzbg2) {
        this.zzfq = executor;
        this.zzfp = firebaseRemoteConfig;
        this.zzfr = zzbg2;
    }

    public static RemoteConfigManager zzcb() {
        return zzfh;
    }

    @Deprecated
    @WorkerThread
    private final zzu<String, Long> zzcc() {
        this.zzfo = this.zzfn.get();
        this.zzfk = true;
        return this.zzfo;
    }

    public final long zzc(String string, long l) {
        long l2;
        block3: {
            this.zzce();
            l2 = this.zzfo.getOrDefault(zzaz.zzk(string), l);
            if (this.zzch()) {
                String string2 = this.zzfp.getString(zzaz.zzl(string), "configns:fireperf");
                try {
                    l2 = (long)((float)Long.parseLong(string2) * 100.0f);
                    Log.d((String)"FirebasePerformance", (String)new StringBuilder(74 + String.valueOf(string).length()).append("Fetched value: ").append(l2).append(" for key: ").append(string).append(" from firebase remote config.").toString());
                }
                catch (NumberFormatException numberFormatException) {
                    if (string2.isEmpty()) break block3;
                    Log.d((String)"FirebasePerformance", (String)new StringBuilder(45 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Could not parse value: ").append(string2).append(" for key: ").append(string).append(" into a long").toString());
                }
            }
        }
        return l2;
    }

    public final float zza(String string, float f) {
        float f2;
        block3: {
            this.zzce();
            Long l = this.zzfo.get(zzaz.zzk(string));
            float f3 = f2 = l != null ? (float)l.longValue() : f;
            if (this.zzch()) {
                String string2 = this.zzfp.getString(zzaz.zzl(string), "configns:fireperf");
                try {
                    f2 = Float.parseFloat(string2) * 100.0f;
                }
                catch (NumberFormatException numberFormatException) {
                    if (string2.isEmpty()) break block3;
                    Log.d((String)"FirebasePerformance", (String)new StringBuilder(46 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Could not parse value: ").append(string2).append(" for key: ").append(string).append(" into a float").toString());
                }
            }
        }
        return f2;
    }

    @WorkerThread
    public final void zzcd() {
        this.zzcc();
        if (this.zzch()) {
            this.zzci();
        }
    }

    private final void zzce() {
        if (this.zzfk) {
            this.zzcf();
            return;
        }
        this.zzfq.execute(new zzz(this));
    }

    private final void zzcf() {
        if (!this.zzch()) {
            return;
        }
        int n = this.zzfp.getInfo().getLastFetchStatus();
        if ((n == 1 || n == 0) && this.zzcj()) {
            if (this.zzfr.zzdc() > zzfi) {
                this.zzcg();
                return;
            }
        } else if (n == -1 || n == 2) {
            if (!this.zzfl) {
                this.zzfm = System.currentTimeMillis();
                this.zzfl = true;
                this.zzfq.execute(new zzaa(this));
                return;
            }
            if (this.zzcj()) {
                this.zzcg();
            }
        }
    }

    private final void zzcg() {
        this.zzfm = System.currentTimeMillis();
        this.zzfp.fetch().addOnCompleteListener(this.zzfq, (OnCompleteListener)new zzab(this)).addOnFailureListener(this.zzfq, (OnFailureListener)new zzac(this));
    }

    private final boolean zzch() {
        return this.zzfo.getOrDefault(zzaz.zzk("firebase_remote_config_enabled"), 1L) == 1L;
    }

    private final void zzci() {
        if (this.zzfp.activateFetched("configns:fireperf")) {
            Log.d((String)"FirebasePerformance", (String)"Activated Firebase Remote Config Values for the Fireperf Namespace");
        }
    }

    private static zzq<String> zza(Context context, String string) {
        zzr zzr2 = zzq.zzh();
        String[] stringArray = new String[3];
        int n = RemoteConfigManager.zze(context);
        stringArray[0] = new StringBuilder(12 + String.valueOf(string).length()).append(string).append(":").append(n).toString();
        stringArray[1] = string;
        stringArray[2] = "1.0.0.225053256";
        String[] stringArray2 = stringArray;
        for (int i = 0; i < 3; ++i) {
            String string2 = stringArray2[i];
            String string3 = String.valueOf("_fireperf1:");
            String string4 = String.valueOf(string2);
            String string5 = RemoteConfigManager.zzh(string4.length() != 0 ? string3.concat(string4) : new String(string3));
            String string6 = new StringBuilder(16 + String.valueOf(string5).length()).append("fireperf:").append(string5).append("_limits").toString();
            String string7 = null;
            try {
                string7 = zza.zza(context.getContentResolver(), string6, null);
            }
            catch (SecurityException securityException) {
                String string8 = String.valueOf(securityException.getMessage());
                Log.w((String)"FirebasePerformance", (String)(string8.length() != 0 ? "Failed to fetch Gservices flag. SecurityException: ".concat(string8) : new String("Failed to fetch Gservices flag. SecurityException: ")));
            }
            if (string7 == null) continue;
            zzr2.zzb(string7);
        }
        return zzr2.zzi();
    }

    @Nullable
    @VisibleForTesting
    private static String zzh(@Nullable String string) {
        if (string == null) {
            return null;
        }
        try {
            byte[] byArray = MessageDigest.getInstance("SHA-1").digest(string.getBytes());
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray2 = byArray;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte by = byArray2[i];
                stringBuilder.append(String.format("%02x", by));
            }
            return stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static zzu<String, Long> zzc(List<String> list) {
        if (list == null) {
            return zzu.zzj();
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = iterator.next().split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                long l;
                String string;
                String[] stringArray2 = stringArray[i].split(":");
                if (stringArray2.length < 2 || (string = stringArray2[0].trim()).isEmpty() || hashMap.containsKey(string)) continue;
                try {
                    l = Long.parseLong(stringArray2[1].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                if (l < 0L) continue;
                hashMap.put(string, l);
            }
        }
        return zzu.zza(hashMap);
    }

    private final boolean zzcj() {
        return System.currentTimeMillis() - this.zzfm > zzfj;
    }

    @VisibleForTesting
    private static int zze(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return 0;
        }
    }

    final /* synthetic */ void zza(Exception exception) {
        this.zzfm = 0L;
    }

    final /* synthetic */ void zza(Task task) {
        if (task.isSuccessful()) {
            this.zzci();
            this.zzfl = true;
        }
    }

    final /* synthetic */ void zzck() {
        this.zzcc();
        this.zzcf();
    }

    static final /* synthetic */ zzu zzcl() {
        String string = FirebaseApp.getInstance().getOptions().getApplicationId();
        return RemoteConfigManager.zzc(RemoteConfigManager.zza(FirebaseApp.getInstance().getApplicationContext(), string));
    }

    final /* synthetic */ void zzcm() {
        this.zzci();
    }
}

