/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import com.google.android.gms.internal.firebase-perf.zzdi;
import com.google.android.gms.internal.firebase-perf.zzer;
import com.google.android.gms.internal.firebase-perf.zzex;
import com.google.android.gms.internal.firebase-perf.zzgj;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfm
extends zzdi<Long>
implements zzex<Long>,
zzgj,
RandomAccess {
    private static final zzfm zzsy = new zzfm();
    private long[] zzsz;
    private int size;

    zzfm() {
        this(new long[10], 0);
    }

    private zzfm(long[] lArray, int n) {
        this.zzsz = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzgm();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzsz, n2, this.zzsz, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfm)) {
            return super.equals(object);
        }
        zzfm zzfm2 = (zzfm)object;
        if (this.size != zzfm2.size) {
            return false;
        }
        long[] lArray = zzfm2.zzsz;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzsz[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzer.zzav(this.zzsz[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzam(n);
        return this.zzsz[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzgm();
        zzer.checkNotNull(collection);
        if (!(collection instanceof zzfm)) {
            return super.addAll(collection);
        }
        zzfm zzfm2 = (zzfm)collection;
        if (zzfm2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfm2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfm2.size;
        if (n > this.zzsz.length) {
            this.zzsz = Arrays.copyOf(this.zzsz, n);
        }
        System.arraycopy(zzfm2.zzsz, 0, this.zzsz, this.size, zzfm2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzgm();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzsz[i])) continue;
            System.arraycopy(this.zzsz, i + 1, this.zzsz, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzam(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzan(n));
        }
    }

    private final String zzan(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzfm zzfm2 = this;
        zzfm2.zzgm();
        zzfm2.zzam(n);
        long l3 = zzfm2.zzsz[n];
        zzfm2.zzsz[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfm zzfm2 = this;
        zzfm2.zzgm();
        zzfm2.zzam(n);
        long l = zzfm2.zzsz[n];
        if (n < zzfm2.size - 1) {
            System.arraycopy(zzfm2.zzsz, n + 1, zzfm2.zzsz, n, zzfm2.size - n - 1);
        }
        --zzfm2.size;
        ++zzfm2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        int n2 = n;
        zzfm zzfm2 = this;
        zzfm2.zzgm();
        if (n2 < 0 || n2 > zzfm2.size) {
            throw new IndexOutOfBoundsException(zzfm2.zzan(n2));
        }
        if (zzfm2.size < zzfm2.zzsz.length) {
            System.arraycopy(zzfm2.zzsz, n2, zzfm2.zzsz, n2 + 1, zzfm2.size - n2);
        } else {
            long[] lArray = new long[zzfm2.size * 3 / 2 + 1];
            System.arraycopy(zzfm2.zzsz, 0, lArray, 0, n2);
            System.arraycopy(zzfm2.zzsz, n2, lArray, n2 + 1, zzfm2.size - n2);
            zzfm2.zzsz = lArray;
        }
        zzfm2.zzsz[n2] = l2;
        ++zzfm2.size;
        ++zzfm2.modCount;
    }

    @Override
    public final /* synthetic */ zzex zzao(int n) {
        int n2 = n;
        zzfm zzfm2 = this;
        if (n2 < zzfm2.size) {
            throw new IllegalArgumentException();
        }
        return new zzfm(Arrays.copyOf(zzfm2.zzsz, n2), zzfm2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzsy.zzgl();
    }
}

