/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-perf;

import com.google.android.gms.internal.firebase-perf.zzdi;
import com.google.android.gms.internal.firebase-perf.zzer;
import com.google.android.gms.internal.firebase-perf.zzev;
import com.google.android.gms.internal.firebase-perf.zzex;
import com.google.android.gms.internal.firebase-perf.zzgj;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzeq
extends zzdi<Integer>
implements zzev,
zzgj,
RandomAccess {
    private static final zzeq zzru = new zzeq();
    private int[] zzrv;
    private int size;

    public static zzeq zzhz() {
        return zzru;
    }

    zzeq() {
        this(new int[10], 0);
    }

    private zzeq(int[] nArray, int n) {
        this.zzrv = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzgm();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzrv, n2, this.zzrv, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzeq)) {
            return super.equals(object);
        }
        zzeq zzeq2 = (zzeq)object;
        if (this.size != zzeq2.size) {
            return false;
        }
        int[] nArray = zzeq2.zzrv;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzrv[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzrv[i];
        }
        return n;
    }

    @Override
    public final zzev zzak(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzeq(Arrays.copyOf(this.zzrv, n), this.size);
    }

    @Override
    public final int getInt(int n) {
        this.zzam(n);
        return this.zzrv[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzal(int n) {
        this.zzs(this.size, n);
    }

    private final void zzs(int n, int n2) {
        this.zzgm();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzan(n));
        }
        if (this.size < this.zzrv.length) {
            System.arraycopy(this.zzrv, n, this.zzrv, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzrv, 0, nArray, 0, n);
            System.arraycopy(this.zzrv, n, nArray, n + 1, this.size - n);
            this.zzrv = nArray;
        }
        this.zzrv[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzgm();
        zzer.checkNotNull(collection);
        if (!(collection instanceof zzeq)) {
            return super.addAll(collection);
        }
        zzeq zzeq2 = (zzeq)collection;
        if (zzeq2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzeq2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzeq2.size;
        if (n > this.zzrv.length) {
            this.zzrv = Arrays.copyOf(this.zzrv, n);
        }
        System.arraycopy(zzeq2.zzrv, 0, this.zzrv, this.size, zzeq2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzgm();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzrv[i])) continue;
            System.arraycopy(this.zzrv, i + 1, this.zzrv, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzam(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzan(n));
        }
    }

    private final String zzan(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzeq zzeq2 = this;
        zzeq2.zzgm();
        zzeq2.zzam(n);
        int n4 = zzeq2.zzrv[n];
        zzeq2.zzrv[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzeq zzeq2 = this;
        zzeq2.zzgm();
        zzeq2.zzam(n);
        int n2 = zzeq2.zzrv[n];
        if (n < zzeq2.size - 1) {
            System.arraycopy(zzeq2.zzrv, n + 1, zzeq2.zzrv, n, zzeq2.size - n - 1);
        }
        --zzeq2.size;
        ++zzeq2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzs(n, n2);
    }

    @Override
    public final /* synthetic */ zzex zzao(int n) {
        return this.zzak(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzru.zzgl();
    }
}

