/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzf;
import com.google.firebase.messaging.RemoteMessage;
import java.util.regex.Pattern;

public class FirebaseMessaging {
    public static final String INSTANCE_ID_SCOPE = "FCM";
    private static final Pattern zzbSX = Pattern.compile("[a-zA-Z0-9-_.~%]{1,900}");
    private static FirebaseMessaging zzbSY;
    private final FirebaseInstanceId zzbSB;
    private PendingIntent zzbSZ;

    public static synchronized FirebaseMessaging getInstance() {
        if (zzbSY == null) {
            zzbSY = new FirebaseMessaging(FirebaseInstanceId.getInstance());
        }
        return zzbSY;
    }

    private FirebaseMessaging(FirebaseInstanceId firebaseInstanceId) {
        this.zzbSB = firebaseInstanceId;
    }

    public void subscribeToTopic(String string) {
        if (string != null && string.startsWith("/topics/")) {
            Log.w((String)"FirebaseMessaging", (String)"Format /topics/topic-name is deprecated. Only 'topic-name' should be used in subscribeToTopic.");
            string = string.substring("/topics/".length());
        }
        if (string == null || !zzbSX.matcher(string).matches()) {
            String string2 = string;
            String string3 = String.valueOf("[a-zA-Z0-9-_.~%]{1,900}");
            throw new IllegalArgumentException(new StringBuilder(55 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Invalid topic name: ").append(string2).append(" does not match the allowed format ").append(string3).toString());
        }
        String string4 = String.valueOf("S!");
        String string5 = String.valueOf(string);
        FirebaseInstanceId.getInstance().zziy(string5.length() != 0 ? string4.concat(string5) : new String(string4));
    }

    public void unsubscribeFromTopic(String string) {
        if (string != null && string.startsWith("/topics/")) {
            Log.w((String)"FirebaseMessaging", (String)"Format /topics/topic-name is deprecated. Only 'topic-name' should be used in unsubscribeFromTopic.");
            string = string.substring("/topics/".length());
        }
        if (string == null || !zzbSX.matcher(string).matches()) {
            String string2 = string;
            String string3 = String.valueOf("[a-zA-Z0-9-_.~%]{1,900}");
            throw new IllegalArgumentException(new StringBuilder(55 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Invalid topic name: ").append(string2).append(" does not match the allowed format ").append(string3).toString());
        }
        String string4 = String.valueOf("U!");
        String string5 = String.valueOf(string);
        FirebaseInstanceId.getInstance().zziy(string5.length() != 0 ? string4.concat(string5) : new String(string4));
    }

    public void send(RemoteMessage remoteMessage) {
        if (TextUtils.isEmpty((CharSequence)remoteMessage.getTo())) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Context context = FirebaseApp.getInstance().getApplicationContext();
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        this.zzk(context, intent);
        intent.setPackage(zzf.zzaX((Context)context));
        remoteMessage.zzF(intent);
        context.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    private synchronized void zzk(Context context, Intent intent) {
        if (this.zzbSZ == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzbSZ = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzbSZ);
    }
}

