/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.GmsRpc;
import com.google.firebase.messaging.Metadata;
import com.google.firebase.messaging.TopicOperation;
import com.google.firebase.messaging.TopicsStore;
import com.google.firebase.messaging.TopicsSyncTask;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class TopicsSubscriber {
    static final String ERROR_INTERNAL_SERVER_ERROR = "INTERNAL_SERVER_ERROR";
    static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    private static final long RPC_TIMEOUT_SEC = 30L;
    private static final long MIN_DELAY_SEC = 30L;
    private static final long MAX_DELAY_SEC = TimeUnit.HOURS.toSeconds(8L);
    private final Context context;
    private final Metadata metadata;
    private final GmsRpc rpc;
    private final FirebaseMessaging firebaseMessaging;
    @GuardedBy(value="pendingOperations")
    private final Map<String, ArrayDeque<TaskCompletionSource<Void>>> pendingOperations = new ArrayMap();
    private final ScheduledExecutorService syncExecutor;
    @GuardedBy(value="this")
    private boolean syncScheduledOrRunning = false;
    private final TopicsStore store;

    @VisibleForTesting
    static Task<TopicsSubscriber> createInstance(FirebaseMessaging firebaseMessaging, Metadata metadata, GmsRpc rpc, Context context, @NonNull ScheduledExecutorService syncExecutor) {
        return Tasks.call((Executor)syncExecutor, () -> {
            TopicsStore topicsStore = TopicsStore.getInstance(context, syncExecutor);
            TopicsSubscriber topicsSubscriber = new TopicsSubscriber(firebaseMessaging, metadata, topicsStore, rpc, context, syncExecutor);
            return topicsSubscriber;
        });
    }

    private TopicsSubscriber(FirebaseMessaging firebaseMessaging, Metadata metadata, TopicsStore store, GmsRpc rpc, Context context, @NonNull ScheduledExecutorService syncExecutor) {
        this.firebaseMessaging = firebaseMessaging;
        this.metadata = metadata;
        this.store = store;
        this.rpc = rpc;
        this.context = context;
        this.syncExecutor = syncExecutor;
    }

    Task<Void> subscribeToTopic(String topic) {
        Task<Void> task = this.scheduleTopicOperation(TopicOperation.subscribe(topic));
        this.startTopicsSyncIfNecessary();
        return task;
    }

    Task<Void> unsubscribeFromTopic(String topic) {
        Task<Void> task = this.scheduleTopicOperation(TopicOperation.unsubscribe(topic));
        this.startTopicsSyncIfNecessary();
        return task;
    }

    @VisibleForTesting
    Task<Void> scheduleTopicOperation(TopicOperation topicOperation) {
        this.store.addTopicOperation(topicOperation);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.addToPendingOperations(topicOperation, (TaskCompletionSource<Void>)taskCompletionSource);
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPendingOperations(TopicOperation topicOperation, TaskCompletionSource<Void> taskCompletionSource) {
        Map<String, ArrayDeque<TaskCompletionSource<Void>>> map = this.pendingOperations;
        synchronized (map) {
            ArrayDeque<Object> list;
            String key = topicOperation.serialize();
            if (this.pendingOperations.containsKey(key)) {
                list = this.pendingOperations.get(key);
            } else {
                list = new ArrayDeque();
                this.pendingOperations.put(key, list);
            }
            list.add(taskCompletionSource);
        }
    }

    boolean hasPendingOperation() {
        return this.store.getNextTopicOperation() != null;
    }

    void startTopicsSyncIfNecessary() {
        if (this.hasPendingOperation()) {
            this.startSync();
        }
    }

    private void startSync() {
        if (!this.isSyncScheduledOrRunning()) {
            this.syncWithDelaySecondsInternal(0L);
        }
    }

    void syncWithDelaySecondsInternal(long delaySeconds) {
        long retryDelaySeconds = Math.min(Math.max(30L, delaySeconds * 2L), MAX_DELAY_SEC);
        TopicsSyncTask syncTask = new TopicsSyncTask(this, this.context, this.metadata, retryDelaySeconds);
        this.scheduleSyncTaskWithDelaySeconds(syncTask, delaySeconds);
        this.setSyncScheduledOrRunning(true);
    }

    void scheduleSyncTaskWithDelaySeconds(Runnable task, long delaySeconds) {
        this.syncExecutor.schedule(task, delaySeconds, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    boolean syncTopics() throws IOException {
        while (true) {
            TopicOperation pendingTopicOperation;
            TopicsSubscriber topicsSubscriber = this;
            synchronized (topicsSubscriber) {
                pendingTopicOperation = this.store.getNextTopicOperation();
                if (pendingTopicOperation == null) {
                    if (TopicsSubscriber.isDebugLogEnabled()) {
                        Log.d((String)"FirebaseMessaging", (String)"topic sync succeeded");
                    }
                    return true;
                }
            }
            if (!this.performTopicOperation(pendingTopicOperation)) {
                return false;
            }
            this.store.removeTopicOperation(pendingTopicOperation);
            this.markCompletePendingOperation(pendingTopicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markCompletePendingOperation(TopicOperation topicOperation) {
        Map<String, ArrayDeque<TaskCompletionSource<Void>>> map = this.pendingOperations;
        synchronized (map) {
            String key = topicOperation.serialize();
            if (!this.pendingOperations.containsKey(key)) {
                return;
            }
            ArrayDeque<TaskCompletionSource<Void>> list = this.pendingOperations.get(key);
            TaskCompletionSource<Void> taskCompletionSource = list.poll();
            if (taskCompletionSource != null) {
                taskCompletionSource.setResult(null);
            }
            if (list.isEmpty()) {
                this.pendingOperations.remove(key);
            }
        }
    }

    @WorkerThread
    boolean performTopicOperation(TopicOperation topicOperation) throws IOException {
        try {
            switch (topicOperation.getOperation()) {
                case "S": {
                    this.blockingSubscribeToTopic(topicOperation.getTopic());
                    if (TopicsSubscriber.isDebugLogEnabled()) {
                        Log.d((String)"FirebaseMessaging", (String)("Subscribe to topic: " + topicOperation.getTopic() + " succeeded."));
                    }
                    break;
                }
                case "U": {
                    this.blockingUnsubscribeFromTopic(topicOperation.getTopic());
                    if (TopicsSubscriber.isDebugLogEnabled()) {
                        Log.d((String)"FirebaseMessaging", (String)("Unsubscribe from topic: " + topicOperation.getTopic() + " succeeded."));
                    }
                    break;
                }
                default: {
                    if (TopicsSubscriber.isDebugLogEnabled()) {
                        Log.d((String)"FirebaseMessaging", (String)("Unknown topic operation" + topicOperation + "."));
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            if (ERROR_SERVICE_NOT_AVAILABLE.equals(e.getMessage()) || ERROR_INTERNAL_SERVER_ERROR.equals(e.getMessage()) || "TOO_MANY_SUBSCRIBERS".equals(e.getMessage())) {
                Log.e((String)"FirebaseMessaging", (String)("Topic operation failed: " + e.getMessage() + ". Will retry Topic operation."));
                return false;
            }
            if (e.getMessage() == null) {
                Log.e((String)"FirebaseMessaging", (String)"Topic operation failed without exception message. Will retry Topic operation.");
                return false;
            }
            throw e;
        }
        return true;
    }

    @WorkerThread
    private void blockingSubscribeToTopic(String topic) throws IOException {
        TopicsSubscriber.awaitTask(this.rpc.subscribeToTopic(this.firebaseMessaging.blockingGetToken(), topic));
    }

    @WorkerThread
    private void blockingUnsubscribeFromTopic(String topic) throws IOException {
        TopicsSubscriber.awaitTask(this.rpc.unsubscribeFromTopic(this.firebaseMessaging.blockingGetToken(), topic));
    }

    @WorkerThread
    private static <T> void awaitTask(Task<T> task) throws IOException {
        try {
            Tasks.await(task, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IOException(e);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE, e);
        }
    }

    synchronized boolean isSyncScheduledOrRunning() {
        return this.syncScheduledOrRunning;
    }

    synchronized void setSyncScheduledOrRunning(boolean value) {
        this.syncScheduledOrRunning = value;
    }

    static boolean isDebugLogEnabled() {
        return Log.isLoggable((String)"FirebaseMessaging", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseMessaging", (int)3);
    }

    @VisibleForTesting
    TopicsStore getStore() {
        return this.store;
    }
}

