/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.firebase.messaging.GmsRpc;

final class ProxyNotificationPreferences {
    private static final String FCM_PREFERENCES = "com.google.firebase.messaging";

    private ProxyNotificationPreferences() {
    }

    private static SharedPreferences getPreference(Context context) {
        Context appContext = context.getApplicationContext();
        if (appContext == null) {
            appContext = context;
        }
        return appContext.getSharedPreferences(FCM_PREFERENCES, 0);
    }

    @WorkerThread
    static void setProxyNotificationsInitialized(Context context, boolean isInitialized) {
        SharedPreferences.Editor preferencesEditor = ProxyNotificationPreferences.getPreference(context).edit();
        preferencesEditor.putBoolean("proxy_notification_initialized", isInitialized);
        preferencesEditor.apply();
    }

    @WorkerThread
    static void setProxyRetention(Context context, GmsRpc gmsRpc, boolean retention) {
        if (!PlatformVersion.isAtLeastQ()) {
            return;
        }
        SharedPreferences preferences = ProxyNotificationPreferences.getPreference(context);
        if (!ProxyNotificationPreferences.isProxyNotificationRetentionSet(preferences, retention)) {
            gmsRpc.setRetainProxiedNotifications(retention).addOnSuccessListener(Runnable::run, unused -> ProxyNotificationPreferences.setProxyRetentionPreferences(context, retention));
        }
    }

    @WorkerThread
    static boolean isProxyNotificationInitialized(Context context) {
        return ProxyNotificationPreferences.getPreference(context).getBoolean("proxy_notification_initialized", false);
    }

    @WorkerThread
    static boolean isProxyNotificationRetentionSet(SharedPreferences preferences, boolean retention) {
        return preferences.contains("proxy_retention") && preferences.getBoolean("proxy_retention", false) == retention;
    }

    @WorkerThread
    static void setProxyRetentionPreferences(Context context, boolean retention) {
        SharedPreferences.Editor preferencesEditor = ProxyNotificationPreferences.getPreference(context).edit();
        preferencesEditor.putBoolean("proxy_retention", retention);
        preferencesEditor.apply();
    }
}

