/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.messaging.Constants;
import com.google.firebase.messaging.NotificationParams;
import com.google.firebase.messaging.RemoteMessageCreator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="RemoteMessageCreator")
public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final int PRIORITY_UNKNOWN = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_NORMAL = 2;
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new RemoteMessageCreator();
    @SafeParcelable.Field(id=2)
    Bundle bundle;
    private Map<String, String> data;
    private Notification notification;

    @SafeParcelable.Constructor
    public RemoteMessage(@SafeParcelable.Param(id=2) Bundle bundle) {
        this.bundle = bundle;
    }

    void populateSendMessageIntent(Intent intent) {
        intent.putExtras(this.bundle);
    }

    public void writeToParcel(@NonNull Parcel out, int flags) {
        RemoteMessageCreator.writeToParcel(this, out, flags);
    }

    @Nullable
    public String getSenderId() {
        return this.bundle.getString("google.c.sender.id");
    }

    @Nullable
    public String getFrom() {
        return this.bundle.getString("from");
    }

    @Nullable
    public String getTo() {
        return this.bundle.getString("google.to");
    }

    @NonNull
    public Map<String, String> getData() {
        if (this.data == null) {
            this.data = Constants.MessagePayloadKeys.extractDeveloperDefinedPayload(this.bundle);
        }
        return this.data;
    }

    @ShowFirstParty
    @Nullable
    public byte[] getRawData() {
        return this.bundle.getByteArray("rawData");
    }

    @Nullable
    public String getCollapseKey() {
        return this.bundle.getString("collapse_key");
    }

    @Nullable
    public String getMessageId() {
        String messageId = this.bundle.getString("google.message_id");
        if (messageId == null) {
            messageId = this.bundle.getString("message_id");
        }
        return messageId;
    }

    @Nullable
    public String getMessageType() {
        return this.bundle.getString("message_type");
    }

    public long getSentTime() {
        Object sentTime = this.bundle.get("google.sent_time");
        if (sentTime instanceof Long) {
            return (Long)sentTime;
        }
        if (sentTime instanceof String) {
            try {
                return Long.parseLong((String)sentTime);
            }
            catch (NumberFormatException e) {
                Log.w((String)"FirebaseMessaging", (String)("Invalid sent time: " + sentTime));
            }
        }
        return 0L;
    }

    public int getTtl() {
        Object ttl = this.bundle.get("google.ttl");
        if (ttl instanceof Integer) {
            return (Integer)ttl;
        }
        if (ttl instanceof String) {
            try {
                return Integer.parseInt((String)ttl);
            }
            catch (NumberFormatException e) {
                Log.w((String)"FirebaseMessaging", (String)("Invalid TTL: " + ttl));
            }
        }
        return 0;
    }

    public int getOriginalPriority() {
        String originalPriority = this.bundle.getString("google.original_priority");
        if (originalPriority == null) {
            originalPriority = this.bundle.getString("google.priority");
        }
        return this.getMessagePriority(originalPriority);
    }

    public int getPriority() {
        String priority = this.bundle.getString("google.delivered_priority");
        if (priority == null) {
            if ("1".equals(this.bundle.getString("google.priority_reduced"))) {
                return 2;
            }
            priority = this.bundle.getString("google.priority");
        }
        return this.getMessagePriority(priority);
    }

    private int getMessagePriority(String priority) {
        if ("high".equals(priority)) {
            return 1;
        }
        if ("normal".equals(priority)) {
            return 2;
        }
        return 0;
    }

    @Nullable
    public Notification getNotification() {
        if (this.notification == null && NotificationParams.isNotification(this.bundle)) {
            this.notification = new Notification(new NotificationParams(this.bundle));
        }
        return this.notification;
    }

    @KeepForSdk
    public Intent toIntent() {
        Intent intent = new Intent();
        intent.putExtras(this.bundle);
        return intent;
    }

    public static class Notification {
        private final String title;
        private final String titleLocKey;
        private final String[] titleLocArgs;
        private final String body;
        private final String bodyLocKey;
        private final String[] bodyLocArgs;
        private final String icon;
        private final String imageUrl;
        private final String sound;
        private final String tag;
        private final String color;
        private final String clickAction;
        private final String channelId;
        private final Uri link;
        private final String ticker;
        private final Integer notificationPriority;
        private final Integer visibility;
        private final Integer notificationCount;
        private final int[] lightSettings;
        private final Long eventTime;
        private final boolean sticky;
        private final boolean localOnly;
        private final boolean defaultSound;
        private final boolean defaultVibrateTimings;
        private final boolean defaultLightSettings;
        private final long[] vibrateTimings;

        private Notification(NotificationParams params) {
            this.title = params.getString("gcm.n.title");
            this.titleLocKey = params.getLocalizationResourceForKey("gcm.n.title");
            this.titleLocArgs = Notification.getLocalizationArgs(params, "gcm.n.title");
            this.body = params.getString("gcm.n.body");
            this.bodyLocKey = params.getLocalizationResourceForKey("gcm.n.body");
            this.bodyLocArgs = Notification.getLocalizationArgs(params, "gcm.n.body");
            this.icon = params.getString("gcm.n.icon");
            this.sound = params.getSoundResourceName();
            this.tag = params.getString("gcm.n.tag");
            this.color = params.getString("gcm.n.color");
            this.clickAction = params.getString("gcm.n.click_action");
            this.channelId = params.getString("gcm.n.android_channel_id");
            this.link = params.getLink();
            this.imageUrl = params.getString("gcm.n.image");
            this.ticker = params.getString("gcm.n.ticker");
            this.notificationPriority = params.getInteger("gcm.n.notification_priority");
            this.visibility = params.getInteger("gcm.n.visibility");
            this.notificationCount = params.getInteger("gcm.n.notification_count");
            this.sticky = params.getBoolean("gcm.n.sticky");
            this.localOnly = params.getBoolean("gcm.n.local_only");
            this.defaultSound = params.getBoolean("gcm.n.default_sound");
            this.defaultVibrateTimings = params.getBoolean("gcm.n.default_vibrate_timings");
            this.defaultLightSettings = params.getBoolean("gcm.n.default_light_settings");
            this.eventTime = params.getLong("gcm.n.event_time");
            this.lightSettings = params.getLightSettings();
            this.vibrateTimings = params.getVibrateTimings();
        }

        private static String[] getLocalizationArgs(NotificationParams params, String key) {
            Object[] args = params.getLocalizationArgsForKey(key);
            if (args == null) {
                return null;
            }
            String[] stringArgs = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                stringArgs[i] = String.valueOf(args[i]);
            }
            return stringArgs;
        }

        @Nullable
        public String getTitle() {
            return this.title;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.titleLocKey;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.titleLocArgs;
        }

        @Nullable
        public String getBody() {
            return this.body;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.bodyLocKey;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.bodyLocArgs;
        }

        @Nullable
        public String getIcon() {
            return this.icon;
        }

        @Nullable
        public Uri getImageUrl() {
            return this.imageUrl != null ? Uri.parse((String)this.imageUrl) : null;
        }

        @Nullable
        public String getSound() {
            return this.sound;
        }

        @Nullable
        public String getTag() {
            return this.tag;
        }

        @Nullable
        public String getColor() {
            return this.color;
        }

        @Nullable
        public String getClickAction() {
            return this.clickAction;
        }

        @Nullable
        public String getChannelId() {
            return this.channelId;
        }

        @Nullable
        public Uri getLink() {
            return this.link;
        }

        @Nullable
        public String getTicker() {
            return this.ticker;
        }

        public boolean getSticky() {
            return this.sticky;
        }

        public boolean getLocalOnly() {
            return this.localOnly;
        }

        public boolean getDefaultSound() {
            return this.defaultSound;
        }

        public boolean getDefaultVibrateSettings() {
            return this.defaultVibrateTimings;
        }

        public boolean getDefaultLightSettings() {
            return this.defaultLightSettings;
        }

        @Nullable
        public Integer getNotificationPriority() {
            return this.notificationPriority;
        }

        @Nullable
        public Integer getVisibility() {
            return this.visibility;
        }

        @Nullable
        public Integer getNotificationCount() {
            return this.notificationCount;
        }

        @Nullable
        public Long getEventTime() {
            return this.eventTime;
        }

        @Nullable
        public int[] getLightSettings() {
            return this.lightSettings;
        }

        @Nullable
        public long[] getVibrateTimings() {
            return this.vibrateTimings;
        }
    }

    public static class Builder {
        private final Bundle bundle = new Bundle();
        private final Map<String, String> data = new ArrayMap();

        public Builder(@NonNull String to) {
            if (TextUtils.isEmpty((CharSequence)to)) {
                throw new IllegalArgumentException("Invalid to: " + to);
            }
            this.bundle.putString("google.to", to);
        }

        @NonNull
        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.data.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.bundle);
            this.bundle.remove("from");
            return new RemoteMessage(bundle);
        }

        @NonNull
        public Builder addData(@NonNull String key, @Nullable String value) {
            this.data.put(key, value);
            return this;
        }

        @NonNull
        public Builder setData(@NonNull Map<String, String> data) {
            this.data.clear();
            this.data.putAll(data);
            return this;
        }

        @NonNull
        public Map<String, String> getData() {
            return this.data;
        }

        @NonNull
        public Builder clearData() {
            this.data.clear();
            return this;
        }

        @NonNull
        public String getMessageId() {
            return this.bundle.getString("google.message_id", "");
        }

        @Nullable
        public String getMessageType() {
            return this.bundle.getString("message_type");
        }

        @Nullable
        public String getCollapseKey() {
            return this.bundle.getString("message_type");
        }

        @IntRange(from=0L, to=86400L)
        public int getTtl() {
            return Integer.parseInt(this.bundle.getString("message_type", "0"));
        }

        @ShowFirstParty
        @NonNull
        public Builder setRawData(byte[] data) {
            this.bundle.putByteArray("rawData", data);
            return this;
        }

        @NonNull
        public Builder setMessageId(@NonNull String messageId) {
            this.bundle.putString("google.message_id", messageId);
            return this;
        }

        @NonNull
        public Builder setMessageType(@Nullable String messageType) {
            this.bundle.putString("message_type", messageType);
            return this;
        }

        @NonNull
        public Builder setTtl(@IntRange(from=0L, to=86400L) int ttl) {
            this.bundle.putString("google.ttl", String.valueOf(ttl));
            return this;
        }

        @NonNull
        public Builder setCollapseKey(@Nullable String collapseKey) {
            this.bundle.putString("collapse_key", collapseKey);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessagePriority {
    }
}

