/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.messaging.WakeLockHolder;
import com.google.firebase.messaging.WithinAppServiceBinder;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

class WithinAppServiceConnection
implements ServiceConnection {
    private static final int REQUEST_TIMEOUT_MS = 9000;
    private final Context context;
    private final Intent connectionIntent;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Queue<BindRequest> intentQueue = new ArrayDeque<BindRequest>();
    @Nullable
    private WithinAppServiceBinder binder;
    @GuardedBy(value="this")
    private boolean connectionInProgress = false;

    @SuppressLint(value={"ThreadPoolCreation"})
    WithinAppServiceConnection(Context context, String action) {
        this(context, action, new ScheduledThreadPoolExecutor(0, (ThreadFactory)new NamedThreadFactory("Firebase-FirebaseInstanceIdServiceConnection")));
    }

    @VisibleForTesting
    WithinAppServiceConnection(Context context, String action, ScheduledExecutorService scheduledExecutorService) {
        this.context = context.getApplicationContext();
        this.connectionIntent = new Intent(action).setPackage(this.context.getPackageName());
        this.scheduledExecutorService = scheduledExecutorService;
    }

    synchronized Task<Void> sendIntent(Intent intent) {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"new intent queued in the bind-strategy delivery");
        }
        BindRequest req = new BindRequest(intent);
        req.arrangeTimeout(this.scheduledExecutorService);
        this.intentQueue.add(req);
        this.flushQueue();
        return req.getTask();
    }

    private synchronized void flushQueue() {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"flush queue called");
        }
        while (!this.intentQueue.isEmpty()) {
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)"found intent to be delivered");
            }
            if (this.binder != null && this.binder.isBinderAlive()) {
                if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                    Log.d((String)"FirebaseMessaging", (String)"binder is alive, sending the intent.");
                }
                BindRequest bindRequest = this.intentQueue.poll();
                this.binder.send(bindRequest);
                continue;
            }
            this.startConnectionIfNeeded();
            return;
        }
    }

    @GuardedBy(value="this")
    private void startConnectionIfNeeded() {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)("binder is dead. start connection? " + !this.connectionInProgress));
        }
        if (this.connectionInProgress) {
            return;
        }
        this.connectionInProgress = true;
        try {
            if (ConnectionTracker.getInstance().bindService(this.context, this.connectionIntent, (ServiceConnection)this, 65)) {
                return;
            }
            Log.e((String)"FirebaseMessaging", (String)"binding to the service failed");
        }
        catch (SecurityException e) {
            Log.e((String)"FirebaseMessaging", (String)"Exception while binding the service", (Throwable)e);
        }
        this.connectionInProgress = false;
        this.finishAllInQueue();
    }

    @GuardedBy(value="this")
    private void finishAllInQueue() {
        while (!this.intentQueue.isEmpty()) {
            this.intentQueue.poll().finish();
        }
    }

    public synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)("onServiceConnected: " + componentName));
        }
        this.connectionInProgress = false;
        if (!(iBinder instanceof WithinAppServiceBinder)) {
            Log.e((String)"FirebaseMessaging", (String)("Invalid service connection: " + iBinder));
            this.finishAllInQueue();
            return;
        }
        this.binder = (WithinAppServiceBinder)iBinder;
        this.flushQueue();
    }

    public void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)("onServiceDisconnected: " + componentName));
        }
        this.flushQueue();
    }

    static class BindRequest {
        final Intent intent;
        private final TaskCompletionSource<Void> taskCompletionSource = new TaskCompletionSource();

        BindRequest(Intent intent) {
            this.intent = intent;
        }

        void arrangeTimeout(ScheduledExecutorService executor) {
            boolean isHighPriority = (this.intent.getFlags() & 0x10000000) != 0;
            ScheduledFuture<?> timeoutFuture = executor.schedule(() -> {
                Log.w((String)"FirebaseMessaging", (String)("Service took too long to process intent: " + this.intent.getAction() + " Releasing WakeLock."));
                this.finish();
            }, isHighPriority ? WakeLockHolder.WAKE_LOCK_ACQUIRE_TIMEOUT_MILLIS : 9000L, TimeUnit.MILLISECONDS);
            this.getTask().addOnCompleteListener((Executor)executor, t -> timeoutFuture.cancel(false));
        }

        Task<Void> getTask() {
            return this.taskCompletionSource.getTask();
        }

        void finish() {
            this.taskCompletionSource.trySetResult(null);
        }
    }
}

