/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.Drawable;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.google.firebase.messaging.NotificationParams;
import java.util.concurrent.atomic.AtomicInteger;

public final class CommonNotificationBuilder {
    public static final String METADATA_DEFAULT_COLOR = "com.google.firebase.messaging.default_notification_color";
    public static final String METADATA_DEFAULT_ICON = "com.google.firebase.messaging.default_notification_icon";
    public static final String METADATA_DEFAULT_CHANNEL_ID = "com.google.firebase.messaging.default_notification_channel_id";
    public static final String FCM_FALLBACK_NOTIFICATION_CHANNEL = "fcm_fallback_notification_channel";
    public static final String FCM_FALLBACK_NOTIFICATION_CHANNEL_LABEL = "fcm_fallback_notification_channel_label";
    private static final String FCM_FALLBACK_NOTIFICATION_CHANNEL_NAME_NO_RESOURCE = "Misc";
    private static final String ACTION_MESSAGING_EVENT = "com.google.firebase.MESSAGING_EVENT";
    private static final int ILLEGAL_RESOURCE_ID = 0;
    private static final AtomicInteger requestCodeProvider = new AtomicInteger((int)SystemClock.elapsedRealtime());

    private CommonNotificationBuilder() {
    }

    static DisplayNotificationInfo createNotificationInfo(Context context, NotificationParams params) {
        Bundle manifestMetadata = CommonNotificationBuilder.getManifestMetadata(context.getPackageManager(), context.getPackageName());
        return CommonNotificationBuilder.createNotificationInfo(context, context.getPackageName(), params, CommonNotificationBuilder.getOrCreateChannel(context, params.getNotificationChannelId(), manifestMetadata), context.getResources(), context.getPackageManager(), manifestMetadata);
    }

    public static DisplayNotificationInfo createNotificationInfo(Context context, String pkgName, NotificationParams params, String channelId, Resources appResources, PackageManager appPackageManager, Bundle manifestMetadata) {
        int[] lightSettings;
        long[] vibrateTimings;
        Long eventTime;
        Integer notificationCount;
        Integer visibility;
        Integer notificationPriority;
        boolean sticky;
        Integer color;
        String body;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, channelId);
        String title = params.getPossiblyLocalizedString(appResources, pkgName, "gcm.n.title");
        if (!TextUtils.isEmpty((CharSequence)title)) {
            builder.setContentTitle((CharSequence)title);
        }
        if (!TextUtils.isEmpty((CharSequence)(body = params.getPossiblyLocalizedString(appResources, pkgName, "gcm.n.body")))) {
            builder.setContentText((CharSequence)body);
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)body));
        }
        int smallIcon = CommonNotificationBuilder.getSmallIcon(appPackageManager, appResources, pkgName, params.getString("gcm.n.icon"), manifestMetadata);
        builder.setSmallIcon(smallIcon);
        Uri sound = CommonNotificationBuilder.getSound(pkgName, params, appResources);
        if (sound != null) {
            builder.setSound(sound);
        }
        builder.setContentIntent(CommonNotificationBuilder.createContentIntent(context, params, pkgName, appPackageManager));
        PendingIntent deleteIntent = CommonNotificationBuilder.createDeleteIntent(context, params);
        if (deleteIntent != null) {
            builder.setDeleteIntent(deleteIntent);
        }
        if ((color = CommonNotificationBuilder.getColor(context, params.getString("gcm.n.color"), manifestMetadata)) != null) {
            builder.setColor(color.intValue());
        }
        builder.setAutoCancel(!(sticky = params.getBoolean("gcm.n.sticky")));
        boolean localOnly = params.getBoolean("gcm.n.local_only");
        builder.setLocalOnly(localOnly);
        String ticker = params.getString("gcm.n.ticker");
        if (ticker != null) {
            builder.setTicker((CharSequence)ticker);
        }
        if ((notificationPriority = params.getNotificationPriority()) != null) {
            builder.setPriority(notificationPriority.intValue());
        }
        if ((visibility = params.getVisibility()) != null) {
            builder.setVisibility(visibility.intValue());
        }
        if ((notificationCount = params.getNotificationCount()) != null) {
            builder.setNumber(notificationCount.intValue());
        }
        if ((eventTime = params.getLong("gcm.n.event_time")) != null) {
            builder.setShowWhen(true);
            builder.setWhen(eventTime.longValue());
        }
        if ((vibrateTimings = params.getVibrateTimings()) != null) {
            builder.setVibrate(vibrateTimings);
        }
        if ((lightSettings = params.getLightSettings()) != null) {
            builder.setLights(lightSettings[0], lightSettings[1], lightSettings[2]);
        }
        builder.setDefaults(CommonNotificationBuilder.getConsolidatedDefaults(params));
        return new DisplayNotificationInfo(builder, CommonNotificationBuilder.getTag(params), 0);
    }

    private static int getConsolidatedDefaults(NotificationParams params) {
        int result = 0;
        if (params.getBoolean("gcm.n.default_sound")) {
            result |= 1;
        }
        if (params.getBoolean("gcm.n.default_vibrate_timings")) {
            result |= 2;
        }
        if (params.getBoolean("gcm.n.default_light_settings")) {
            result |= 4;
        }
        return result;
    }

    @TargetApi(value=26)
    private static boolean isValidIcon(Resources resources, int resId) {
        if (Build.VERSION.SDK_INT != 26) {
            return true;
        }
        try {
            Drawable icon = resources.getDrawable(resId, null);
            if (icon instanceof AdaptiveIconDrawable) {
                Log.e((String)"FirebaseMessaging", (String)("Adaptive icons cannot be used in notifications. Ignoring icon id: " + resId));
                return false;
            }
            return true;
        }
        catch (Resources.NotFoundException ex) {
            Log.e((String)"FirebaseMessaging", (String)("Couldn't find resource " + resId + ", treating it as an invalid icon"));
            return false;
        }
    }

    private static int getSmallIcon(PackageManager packageManager, Resources resources, String pkgName, String resourceKey, Bundle manifestMetadata) {
        int iconId;
        if (!TextUtils.isEmpty((CharSequence)resourceKey)) {
            iconId = resources.getIdentifier(resourceKey, "drawable", pkgName);
            if (iconId != 0 && CommonNotificationBuilder.isValidIcon(resources, iconId)) {
                return iconId;
            }
            iconId = resources.getIdentifier(resourceKey, "mipmap", pkgName);
            if (iconId != 0 && CommonNotificationBuilder.isValidIcon(resources, iconId)) {
                return iconId;
            }
            Log.w((String)"FirebaseMessaging", (String)("Icon resource " + resourceKey + " not found. Notification will use default icon."));
        }
        if ((iconId = manifestMetadata.getInt(METADATA_DEFAULT_ICON, 0)) == 0 || !CommonNotificationBuilder.isValidIcon(resources, iconId)) {
            try {
                iconId = packageManager.getApplicationInfo((String)pkgName, (int)0).icon;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w((String)"FirebaseMessaging", (String)("Couldn't get own application info: " + (Object)((Object)e)));
            }
        }
        if (iconId == 0 || !CommonNotificationBuilder.isValidIcon(resources, iconId)) {
            iconId = 17301651;
        }
        return iconId;
    }

    private static Integer getColor(Context context, String color, Bundle manifestMetadata) {
        int colorResourceId;
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)color)) {
            try {
                return Color.parseColor((String)color);
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"FirebaseMessaging", (String)("Color is invalid: " + color + ". Notification will use default color."));
            }
        }
        if ((colorResourceId = manifestMetadata.getInt(METADATA_DEFAULT_COLOR, 0)) != 0) {
            try {
                return ContextCompat.getColor((Context)context, (int)colorResourceId);
            }
            catch (Resources.NotFoundException e) {
                Log.w((String)"FirebaseMessaging", (String)"Cannot find the color resource referenced in AndroidManifest.");
            }
        }
        return null;
    }

    private static Uri getSound(String pkgName, NotificationParams params, Resources resources) {
        int soundId;
        String soundName = params.getSoundResourceName();
        if (TextUtils.isEmpty((CharSequence)soundName)) {
            return null;
        }
        if (!"default".equals(soundName) && (soundId = resources.getIdentifier(soundName, "raw", pkgName)) != 0) {
            return Uri.parse((String)("android.resource://" + pkgName + "/raw/" + soundName));
        }
        return RingtoneManager.getDefaultUri((int)2);
    }

    @Nullable
    private static PendingIntent createContentIntent(Context context, NotificationParams params, String pkgName, PackageManager pm) {
        Intent intent = CommonNotificationBuilder.createTargetIntent(pkgName, params, pm);
        if (intent == null) {
            return null;
        }
        intent.addFlags(0x4000000);
        intent.putExtras(params.paramsWithReservedKeysRemoved());
        if (CommonNotificationBuilder.shouldUploadMetrics(params)) {
            intent.putExtra("gcm.n.analytics_data", params.paramsForAnalyticsIntent());
        }
        return PendingIntent.getActivity((Context)context, (int)CommonNotificationBuilder.generatePendingIntentRequestCode(), (Intent)intent, (int)CommonNotificationBuilder.getPendingIntentFlags(0x40000000));
    }

    private static Intent createTargetIntent(String pkgName, NotificationParams params, PackageManager pm) {
        String action = params.getString("gcm.n.click_action");
        if (!TextUtils.isEmpty((CharSequence)action)) {
            Intent intent = new Intent(action);
            intent.setPackage(pkgName);
            intent.setFlags(0x10000000);
            return intent;
        }
        Uri link = params.getLink();
        if (link != null) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setPackage(pkgName);
            intent.setData(link);
            return intent;
        }
        Intent intent = pm.getLaunchIntentForPackage(pkgName);
        if (intent == null) {
            Log.w((String)"FirebaseMessaging", (String)"No activity found to launch app");
        }
        return intent;
    }

    private static Bundle getManifestMetadata(PackageManager pm, String packageName) {
        try {
            ApplicationInfo info = pm.getApplicationInfo(packageName, 128);
            if (info != null && info.metaData != null) {
                return info.metaData;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)"FirebaseMessaging", (String)("Couldn't get own application info: " + (Object)((Object)e)));
        }
        return Bundle.EMPTY;
    }

    @TargetApi(value=26)
    @VisibleForTesting
    public static String getOrCreateChannel(Context context, String msgChannel, Bundle manifestMetadata) {
        String manifestChannel;
        if (Build.VERSION.SDK_INT < 26) {
            return null;
        }
        try {
            if (context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)0).targetSdkVersion < 26) {
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService(NotificationManager.class);
        if (!TextUtils.isEmpty((CharSequence)msgChannel)) {
            if (notificationManager.getNotificationChannel(msgChannel) != null) {
                return msgChannel;
            }
            Log.w((String)"FirebaseMessaging", (String)("Notification Channel requested (" + msgChannel + ") has not been created by the app. Manifest configuration, or default, value will be used."));
        }
        if (!TextUtils.isEmpty((CharSequence)(manifestChannel = manifestMetadata.getString(METADATA_DEFAULT_CHANNEL_ID)))) {
            if (notificationManager.getNotificationChannel(manifestChannel) != null) {
                return manifestChannel;
            }
            Log.w((String)"FirebaseMessaging", (String)"Notification Channel set in AndroidManifest.xml has not been created by the app. Default value will be used.");
        } else {
            Log.w((String)"FirebaseMessaging", (String)"Missing Default Notification Channel metadata in AndroidManifest. Default value will be used.");
        }
        if (notificationManager.getNotificationChannel(FCM_FALLBACK_NOTIFICATION_CHANNEL) == null) {
            String defaultChannelName;
            int channelLabelResourceId = context.getResources().getIdentifier(FCM_FALLBACK_NOTIFICATION_CHANNEL_LABEL, "string", context.getPackageName());
            if (channelLabelResourceId == 0) {
                Log.e((String)"FirebaseMessaging", (String)"String resource \"fcm_fallback_notification_channel_label\" is not found. Using default string channel name.");
                defaultChannelName = FCM_FALLBACK_NOTIFICATION_CHANNEL_NAME_NO_RESOURCE;
            } else {
                defaultChannelName = context.getString(channelLabelResourceId);
            }
            notificationManager.createNotificationChannel(new NotificationChannel(FCM_FALLBACK_NOTIFICATION_CHANNEL, (CharSequence)defaultChannelName, 3));
        }
        return FCM_FALLBACK_NOTIFICATION_CHANNEL;
    }

    private static int generatePendingIntentRequestCode() {
        return requestCodeProvider.incrementAndGet();
    }

    private static int getPendingIntentFlags(int baseFlags) {
        return Build.VERSION.SDK_INT >= 23 ? baseFlags | 0x4000000 : baseFlags;
    }

    @Nullable
    private static PendingIntent createDeleteIntent(Context context, NotificationParams params) {
        if (!CommonNotificationBuilder.shouldUploadMetrics(params)) {
            return null;
        }
        Intent dismissIntent = new Intent("com.google.firebase.messaging.NOTIFICATION_DISMISS").putExtras(params.paramsForAnalyticsIntent());
        return CommonNotificationBuilder.createMessagingPendingIntent(context, dismissIntent);
    }

    private static PendingIntent createMessagingPendingIntent(Context context, Intent intent) {
        return PendingIntent.getBroadcast((Context)context, (int)CommonNotificationBuilder.generatePendingIntentRequestCode(), (Intent)new Intent(ACTION_MESSAGING_EVENT).setComponent(new ComponentName(context, "com.google.firebase.iid.FirebaseInstanceIdReceiver")).putExtra("wrapped_intent", (Parcelable)intent), (int)CommonNotificationBuilder.getPendingIntentFlags(0x40000000));
    }

    static boolean shouldUploadMetrics(@NonNull NotificationParams params) {
        return params.getBoolean("google.c.a.e");
    }

    private static String getTag(NotificationParams params) {
        String tag = params.getString("gcm.n.tag");
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            return tag;
        }
        return "FCM-Notification:" + SystemClock.uptimeMillis();
    }

    public static class DisplayNotificationInfo {
        public final NotificationCompat.Builder notificationBuilder;
        public final String tag;
        public final int id;

        DisplayNotificationInfo(NotificationCompat.Builder notificationBuilder, String tag, int id) {
            this.notificationBuilder = notificationBuilder;
            this.tag = tag;
            this.id = id;
        }
    }
}

