/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.messaging.Constants;
import com.google.firebase.messaging.NotificationParams;
import com.google.firebase.messaging.RemoteMessage$Notification-IA;
import com.google.firebase.messaging.RemoteMessageCreator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="RemoteMessageCreator")
public final class RemoteMessage
extends AbstractSafeParcelable {
    public static final int PRIORITY_UNKNOWN = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_NORMAL = 2;
    @NonNull
    public static final Parcelable.Creator<RemoteMessage> CREATOR;
    @SafeParcelable.Field(id=2)
    Bundle bundle;
    private Map<String, String> data;
    private Notification notification;

    private int getMessagePriority(String string) {
        if ("high".equals(string)) {
            return 1;
        }
        if ("normal".equals(string)) {
            return 2;
        }
        return 0;
    }

    public int getOriginalPriority() {
        String string = this.bundle.getString("google.original_priority");
        if (string == null) {
            string = this.bundle.getString("google.priority");
        }
        return this.getMessagePriority(string);
    }

    public int getPriority() {
        String string = this.bundle.getString("google.delivered_priority");
        if (string == null) {
            if ("1".equals(this.bundle.getString("google.priority_reduced"))) {
                return 2;
            }
            string = this.bundle.getString("google.priority");
        }
        return this.getMessagePriority(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTtl() {
        Object object = this.bundle.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (!(object instanceof String)) return 0;
        try {
            return Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            String string = String.valueOf(object);
            String.valueOf(string).length();
            Log.w((String)"FirebaseMessaging", (String)"Invalid TTL: ".concat(String.valueOf(string)));
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getSentTime() {
        Object object = this.bundle.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (!(object instanceof String)) return 0L;
        try {
            return Long.parseLong((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            String string = String.valueOf(object);
            String.valueOf(string).length();
            Log.w((String)"FirebaseMessaging", (String)"Invalid sent time: ".concat(String.valueOf(string)));
            return 0L;
        }
    }

    @KeepForSdk
    @NonNull
    public Intent toIntent() {
        Intent intent = new Intent();
        intent.putExtras(this.bundle);
        return intent;
    }

    @Nullable
    public Notification getNotification() {
        if (this.notification == null && NotificationParams.isNotification(this.bundle)) {
            Notification notification;
            NotificationParams notificationParams = new NotificationParams(this.bundle);
            this.notification = notification = new Notification(notificationParams, null);
        }
        return this.notification;
    }

    @Nullable
    public String getCollapseKey() {
        return this.bundle.getString("collapse_key");
    }

    @Nullable
    public String getFrom() {
        return this.bundle.getString("from");
    }

    @Nullable
    public String getMessageId() {
        String string = this.bundle.getString("google.message_id");
        if (string == null) {
            return this.bundle.getString("message_id");
        }
        return string;
    }

    @Nullable
    public String getMessageType() {
        return this.bundle.getString("message_type");
    }

    @Nullable
    public String getSenderId() {
        return this.bundle.getString("google.c.sender.id");
    }

    @Nullable
    public String getTo() {
        return this.bundle.getString("google.to");
    }

    @NonNull
    public Map<String, String> getData() {
        if (this.data == null) {
            this.data = Constants.MessagePayloadKeys.extractDeveloperDefinedPayload(this.bundle);
        }
        return this.data;
    }

    static {
        RemoteMessageCreator remoteMessageCreator;
        CREATOR = remoteMessageCreator = new RemoteMessageCreator();
    }

    /*
     * WARNING - void declaration
     */
    @SafeParcelable.Constructor
    public RemoteMessage(@SafeParcelable.Param(id=2) @NonNull Bundle bundle) {
        void var1_1;
        this.bundle = var1_1;
    }

    void populateSendMessageIntent(Intent intent) {
        intent.putExtras(this.bundle);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        RemoteMessageCreator.writeToParcel(this, (Parcel)var1_1, (int)var2_2);
    }

    @ShowFirstParty
    @Nullable
    public byte[] getRawData() {
        return this.bundle.getByteArray("rawData");
    }

    public static class Notification {
        private final String title;
        private final String titleLocKey;
        private final String[] titleLocArgs;
        private final String body;
        private final String bodyLocKey;
        private final String[] bodyLocArgs;
        private final String icon;
        private final String imageUrl;
        private final String sound;
        private final String tag;
        private final String color;
        private final String clickAction;
        private final String channelId;
        private final Uri link;
        private final String ticker;
        private final Integer notificationPriority;
        private final Integer visibility;
        private final Integer notificationCount;
        private final int[] lightSettings;
        private final Long eventTime;
        private final boolean sticky;
        private final boolean localOnly;
        private final boolean defaultSound;
        private final boolean defaultVibrateTimings;
        private final boolean defaultLightSettings;
        private final long[] vibrateTimings;

        @Nullable
        public Uri getImageUrl() {
            String this_ = ((Notification)((Object)this_)).imageUrl;
            if (this_ != null) {
                return Uri.parse((String)this_);
            }
            return null;
        }

        @Nullable
        public Uri getLink() {
            return this.link;
        }

        @Nullable
        public Integer getNotificationCount() {
            return this.notificationCount;
        }

        @Nullable
        public Integer getNotificationPriority() {
            return this.notificationPriority;
        }

        @Nullable
        public Integer getVisibility() {
            return this.visibility;
        }

        @Nullable
        public Long getEventTime() {
            return this.eventTime;
        }

        @Nullable
        public String getBody() {
            return this.body;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.bodyLocKey;
        }

        @Nullable
        public String getChannelId() {
            return this.channelId;
        }

        @Nullable
        public String getClickAction() {
            return this.clickAction;
        }

        @Nullable
        public String getColor() {
            return this.color;
        }

        @Nullable
        public String getIcon() {
            return this.icon;
        }

        @Nullable
        public String getSound() {
            return this.sound;
        }

        @Nullable
        public String getTag() {
            return this.tag;
        }

        @Nullable
        public String getTicker() {
            return this.ticker;
        }

        @Nullable
        public String getTitle() {
            return this.title;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.titleLocKey;
        }

        private Notification(NotificationParams notificationParams) {
            this.title = notificationParams.getString("gcm.n.title");
            this.titleLocKey = notificationParams.getLocalizationResourceForKey("gcm.n.title");
            this.titleLocArgs = Notification.getLocalizationArgs(notificationParams, "gcm.n.title");
            this.body = notificationParams.getString("gcm.n.body");
            this.bodyLocKey = notificationParams.getLocalizationResourceForKey("gcm.n.body");
            this.bodyLocArgs = Notification.getLocalizationArgs(notificationParams, "gcm.n.body");
            this.icon = notificationParams.getString("gcm.n.icon");
            this.sound = notificationParams.getSoundResourceName();
            this.tag = notificationParams.getString("gcm.n.tag");
            this.color = notificationParams.getString("gcm.n.color");
            this.clickAction = notificationParams.getString("gcm.n.click_action");
            this.channelId = notificationParams.getString("gcm.n.android_channel_id");
            this.link = notificationParams.getLink();
            this.imageUrl = notificationParams.getString("gcm.n.image");
            this.ticker = notificationParams.getString("gcm.n.ticker");
            this.notificationPriority = notificationParams.getInteger("gcm.n.notification_priority");
            this.visibility = notificationParams.getInteger("gcm.n.visibility");
            this.notificationCount = notificationParams.getInteger("gcm.n.notification_count");
            this.sticky = notificationParams.getBoolean("gcm.n.sticky");
            this.localOnly = notificationParams.getBoolean("gcm.n.local_only");
            this.defaultSound = notificationParams.getBoolean("gcm.n.default_sound");
            this.defaultVibrateTimings = notificationParams.getBoolean("gcm.n.default_vibrate_timings");
            this.defaultLightSettings = notificationParams.getBoolean("gcm.n.default_light_settings");
            this.eventTime = notificationParams.getLong("gcm.n.event_time");
            this.lightSettings = notificationParams.getLightSettings();
            this.vibrateTimings = notificationParams.getVibrateTimings();
        }

        /* synthetic */ Notification(NotificationParams notificationParams, RemoteMessage$Notification-IA remoteMessage$Notification-IA) {
            this(notificationParams);
        }

        public boolean getDefaultLightSettings() {
            return this.defaultLightSettings;
        }

        public boolean getDefaultSound() {
            return this.defaultSound;
        }

        public boolean getDefaultVibrateSettings() {
            return this.defaultVibrateTimings;
        }

        public boolean getLocalOnly() {
            return this.localOnly;
        }

        public boolean getSticky() {
            return this.sticky;
        }

        @Nullable
        public int[] getLightSettings() {
            return this.lightSettings;
        }

        @Nullable
        public long[] getVibrateTimings() {
            return this.vibrateTimings;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.bodyLocArgs;
        }

        private static String[] getLocalizationArgs(NotificationParams notificationParams, String objectArray) {
            if ((objectArray = notificationParams.getLocalizationArgsForKey((String)objectArray)) == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.titleLocArgs;
        }
    }

    public static class Builder {
        private final Bundle bundle;
        private final Map<String, String> data;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addData(@NonNull String key, @Nullable String value) {
            void var2_2;
            void var1_1;
            this.data.put((String)var1_1, (String)var2_2);
            return this;
        }

        @NonNull
        public Builder clearData() {
            this.data.clear();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCollapseKey(@Nullable String collapseKey) {
            void var1_1;
            this.bundle.putString("collapse_key", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setData(@NonNull Map<String, String> data) {
            void var1_1;
            this.data.clear();
            this.data.putAll((Map<String, String>)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMessageId(@NonNull String messageId) {
            void var1_1;
            this.bundle.putString("google.message_id", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMessageType(@Nullable String messageType) {
            void var1_1;
            this.bundle.putString("message_type", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @ShowFirstParty
        @NonNull
        public Builder setRawData(@NonNull byte[] data) {
            void var1_1;
            this.bundle.putByteArray("rawData", (byte[])var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTtl(@IntRange(from=0L, to=86400L) int ttl) {
            void var1_1;
            this.bundle.putString("google.ttl", String.valueOf((int)var1_1));
            return this;
        }

        @NonNull
        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : object.data.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(object.bundle);
            object.bundle.remove("from");
            Object object = new RemoteMessage(bundle);
            return object;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder(@NonNull String to) {
            String string;
            ArrayMap arrayMap;
            Bundle bundle;
            ((Builder)this_).bundle = bundle = new Bundle();
            ((Builder)this_).data = arrayMap = new ArrayMap();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                ((Builder)this_).bundle.putString("google.to", string);
                return;
            }
            Object this_ = String.valueOf(string);
            string = "Invalid to: ";
            this_ = ((String)this_).length() != 0 ? string.concat((String)this_) : new String(string);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException((String)this_);
            throw illegalArgumentException;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessagePriority {
    }
}

