/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Bundle;
import com.google.firebase.messaging.MessagingAnalytics;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

class FcmLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private final Set<Intent> seenIntents;

    FcmLifecycleCallbacks() {
        WeakHashMap weakHashMap = new WeakHashMap();
        this.seenIntents = Collections.newSetFromMap(weakHashMap);
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        if ((activity = activity.getIntent()) == null || !fcmLifecycleCallbacks.seenIntents.add((Intent)activity)) {
            return;
        }
        FcmLifecycleCallbacks fcmLifecycleCallbacks = activity.getExtras();
        if (fcmLifecycleCallbacks != null && MessagingAnalytics.shouldUploadScionMetrics((Bundle)(fcmLifecycleCallbacks = fcmLifecycleCallbacks.getBundle("gcm.n.analytics_data")))) {
            MessagingAnalytics.logNotificationOpen((Bundle)fcmLifecycleCallbacks);
            return;
        }
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
        if (activity.isFinishing()) {
            this.seenIntents.remove(activity.getIntent());
            return;
        }
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }
}

