/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.firebase.messaging.SharedPreferencesQueue;
import com.google.firebase.messaging.TopicOperation;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;

final class TopicsStore {
    @GuardedBy(value="TopicsStore.class")
    private static WeakReference<TopicsStore> topicsStoreWeakReference;
    private final SharedPreferences sharedPreferences;
    private SharedPreferencesQueue topicOperationsQueue;
    private final Executor syncExecutor;

    private TopicsStore(SharedPreferences sharedPreferences, Executor executor) {
        this.syncExecutor = executor;
        this.sharedPreferences = sharedPreferences;
    }

    @WorkerThread
    private synchronized void initStore() {
        this.topicOperationsQueue = SharedPreferencesQueue.createInstance(this.sharedPreferences, "topic_operation_queue", ",", this.syncExecutor);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public static synchronized TopicsStore getInstance(Context object, Executor executor) {
        TopicsStore topicsStore = topicsStoreWeakReference != null ? (TopicsStore)topicsStoreWeakReference.get() : null;
        if (topicsStore == null) {
            void var1_3;
            SharedPreferences sharedPreferences = object.getSharedPreferences("com.google.android.gms.appid", 0);
            topicsStore = new TopicsStore(sharedPreferences, (Executor)var1_3);
            topicsStore.initStore();
            WeakReference<TopicsStore> weakReference = new WeakReference<TopicsStore>(topicsStore);
            topicsStoreWeakReference = weakReference;
            return topicsStore;
        }
        return topicsStore;
    }

    @Nullable
    synchronized TopicOperation getNextTopicOperation() {
        return TopicOperation.from(this.topicOperationsQueue.peek());
    }

    synchronized boolean addTopicOperation(TopicOperation topicOperation) {
        return this.topicOperationsQueue.add(topicOperation.serialize());
    }

    synchronized boolean removeTopicOperation(TopicOperation topicOperation) {
        return this.topicOperationsQueue.remove(topicOperation.serialize());
    }
}

