/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.Event;
import com.google.android.datatransport.Transport;
import com.google.android.datatransport.TransportFactory;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.encoders.DataEncoder;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder;
import com.google.firebase.installations.FirebaseInstallations;
import com.google.firebase.messaging.Constants;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirelogAnalyticsEvent;
import com.google.firebase.messaging.MessagingAnalytics$$Lambda$0;
import com.google.firebase.messaging.NotificationParams;
import java.util.concurrent.ExecutionException;

public class MessagingAnalytics {
    private static final DataEncoder dataEncoder;

    public static void logNotificationReceived(Intent intent) {
        Intent intent2;
        if (MessagingAnalytics.shouldUploadScionMetrics(intent)) {
            MessagingAnalytics.logToScion("_nr", intent2);
        }
        if (MessagingAnalytics.shouldUploadFirelogAnalytics(intent2)) {
            TransportFactory transportFactory = FirebaseMessaging.getTransportFactory();
            if (transportFactory != null) {
                MessagingAnalytics.logToFirelog("MESSAGE_DELIVERED", intent2, (Transport<String>)transportFactory.getTransport("FCM_CLIENT_EVENT_LOGGING", String.class, Encoding.of((String)"json"), MessagingAnalytics$$Lambda$0.$instance));
                return;
            }
            Log.e((String)"FirebaseMessaging", (String)"TransportFactory is null. Skip exporting message delivery metrics to Big Query");
            return;
        }
    }

    public static void logNotificationOpen(Intent intent) {
        Intent intent2;
        MessagingAnalytics.setUserPropertyIfRequired(intent);
        MessagingAnalytics.logToScion("_no", intent2);
    }

    public static void logNotificationDismiss(Intent intent) {
        Intent intent2;
        MessagingAnalytics.logToScion("_nd", intent2);
    }

    public static void logNotificationForeground(Intent intent) {
        Intent intent2;
        MessagingAnalytics.logToScion("_nf", intent2);
    }

    public static boolean shouldUploadScionMetrics(Intent intent) {
        Intent intent2;
        if (intent == null || MessagingAnalytics.isDirectBootMessage(intent2)) {
            return false;
        }
        return "1".equals(intent2.getStringExtra("google.c.a.e"));
    }

    public static boolean shouldUploadFirelogAnalytics(Intent intent) {
        Intent intent2;
        if (intent == null || MessagingAnalytics.isDirectBootMessage(intent2)) {
            return false;
        }
        return MessagingAnalytics.deliveryMetricsExportToBigQueryEnabled();
    }

    private static boolean isDirectBootMessage(Intent intent) {
        return "com.google.firebase.messaging.RECEIVE_DIRECT_BOOT".equals(intent.getAction());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean deliveryMetricsExportToBigQueryEnabled() {
        try {
            FirebaseApp.getInstance();
        }
        catch (IllegalStateException illegalStateException) {
            Log.i((String)"FirebaseMessaging", (String)"FirebaseApp has not being initialized. Device might be in direct boot mode. Skip exporting delivery metrics to Big Query");
            return false;
        }
        Context context = FirebaseApp.getInstance().getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
        if (sharedPreferences.contains("export_to_big_query")) {
            return sharedPreferences.getBoolean("export_to_big_query", false);
        }
        try {}
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
        sharedPreferences = context.getPackageManager();
        if (sharedPreferences == null) return false;
        if ((context = sharedPreferences.getApplicationInfo(context.getPackageName(), 128)) == null) return false;
        sharedPreferences = context.metaData;
        if (sharedPreferences == null) return false;
        boolean bl = context.metaData.containsKey("delivery_metrics_exported_to_big_query_enabled");
        if (!bl) return false;
        return context.metaData.getBoolean("delivery_metrics_exported_to_big_query_enabled", false);
    }

    private static void setUserPropertyIfRequired(Intent object) {
        if (object == null) {
            return;
        }
        if ("1".equals(object.getStringExtra("google.c.a.tc"))) {
            AnalyticsConnector analyticsConnector = (AnalyticsConnector)FirebaseApp.getInstance().get(AnalyticsConnector.class);
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)"Received event with track-conversion=true. Setting user property and reengagement event");
            }
            if (analyticsConnector != null) {
                object = object.getStringExtra("google.c.a.c_id");
                analyticsConnector.setUserProperty("fcm", "_ln", object);
                Bundle bundle = new Bundle();
                bundle.putString("source", "Firebase");
                bundle.putString("medium", "notification");
                bundle.putString("campaign", (String)object);
                analyticsConnector.logEvent("fcm", "_cmp", bundle);
                return;
            }
            Log.w((String)"FirebaseMessaging", (String)"Unable to set user property for conversion tracking:  analytics library is missing");
            return;
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Received event with track-conversion=false. Do not set user property");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static void logToScion(String string, Intent object) {
        AnalyticsConnector analyticsConnector;
        Bundle bundle = new Bundle();
        String string2 = MessagingAnalytics.getComposerId(object);
        if (string2 != null) {
            bundle.putString("_nmid", string2);
        }
        if ((string2 = MessagingAnalytics.getComposerLabel(object)) != null) {
            bundle.putString("_nmn", string2);
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = MessagingAnalytics.getMessageLabel(object)))) {
            bundle.putString("label", string2);
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = MessagingAnalytics.getMessageChannel(object)))) {
            bundle.putString("message_channel", string2);
        }
        if ((string2 = MessagingAnalytics.getTopic(object)) != null) {
            bundle.putString("_nt", string2);
        }
        if ((string2 = MessagingAnalytics.getMessageTime(object)) != null) {
            try {
                bundle.putInt("_nmt", Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)"FirebaseMessaging", (String)"Error while parsing timestamp in GCM event", (Throwable)numberFormatException);
            }
        }
        if ((string2 = MessagingAnalytics.getUseDeviceTime(object)) != null) {
            try {
                bundle.putInt("_ndt", Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)"FirebaseMessaging", (String)"Error while parsing use_device_time in GCM event", (Throwable)numberFormatException);
            }
        }
        String string3 = MessagingAnalytics.getMessageTypeForScion(object);
        if ("_nr".equals(string) || "_nf".equals(string)) {
            bundle.putString("_nmc", string3);
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            String string4 = String.valueOf(bundle);
            int n = string.length();
            String string5 = String.valueOf(string4);
            int n2 = string5.length();
            StringBuilder stringBuilder = new StringBuilder(n + 37 + n2);
            stringBuilder.append("Logging to scion event=");
            stringBuilder.append(string);
            stringBuilder.append(" scionPayload=");
            stringBuilder.append(string4);
            Log.d((String)"FirebaseMessaging", (String)stringBuilder.toString());
        }
        if ((analyticsConnector = (AnalyticsConnector)FirebaseApp.getInstance().get(AnalyticsConnector.class)) != null) {
            analyticsConnector.logEvent("fcm", string, bundle);
            return;
        }
        Log.w((String)"FirebaseMessaging", (String)"Unable to log event: analytics library is missing");
    }

    private static void logToFirelog(@Constants.FirelogAnalytics.EventType String object, Intent object2, Transport<String> transport) {
        object = new FirelogAnalyticsEvent("MESSAGE_DELIVERED", (Intent)object2);
        object2 = new FirelogAnalyticsEvent.FirelogAnalyticsEventWrapper((FirelogAnalyticsEvent)object);
        try {
            object = dataEncoder.encode(object2);
            transport.send(Event.ofTelemetry((Object)object));
            return;
        }
        catch (EncodingException encodingException) {
            Log.d((String)"FirebaseMessaging", (String)"Failed to encode big query analytics payload. Skip sending");
            return;
        }
    }

    static void setDeliveryMetricsExportToBigQuery(boolean bl) {
        FirebaseApp.getInstance().getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit().putBoolean("export_to_big_query", bl).apply();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    static int getTtl(Intent object) {
        Object object2 = object.getExtras().get("google.ttl");
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (!(object2 instanceof String)) return 0;
        try {
            return Integer.parseInt((String)object2);
        }
        catch (NumberFormatException numberFormatException) {
            String string = String.valueOf(object2);
            String string2 = String.valueOf(string);
            int n = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 13);
            stringBuilder.append("Invalid TTL: ");
            stringBuilder.append(string);
            Log.w((String)"FirebaseMessaging", (String)stringBuilder.toString());
            return 0;
        }
    }

    @Nullable
    static String getCollapseKey(Intent intent) {
        return intent.getStringExtra("collapse_key");
    }

    @Nullable
    static String getComposerId(Intent intent) {
        return intent.getStringExtra("google.c.a.c_id");
    }

    @Nullable
    static String getComposerLabel(Intent intent) {
        return intent.getStringExtra("google.c.a.c_l");
    }

    @Nullable
    static String getMessageLabel(Intent intent) {
        return intent.getStringExtra("google.c.a.m_l");
    }

    @Nullable
    static String getMessageChannel(Intent intent) {
        return intent.getStringExtra("google.c.a.m_c");
    }

    @Nullable
    static String getMessageTime(Intent intent) {
        return intent.getStringExtra("google.c.a.ts");
    }

    @Nullable
    static String getMessageId(Intent intent) {
        String string = intent.getStringExtra("google.message_id");
        if (string == null) {
            return intent.getStringExtra("message_id");
        }
        return string;
    }

    @NonNull
    static String getPackageName() {
        return FirebaseApp.getInstance().getApplicationContext().getPackageName();
    }

    @NonNull
    static String getInstanceId(Intent object) {
        if (TextUtils.isEmpty((CharSequence)(object = object.getStringExtra("google.to")))) {
            try {
                object = FirebaseApp.getInstance();
                object = FirebaseInstallations.getInstance((FirebaseApp)object).getId();
                object = (String)Tasks.await((Task)object);
                return object;
            }
            catch (InterruptedException | ExecutionException exception) {
                RuntimeException runtimeException = new RuntimeException(exception);
                throw runtimeException;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    static String getMessageTypeForScion(Intent object) {
        void var0_2;
        if (object.getExtras() != null && NotificationParams.isNotification(object.getExtras())) {
            return var0_2;
        }
        String string = "data";
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    @Constants.FirelogAnalytics.MessageType
    static String getMessageTypeForFirelog(Intent object) {
        void var0_2;
        if (object.getExtras() != null && NotificationParams.isNotification(object.getExtras())) {
            return var0_2;
        }
        String string = "DATA_MESSAGE";
        return var0_2;
    }

    @Nullable
    static String getTopic(Intent object) {
        if ((object = object.getStringExtra("from")) != null && ((String)object).startsWith("/topics/")) {
            return object;
        }
        return null;
    }

    @Nullable
    static String getUseDeviceTime(Intent intent) {
        if (intent.hasExtra("google.c.a.udt")) {
            return intent.getStringExtra("google.c.a.udt");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    static int getPriority(Intent object) {
        void var0_2;
        String string = object.getStringExtra("google.delivered_priority");
        if (string == null) {
            if ("1".equals(object.getStringExtra("google.priority_reduced"))) {
                return 2;
            }
            String string2 = object.getStringExtra("google.priority");
            return MessagingAnalytics.getMessagePriority((String)var0_2);
        }
        String string3 = string;
        return MessagingAnalytics.getMessagePriority((String)var0_2);
    }

    @NonNull
    private static int getMessagePriority(String string) {
        if ("high".equals(string)) {
            return 1;
        }
        if ("normal".equals(string)) {
            return 2;
        }
        return 0;
    }

    @Nullable
    static String getProjectNumber(Intent object) {
        if (object.hasExtra("google.c.sender.id")) {
            return object.getStringExtra("google.c.sender.id");
        }
        object = FirebaseApp.getInstance();
        String string = object.getOptions().getGcmSenderId();
        if (string != null) {
            return string;
        }
        if (!((String)(object = object.getOptions().getApplicationId())).startsWith("1:")) {
            return object;
        }
        if (((Object)(object = ((String)object).split(":"))).length < 2) {
            return null;
        }
        if (((String)(object = object[1])).isEmpty()) {
            return null;
        }
        return object;
    }

    static {
        JsonDataEncoderBuilder jsonDataEncoderBuilder = new JsonDataEncoderBuilder();
        Object object = new FirelogAnalyticsEvent.FirelogAnalyticsEventWrapperEncoder();
        jsonDataEncoderBuilder = jsonDataEncoderBuilder.registerEncoder(FirelogAnalyticsEvent.FirelogAnalyticsEventWrapper.class, (ObjectEncoder)object);
        object = new FirelogAnalyticsEvent.FirelogAnalyticsEventEncoder();
        dataEncoder = jsonDataEncoderBuilder.registerEncoder(FirelogAnalyticsEvent.class, (ObjectEncoder)object).build();
    }
}

