/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.TransportFactory;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.Event;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.internal.FirebaseInstanceIdInternal;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.messaging.FcmBroadcastProcessor;
import com.google.firebase.messaging.FcmExecutors;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$10;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$3;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$4;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$5;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$6;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$7;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$8;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$9;
import com.google.firebase.messaging.FirebaseMessaging$AutoInit$$Lambda$0;
import com.google.firebase.messaging.GmsRpc;
import com.google.firebase.messaging.MessagingAnalytics;
import com.google.firebase.messaging.Metadata;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.RequestDeduplicator;
import com.google.firebase.messaging.Store;
import com.google.firebase.messaging.SyncTask;
import com.google.firebase.messaging.TopicsSubscriber;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseMessaging {
    @Deprecated
    public static final String INSTANCE_ID_SCOPE = "FCM";
    private static final long MAX_DELAY_SEC = TimeUnit.HOURS.toSeconds(8L);
    @SuppressLint(value={"StaticFieldLeak"})
    private static Store store;
    private final FirebaseApp firebaseApp;
    @Nullable
    private final FirebaseInstanceIdInternal iid;
    private final FirebaseInstallationsApi fis;
    private final Context context;
    private final GmsRpc gmsRpc;
    private final RequestDeduplicator requestDeduplicator;
    private final AutoInit autoInit;
    private final Executor fileIoExecutor;
    private final Executor taskExecutor;
    private final Task<TopicsSubscriber> topicsSubscriberTask;
    private final Metadata metadata;
    @GuardedBy(value="this")
    private boolean syncScheduledOrRunning;
    @Nullable
    @SuppressLint(value={"FirebaseUnknownNullness"})
    @VisibleForTesting
    static TransportFactory transportFactory;
    @GuardedBy(value="FirebaseMessaging.class")
    @VisibleForTesting
    static ScheduledExecutorService syncExecutor;

    @NonNull
    public static synchronized FirebaseMessaging getInstance() {
        return FirebaseMessaging.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    @NonNull
    static synchronized FirebaseMessaging getInstance(@NonNull FirebaseApp firebaseApp) {
        Object object = (FirebaseMessaging)firebaseApp.get(FirebaseMessaging.class);
        Preconditions.checkNotNull((Object)object, (Object)"Firebase Messaging component is not present");
        return object;
    }

    FirebaseMessaging(FirebaseApp firebaseApp, @Nullable FirebaseInstanceIdInternal firebaseInstanceIdInternal, Provider<UserAgentPublisher> provider, Provider<HeartBeatInfo> provider2, FirebaseInstallationsApi firebaseInstallationsApi, @Nullable TransportFactory transportFactory, Subscriber subscriber) {
        Metadata metadata = new Metadata(firebaseApp.getApplicationContext());
        this(firebaseApp, firebaseInstanceIdInternal, provider, provider2, firebaseInstallationsApi, transportFactory, subscriber, metadata);
    }

    FirebaseMessaging(FirebaseApp firebaseApp, @Nullable FirebaseInstanceIdInternal firebaseInstanceIdInternal, Provider<UserAgentPublisher> provider, Provider<HeartBeatInfo> provider2, FirebaseInstallationsApi firebaseInstallationsApi, @Nullable TransportFactory transportFactory, Subscriber subscriber, Metadata metadata) {
        GmsRpc gmsRpc = new GmsRpc(firebaseApp, metadata, provider, provider2, firebaseInstallationsApi);
        this(firebaseApp, firebaseInstanceIdInternal, firebaseInstallationsApi, transportFactory, subscriber, metadata, gmsRpc, FcmExecutors.newTaskExecutor(), FcmExecutors.newInitExecutor());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    FirebaseMessaging(FirebaseApp task, @Nullable FirebaseInstanceIdInternal object, FirebaseInstallationsApi object2, @Nullable TransportFactory object3, Subscriber subscriber, Metadata metadata, GmsRpc gmsRpc, Executor executor, Executor executor2) {
        this.syncScheduledOrRunning = false;
        transportFactory = object3;
        this.firebaseApp = task;
        this.iid = object;
        this.fis = object2;
        super(subscriber);
        this.autoInit = object3;
        this.context = task.getApplicationContext();
        this.metadata = metadata;
        this.taskExecutor = executor;
        this.gmsRpc = gmsRpc;
        super(executor);
        this.requestDeduplicator = task;
        this.fileIoExecutor = executor2;
        if (object != null) {
            super(this);
            object.addNewTokenListener((FirebaseInstanceIdInternal.NewTokenListener)task);
        }
        task = FirebaseMessaging.class;
        synchronized (task) {
            object = store;
            if (object == null) {
                super(this.context);
                store = object;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl26 : MonitorExitStatement: MONITOREXIT : var1_2
            super(this);
            executor2.execute((Runnable)task);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        task = this.topicsSubscriberTask = TopicsSubscriber.createInstance(this, object2, metadata, gmsRpc, this.context, FcmExecutors.newTopicsSyncExecutor());
        object = FcmExecutors.newTopicsSyncTriggerExecutor();
        super(this);
        task.addOnSuccessListener((Executor)object, (OnSuccessListener)object2);
    }

    public boolean isAutoInitEnabled() {
        return this.autoInit.isEnabled();
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoInitEnabled(boolean enable) {
        void var1_1;
        this.autoInit.setEnabled((boolean)var1_1);
    }

    @NonNull
    public boolean deliveryMetricsExportToBigQueryEnabled() {
        return MessagingAnalytics.deliveryMetricsExportToBigQueryEnabled();
    }

    public void setDeliveryMetricsExportToBigQuery(boolean enable) {
        MessagingAnalytics.setDeliveryMetricsExportToBigQuery(enable);
    }

    @NonNull
    public Task<String> getToken() {
        FirebaseInstanceIdInternal firebaseInstanceIdInternal = this.iid;
        if (firebaseInstanceIdInternal != null) {
            return firebaseInstanceIdInternal.getTokenTask();
        }
        firebaseInstanceIdInternal = new TaskCompletionSource();
        Executor executor = this.fileIoExecutor;
        FirebaseMessaging$$Lambda$3 firebaseMessaging$$Lambda$3 = new FirebaseMessaging$$Lambda$3(this, (TaskCompletionSource)firebaseInstanceIdInternal);
        executor.execute(firebaseMessaging$$Lambda$3);
        return firebaseInstanceIdInternal.getTask();
    }

    @NonNull
    public Task<Void> deleteToken() {
        if (this.iid != null) {
            TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
            Executor executor = this.fileIoExecutor;
            FirebaseMessaging$$Lambda$4 firebaseMessaging$$Lambda$4 = new FirebaseMessaging$$Lambda$4(this, taskCompletionSource);
            executor.execute(firebaseMessaging$$Lambda$4);
            return taskCompletionSource.getTask();
        }
        if (this.getTokenWithoutTriggeringSync() == null) {
            return Tasks.forResult(null);
        }
        ExecutorService executorService = FcmExecutors.newNetworkIOExecutor();
        FirebaseInstallationsApi firebaseInstallationsApi = this.fis;
        firebaseInstallationsApi = firebaseInstallationsApi.getId();
        FirebaseMessaging$$Lambda$5 firebaseMessaging$$Lambda$5 = new FirebaseMessaging$$Lambda$5(this, executorService);
        return firebaseInstallationsApi.continueWithTask((Executor)executorService, (Continuation)firebaseMessaging$$Lambda$5);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> subscribeToTopic(@NonNull String topic) {
        void var1_1;
        Task<TopicsSubscriber> this_ = this_.topicsSubscriberTask;
        FirebaseMessaging$$Lambda$6 firebaseMessaging$$Lambda$6 = new FirebaseMessaging$$Lambda$6((String)var1_1);
        return this_.onSuccessTask((SuccessContinuation)firebaseMessaging$$Lambda$6);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> unsubscribeFromTopic(@NonNull String topic) {
        void var1_1;
        Task<TopicsSubscriber> this_ = this_.topicsSubscriberTask;
        FirebaseMessaging$$Lambda$7 firebaseMessaging$$Lambda$7 = new FirebaseMessaging$$Lambda$7((String)var1_1);
        return this_.onSuccessTask((SuccessContinuation)firebaseMessaging$$Lambda$7);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void send(@NonNull RemoteMessage message) {
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)message.getTo())) {
            Object object = new IllegalArgumentException("Missing 'to'");
            throw object;
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        Intent intent2 = new Intent();
        intent2.setPackage("com.google.example.invalidpackage");
        Context context = ((FirebaseMessaging)object).context;
        int n = Build.VERSION.SDK_INT >= 23 ? 0x4000000 : 0;
        intent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)n));
        intent.setPackage("com.google.android.gms");
        var1_1.populateSendMessageIntent(intent);
        ((FirebaseMessaging)object).context.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    @Nullable
    public static TransportFactory getTransportFactory() {
        return transportFactory;
    }

    @VisibleForTesting
    boolean isGmsCorePresent() {
        return this.metadata.isGmscorePresent();
    }

    Context getApplicationContext() {
        return this.context;
    }

    synchronized void setSyncScheduledOrRunning(boolean bl) {
        this.syncScheduledOrRunning = bl;
    }

    synchronized void syncWithDelaySecondsInternal(long l) {
        long l2 = Math.max(30L, l + l);
        long l3 = MAX_DELAY_SEC;
        l2 = Math.min(l2, l3);
        SyncTask syncTask = new SyncTask(this, l2);
        this.enqueueTaskWithDelaySeconds(syncTask, l);
        this.syncScheduledOrRunning = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void enqueueTaskWithDelaySeconds(Runnable runnable, long l) {
        Class<FirebaseMessaging> clazz = FirebaseMessaging.class;
        synchronized (clazz) {
            ScheduledExecutorService scheduledExecutorService = syncExecutor;
            if (scheduledExecutorService == null) {
                NamedThreadFactory namedThreadFactory = new NamedThreadFactory("TAG");
                syncExecutor = scheduledExecutorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)namedThreadFactory);
            }
            syncExecutor.schedule(runnable, l, TimeUnit.SECONDS);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    private void startSyncIfNecessary() {
        FirebaseInstanceIdInternal firebaseInstanceIdInternal = this.iid;
        if (firebaseInstanceIdInternal != null) {
            firebaseInstanceIdInternal.getToken();
            return;
        }
        if (this.tokenNeedsRefresh(this.getTokenWithoutTriggeringSync())) {
            this.startSync();
            return;
        }
    }

    private synchronized void startSync() {
        if (!this.syncScheduledOrRunning) {
            this.syncWithDelaySecondsInternal(0L);
            return;
        }
    }

    @Nullable
    @VisibleForTesting
    Store.Token getTokenWithoutTriggeringSync() {
        return store.getToken(this.getSubtype(), Metadata.getDefaultSenderId(this.firebaseApp));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String blockingGetToken() throws IOException {
        Task object3;
        Object object2 = object3.iid;
        if (object2 != null) {
            try {
                object3 = object2.getTokenTask();
                return (String)Tasks.await((Task)object3);
            }
            catch (InterruptedException | ExecutionException exception) {
                object2 = new IOException(exception);
                throw object2;
            }
        }
        object2 = object3.getTokenWithoutTriggeringSync();
        if (!object3.tokenNeedsRefresh((Store.Token)object2)) {
            return object2.token;
        }
        String string = Metadata.getDefaultSenderId(object3.firebaseApp);
        Object object = object3.fis;
        object = object.getId();
        ExecutorService executorService = FcmExecutors.newNetworkIOExecutor();
        FirebaseMessaging$$Lambda$8 firebaseMessaging$$Lambda$8 = new FirebaseMessaging$$Lambda$8((FirebaseMessaging)object3, string);
        object = object.continueWithTask((Executor)executorService, (Continuation)firebaseMessaging$$Lambda$8);
        try {
            object = (String)Tasks.await((Task)object);
            store.saveToken(super.getSubtype(), string, (String)object, object3.metadata.getAppVersionCode());
            if (object2 != null) {
                boolean bl = ((String)object).equals(object2.token);
                if (bl) return object;
            }
            super.invokeOnTokenRefresh((String)object);
            return object;
        }
        catch (InterruptedException | ExecutionException exception) {
            object2 = new IOException(exception);
            throw object2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSubtype() {
        if (!"[DEFAULT]".equals(((FirebaseMessaging)this).firebaseApp.getName())) return ((FirebaseMessaging)this).firebaseApp.getPersistenceKey();
        return "";
    }

    @VisibleForTesting
    boolean tokenNeedsRefresh(@Nullable Store.Token token) {
        return token == null || token.needsRefresh(this.metadata.getAppVersionCode());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void invokeOnTokenRefresh(String object) {
        Object object2;
        if (!"[DEFAULT]".equals(this.firebaseApp.getName())) {
            return;
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            object2 = String.valueOf(this.firebaseApp.getName());
            String string = "Invoking onNewToken for app: ";
            object2 = ((String)object2).length() != 0 ? string.concat((String)object2) : new String(string);
            Log.d((String)"FirebaseMessaging", (String)object2);
        }
        object2 = new Intent("com.google.firebase.messaging.NEW_TOKEN");
        object2.putExtra("token", (String)object);
        object = new FcmBroadcastProcessor(this.context);
        ((FcmBroadcastProcessor)object).process((Intent)object2);
    }

    final /* synthetic */ Task lambda$blockingGetToken$9$FirebaseMessaging(String string, Task task) throws Exception {
        RequestDeduplicator requestDeduplicator = this.requestDeduplicator;
        FirebaseMessaging$$Lambda$9 firebaseMessaging$$Lambda$9 = new FirebaseMessaging$$Lambda$9(this, task);
        return requestDeduplicator.getOrStartGetTokenRequest(string, firebaseMessaging$$Lambda$9);
    }

    final /* synthetic */ Task lambda$blockingGetToken$8$FirebaseMessaging(Task task) {
        return this.gmsRpc.getToken((String)task.getResult());
    }

    static final /* synthetic */ Task lambda$unsubscribeFromTopic$7$FirebaseMessaging(String string, TopicsSubscriber topicsSubscriber) throws Exception {
        return topicsSubscriber.unsubscribeFromTopic(string);
    }

    static final /* synthetic */ Task lambda$subscribeToTopic$6$FirebaseMessaging(String string, TopicsSubscriber topicsSubscriber) throws Exception {
        return topicsSubscriber.subscribeToTopic(string);
    }

    final /* synthetic */ Task lambda$deleteToken$5$FirebaseMessaging(ExecutorService executorService, Task task) throws Exception {
        Object object = this.gmsRpc;
        task = task.getResult();
        task = (String)task;
        task = ((GmsRpc)object).deleteToken((String)task);
        object = new FirebaseMessaging$$Lambda$10(this);
        return task.continueWith((Executor)executorService, (Continuation)object);
    }

    final /* synthetic */ Void lambda$deleteToken$4$FirebaseMessaging(Task task) throws Exception {
        store.deleteToken(this.getSubtype(), Metadata.getDefaultSenderId(this.firebaseApp));
        return null;
    }

    final /* synthetic */ void lambda$deleteToken$3$FirebaseMessaging(TaskCompletionSource taskCompletionSource) {
        try {
            this.iid.deleteToken(Metadata.getDefaultSenderId(this.firebaseApp), INSTANCE_ID_SCOPE);
            taskCompletionSource.setResult(null);
            return;
        }
        catch (Exception exception) {
            taskCompletionSource.setException(exception);
            return;
        }
    }

    final /* synthetic */ void lambda$getToken$2$FirebaseMessaging(TaskCompletionSource taskCompletionSource) {
        try {
            taskCompletionSource.setResult((Object)this.blockingGetToken());
            return;
        }
        catch (Exception exception) {
            taskCompletionSource.setException(exception);
            return;
        }
    }

    final /* synthetic */ void lambda$new$1$FirebaseMessaging(TopicsSubscriber topicsSubscriber) {
        if (this.isAutoInitEnabled()) {
            topicsSubscriber.startTopicsSyncIfNecessary();
            return;
        }
    }

    final /* synthetic */ void lambda$new$0$FirebaseMessaging() {
        if (this.isAutoInitEnabled()) {
            this.startSyncIfNecessary();
            return;
        }
    }

    private class AutoInit {
        private final Subscriber subscriber;
        @GuardedBy(value="this")
        private boolean initialized;
        @GuardedBy(value="this")
        @Nullable
        private EventHandler<DataCollectionDefaultChange> dataCollectionDefaultChangeEventHandler;
        @GuardedBy(value="this")
        @Nullable
        private Boolean autoInitEnabled;

        AutoInit(Subscriber subscriber) {
            this.subscriber = subscriber;
        }

        synchronized void initialize() {
            if (this.initialized) {
                return;
            }
            this.autoInitEnabled = this.readEnabled();
            if (this.autoInitEnabled == null) {
                FirebaseMessaging$AutoInit$$Lambda$0 firebaseMessaging$AutoInit$$Lambda$0;
                this.dataCollectionDefaultChangeEventHandler = firebaseMessaging$AutoInit$$Lambda$0 = new FirebaseMessaging$AutoInit$$Lambda$0(this);
                this.subscriber.subscribe(DataCollectionDefaultChange.class, this.dataCollectionDefaultChangeEventHandler);
            }
            this.initialized = true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        synchronized boolean isEnabled() {
            this.initialize();
            Boolean bl = this.autoInitEnabled;
            if (bl == null) return FirebaseMessaging.this.firebaseApp.isDataCollectionDefaultEnabled();
            return bl;
        }

        synchronized void setEnabled(boolean bl) {
            this.initialize();
            SharedPreferences.Editor editor = this.dataCollectionDefaultChangeEventHandler;
            if (editor != null) {
                this.subscriber.unsubscribe(DataCollectionDefaultChange.class, editor);
                this.dataCollectionDefaultChangeEventHandler = null;
            }
            editor = FirebaseMessaging.this.firebaseApp.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
            editor.putBoolean("auto_init", bl);
            editor.apply();
            if (bl) {
                FirebaseMessaging.this.startSyncIfNecessary();
            }
            this.autoInitEnabled = bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        private Boolean readEnabled() {
            Object object = ((AutoInit)object).FirebaseMessaging.this.firebaseApp.getApplicationContext();
            SharedPreferences sharedPreferences = object.getSharedPreferences("com.google.firebase.messaging", 0);
            if (sharedPreferences.contains("auto_init")) {
                return sharedPreferences.getBoolean("auto_init", false);
            }
            try {
                sharedPreferences = object.getPackageManager();
                if (sharedPreferences == null) return null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
            object = sharedPreferences.getApplicationInfo(object.getPackageName(), 128);
            if (object == null) return null;
            sharedPreferences = ((ApplicationInfo)object).metaData;
            if (sharedPreferences == null) return null;
            boolean bl = ((ApplicationInfo)object).metaData.containsKey("firebase_messaging_auto_init_enabled");
            if (!bl) return null;
            return ((ApplicationInfo)object).metaData.getBoolean("firebase_messaging_auto_init_enabled");
        }

        final /* synthetic */ void lambda$initialize$0$FirebaseMessaging$AutoInit(Event event) {
            if (this.isEnabled()) {
                FirebaseMessaging.this.startSyncIfNecessary();
                return;
            }
        }
    }
}

