/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.firebase.messaging.SharedPreferencesQueue$$Lambda$0;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.concurrent.Executor;

final class SharedPreferencesQueue {
    private final SharedPreferences sharedPreferences;
    private final String queueName;
    private final String itemSeparator;
    @GuardedBy(value="internalQueue")
    private final ArrayDeque<String> internalQueue;
    private final Executor syncExecutor;
    @GuardedBy(value="internalQueue")
    private boolean bulkOperation;

    private SharedPreferencesQueue(SharedPreferences sharedPreferences, String arrayDeque, String string, Executor executor) {
        arrayDeque = new ArrayDeque();
        this.internalQueue = arrayDeque;
        this.bulkOperation = false;
        this.sharedPreferences = sharedPreferences;
        this.queueName = "topic_operation_queue";
        this.itemSeparator = ",";
        this.syncExecutor = executor;
    }

    @WorkerThread
    static SharedPreferencesQueue createInstance(SharedPreferences sharedPreferences, String object, String string, Executor executor) {
        object = new SharedPreferencesQueue(sharedPreferences, "topic_operation_queue", ",", executor);
        super.initQueue();
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private void initQueue() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            int n;
            this.internalQueue.clear();
            String string = this.sharedPreferences.getString(this.queueName, "");
            boolean bl = TextUtils.isEmpty((CharSequence)string);
            if (bl) return;
            bl = string.contains(this.itemSeparator);
            if (!bl) {
                return;
            }
            String[] stringArray = string.split(this.itemSeparator, -1);
            int n2 = stringArray.length;
            if (n2 == 0) {
                Log.e((String)"FirebaseMessaging", (String)"Corrupted queue. Please check the queue contents and item separator provided");
                n = 0;
            } else {
                n = 0;
            }
            while (n < n2) {
                String string2 = stringArray[n];
                boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
                if (!bl2) {
                    this.internalQueue.add(string2);
                }
                ++n;
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean add(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) return false;
        if (string.contains(this.itemSeparator)) {
            return false;
        }
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            boolean bl = this.internalQueue.add(string);
            this.checkAndSyncState(bl);
            return bl;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @GuardedBy(value="internalQueue")
    private boolean checkAndSyncState(boolean bl) {
        if (bl && !this.bulkOperation) {
            this.syncStateAsync();
            return true;
        }
        return bl;
    }

    private void syncStateAsync() {
        Executor executor = this.syncExecutor;
        SharedPreferencesQueue$$Lambda$0 sharedPreferencesQueue$$Lambda$0 = new SharedPreferencesQueue$$Lambda$0(this);
        executor.execute(sharedPreferencesQueue$$Lambda$0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private void syncState() {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            this.sharedPreferences.edit().putString(this.queueName, this.serialize()).commit();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @GuardedBy(value="internalQueue")
    @NonNull
    public String serialize() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = this.internalQueue.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            stringBuilder.append(this.itemSeparator);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(@Nullable Object object) {
        ArrayDeque<String> arrayDeque = this.internalQueue;
        synchronized (arrayDeque) {
            boolean bl = this.internalQueue.remove(object);
            this.checkAndSyncState(bl);
            return bl;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String peek() {
        ArrayDeque<String> arrayDeque = ((SharedPreferencesQueue)string).internalQueue;
        synchronized (arrayDeque) {
            return ((SharedPreferencesQueue)string).internalQueue.peek();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }
}

