/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.TransportFactory;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.Event;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.Metadata;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.messaging.FcmExecutors;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$2;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$3;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$4;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$5;
import com.google.firebase.messaging.FirebaseMessaging$AutoInit$$Lambda$0;
import com.google.firebase.messaging.FirebaseMessaging$AutoInit$$Lambda$1;
import com.google.firebase.messaging.FirebaseMessaging$AutoInit$$Lambda$2;
import com.google.firebase.messaging.MessagingAnalytics;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.TopicsSubscriber;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseMessaging {
    @Deprecated
    public static final String INSTANCE_ID_SCOPE = "FCM";
    private final Context context;
    private final FirebaseApp firebaseApp;
    private final FirebaseInstanceId iid;
    private final AutoInit autoInit;
    private final Executor fileIoExecutor;
    private final Task<TopicsSubscriber> topicsSubscriberTask;
    @Nullable
    @SuppressLint(value={"FirebaseUnknownNullness"})
    @VisibleForTesting
    static TransportFactory transportFactory;

    @NonNull
    public static synchronized FirebaseMessaging getInstance() {
        return FirebaseMessaging.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    @NonNull
    static synchronized FirebaseMessaging getInstance(@NonNull FirebaseApp object) {
        object = (FirebaseMessaging)object.get(FirebaseMessaging.class);
        Preconditions.checkNotNull((Object)object, (Object)"Firebase Messaging component is not present");
        return object;
    }

    FirebaseMessaging(FirebaseApp task, FirebaseInstanceId object, Provider<UserAgentPublisher> object2, Provider<HeartBeatInfo> provider, FirebaseInstallationsApi firebaseInstallationsApi, @Nullable TransportFactory object3, Subscriber object4) {
        try {
            Class.forName("com.google.firebase.iid.FirebaseInstanceIdReceiver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object object5 = new IllegalStateException("FirebaseMessaging and FirebaseInstanceId versions not compatible. Update to latest version of firebase-messaging.");
            throw object5;
        }
        transportFactory = object3;
        ((FirebaseMessaging)object5).firebaseApp = task;
        ((FirebaseMessaging)object5).iid = object;
        super((Subscriber)object4);
        ((FirebaseMessaging)object5).autoInit = object3;
        ((FirebaseMessaging)object5).context = task.getApplicationContext();
        ((FirebaseMessaging)object5).fileIoExecutor = FcmExecutors.newInitExecutor();
        object3 = ((FirebaseMessaging)object5).fileIoExecutor;
        super((FirebaseMessaging)object5, (FirebaseInstanceId)object);
        object3.execute((Runnable)object4);
        object3 = new Metadata(((FirebaseMessaging)object5).context);
        task = ((FirebaseMessaging)object5).topicsSubscriberTask = TopicsSubscriber.createInstance((FirebaseApp)task, object, (Metadata)object3, object2, provider, firebaseInstallationsApi, ((FirebaseMessaging)object5).context, FcmExecutors.newTopicsSyncExecutor());
        object = FcmExecutors.newTopicsSyncTriggerExecutor();
        super((FirebaseMessaging)object5);
        task.addOnSuccessListener((Executor)object, object2);
    }

    public boolean isAutoInitEnabled() {
        return this.autoInit.isEnabled();
    }

    public void setAutoInitEnabled(boolean bl) {
        this.autoInit.setEnabled(bl);
    }

    @NonNull
    public boolean deliveryMetricsExportToBigQueryEnabled() {
        return MessagingAnalytics.deliveryMetricsExportToBigQueryEnabled();
    }

    public void setDeliveryMetricsExportToBigQuery(boolean bl) {
        MessagingAnalytics.setDeliveryMetricsExportToBigQuery(bl);
    }

    @NonNull
    public Task<String> getToken() {
        return this.iid.getInstanceId().continueWith(FirebaseMessaging$$Lambda$2.$instance);
    }

    @NonNull
    public Task<Void> deleteToken() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        ExecutorService executorService = FcmExecutors.newNetworkIOExecutor();
        FirebaseMessaging$$Lambda$3 firebaseMessaging$$Lambda$3 = new FirebaseMessaging$$Lambda$3(this, taskCompletionSource);
        executorService.execute(firebaseMessaging$$Lambda$3);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<Void> subscribeToTopic(@NonNull String string) {
        Task<TopicsSubscriber> task = task.topicsSubscriberTask;
        FirebaseMessaging$$Lambda$4 firebaseMessaging$$Lambda$4 = new FirebaseMessaging$$Lambda$4(string);
        return task.onSuccessTask((SuccessContinuation)firebaseMessaging$$Lambda$4);
    }

    @NonNull
    public Task<Void> unsubscribeFromTopic(@NonNull String string) {
        Task<TopicsSubscriber> task = task.topicsSubscriberTask;
        FirebaseMessaging$$Lambda$5 firebaseMessaging$$Lambda$5 = new FirebaseMessaging$$Lambda$5(string);
        return task.onSuccessTask((SuccessContinuation)firebaseMessaging$$Lambda$5);
    }

    public void send(@NonNull RemoteMessage remoteMessage) {
        if (TextUtils.isEmpty((CharSequence)remoteMessage.getTo())) {
            Object object = new IllegalArgumentException("Missing 'to'");
            throw object;
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        Intent intent2 = new Intent();
        intent2.setPackage("com.google.example.invalidpackage");
        intent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)((FirebaseMessaging)object).context, (int)0, (Intent)intent2, (int)0));
        intent.setPackage("com.google.android.gms");
        remoteMessage.populateSendMessageIntent(intent);
        ((FirebaseMessaging)object).context.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    @Nullable
    public static TransportFactory getTransportFactory() {
        return transportFactory;
    }

    static final /* synthetic */ Task lambda$unsubscribeFromTopic$5$FirebaseMessaging(String string, TopicsSubscriber topicsSubscriber) throws Exception {
        return topicsSubscriber.unsubscribeFromTopic(string);
    }

    static final /* synthetic */ Task lambda$subscribeToTopic$4$FirebaseMessaging(String string, TopicsSubscriber topicsSubscriber) throws Exception {
        return topicsSubscriber.subscribeToTopic(string);
    }

    final /* synthetic */ void lambda$deleteToken$3$FirebaseMessaging(TaskCompletionSource taskCompletionSource) {
        try {
            FirebaseInstanceId firebaseInstanceId = firebaseMessaging.iid;
            FirebaseMessaging firebaseMessaging = firebaseMessaging.firebaseApp;
            firebaseInstanceId.deleteToken(Metadata.getDefaultSenderId((FirebaseApp)firebaseMessaging), INSTANCE_ID_SCOPE);
            taskCompletionSource.setResult(null);
            return;
        }
        catch (Exception exception) {
            taskCompletionSource.setException(exception);
            return;
        }
    }

    static final /* synthetic */ String lambda$getToken$2$FirebaseMessaging(Task task) throws Exception {
        return ((InstanceIdResult)task.getResult()).getToken();
    }

    final /* synthetic */ void lambda$new$1$FirebaseMessaging(TopicsSubscriber topicsSubscriber) {
        if (this.isAutoInitEnabled()) {
            topicsSubscriber.startTopicsSyncIfNecessary();
            return;
        }
    }

    final /* synthetic */ void lambda$new$0$FirebaseMessaging(FirebaseInstanceId firebaseInstanceId) {
        if (this.autoInit.isEnabled()) {
            firebaseInstanceId.getToken();
            return;
        }
    }

    private class AutoInit {
        private final Subscriber subscriber;
        @GuardedBy(value="this")
        private boolean initialized;
        @GuardedBy(value="this")
        @Nullable
        private EventHandler<DataCollectionDefaultChange> dataCollectionDefaultChangeEventHandler;
        @GuardedBy(value="this")
        @Nullable
        private Boolean autoInitEnabled;

        AutoInit(Subscriber subscriber) {
            this.subscriber = subscriber;
        }

        synchronized void initialize() {
            if (this.initialized) {
                return;
            }
            this.autoInitEnabled = this.readEnabled();
            if (this.autoInitEnabled == null) {
                FirebaseMessaging$AutoInit$$Lambda$0 firebaseMessaging$AutoInit$$Lambda$0;
                this.dataCollectionDefaultChangeEventHandler = firebaseMessaging$AutoInit$$Lambda$0 = new FirebaseMessaging$AutoInit$$Lambda$0(this);
                this.subscriber.subscribe(DataCollectionDefaultChange.class, this.dataCollectionDefaultChangeEventHandler);
            }
            this.initialized = true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        synchronized boolean isEnabled() {
            this.initialize();
            Boolean bl = this.autoInitEnabled;
            if (bl == null) return FirebaseMessaging.this.firebaseApp.isDataCollectionDefaultEnabled();
            return bl;
        }

        synchronized void setEnabled(boolean bl) {
            this.initialize();
            Object object = this.dataCollectionDefaultChangeEventHandler;
            if (object != null) {
                this.subscriber.unsubscribe(DataCollectionDefaultChange.class, object);
                this.dataCollectionDefaultChangeEventHandler = null;
            }
            object = FirebaseMessaging.this.firebaseApp.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
            object.putBoolean("auto_init", bl);
            object.apply();
            if (bl) {
                object = FirebaseMessaging.this;
                object = ((FirebaseMessaging)object).fileIoExecutor;
                FirebaseMessaging$AutoInit$$Lambda$1 firebaseMessaging$AutoInit$$Lambda$1 = new FirebaseMessaging$AutoInit$$Lambda$1(this);
                object.execute(firebaseMessaging$AutoInit$$Lambda$1);
            }
            this.autoInitEnabled = bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        private Boolean readEnabled() {
            Object object = ((AutoInit)object).FirebaseMessaging.this.firebaseApp.getApplicationContext();
            SharedPreferences sharedPreferences = object.getSharedPreferences("com.google.firebase.messaging", 0);
            if (sharedPreferences.contains("auto_init")) {
                return sharedPreferences.getBoolean("auto_init", false);
            }
            try {
                sharedPreferences = object.getPackageManager();
                if (sharedPreferences == null) return null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
            object = sharedPreferences.getApplicationInfo(object.getPackageName(), 128);
            if (object == null) return null;
            sharedPreferences = ((ApplicationInfo)object).metaData;
            if (sharedPreferences == null) return null;
            boolean bl = ((ApplicationInfo)object).metaData.containsKey("firebase_messaging_auto_init_enabled");
            if (!bl) return null;
            return ((ApplicationInfo)object).metaData.getBoolean("firebase_messaging_auto_init_enabled");
        }

        final /* synthetic */ void lambda$setEnabled$2$FirebaseMessaging$AutoInit() {
            FirebaseMessaging.this.iid.getToken();
        }

        final /* synthetic */ void lambda$initialize$1$FirebaseMessaging$AutoInit(Event object) {
            if (this.isEnabled()) {
                object = FirebaseMessaging.this;
                object = ((FirebaseMessaging)object).fileIoExecutor;
                FirebaseMessaging$AutoInit$$Lambda$2 firebaseMessaging$AutoInit$$Lambda$2 = new FirebaseMessaging$AutoInit$$Lambda$2(this);
                object.execute(firebaseMessaging$AutoInit$$Lambda$2);
                return;
            }
        }

        final /* synthetic */ void lambda$initialize$0$FirebaseMessaging$AutoInit() {
            FirebaseMessaging.this.iid.getToken();
        }
    }
}

