/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.NotificationManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.messaging.CommonNotificationBuilder;
import com.google.firebase.messaging.ImageDownload;
import com.google.firebase.messaging.NotificationParams;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class DisplayNotification {
    private final Executor networkIoExecutor;
    private final Context context;
    private final NotificationParams params;

    public DisplayNotification(Context context, NotificationParams notificationParams, Executor executor) {
        this.networkIoExecutor = executor;
        this.context = context;
        this.params = notificationParams;
    }

    private boolean isAppForeground() {
        if (((KeyguardManager)this.context.getSystemService("keyguard")).inKeyguardRestrictedInputMode()) {
            return false;
        }
        if (!PlatformVersion.isAtLeastLollipop()) {
            SystemClock.sleep((long)10L);
        }
        int n = Process.myPid();
        List list = ((ActivityManager)this.context.getSystemService("activity")).getRunningAppProcesses();
        if (list != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.pid != n) continue;
                return runningAppProcessInfo.importance == 100;
            }
        }
        return false;
    }

    boolean handleNotification() {
        if (this.params.getBoolean("gcm.n.noui")) {
            return true;
        }
        if (this.isAppForeground()) {
            return false;
        }
        ImageDownload imageDownload = this.startImageDownloadInBackground();
        CommonNotificationBuilder.DisplayNotificationInfo displayNotificationInfo = CommonNotificationBuilder.createNotificationInfo(this.context, this.params);
        this.waitForAndApplyImageDownload(displayNotificationInfo.notificationBuilder, imageDownload);
        this.showNotification(displayNotificationInfo);
        return true;
    }

    @Nullable
    private ImageDownload startImageDownloadInBackground() {
        ImageDownload imageDownload = ImageDownload.create(this.params.getString("gcm.n.image"));
        if (imageDownload != null) {
            imageDownload.start(this.networkIoExecutor);
        }
        return imageDownload;
    }

    private void waitForAndApplyImageDownload(NotificationCompat.Builder builder, @Nullable ImageDownload imageDownload) {
        if (imageDownload == null) {
            return;
        }
        try {
            Bitmap bitmap = (Bitmap)Tasks.await(imageDownload.getTask(), (long)5L, (TimeUnit)TimeUnit.SECONDS);
            builder.setLargeIcon(bitmap);
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bitmap).bigLargeIcon(null));
            return;
        }
        catch (ExecutionException executionException) {
            String string = String.valueOf(executionException.getCause());
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(26 + String.valueOf(string).length()).append("Failed to download image: ").append(string).toString());
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.w((String)"FirebaseMessaging", (String)"Interrupted while downloading image, showing notification without it");
            imageDownload.close();
            Thread.currentThread().interrupt();
            return;
        }
        catch (TimeoutException timeoutException) {
            Log.w((String)"FirebaseMessaging", (String)"Failed to download image in time, showing notification without it");
            imageDownload.close();
            return;
        }
    }

    private void showNotification(CommonNotificationBuilder.DisplayNotificationInfo displayNotificationInfo) {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Showing notification");
        }
        ((NotificationManager)this.context.getSystemService("notification")).notify(displayNotificationInfo.tag, displayNotificationInfo.id, displayNotificationInfo.notificationBuilder.build());
    }
}

