/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.Event;
import com.google.android.datatransport.Transport;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.encoders.DataEncoder;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.FirelogAnalyticsEvent;
import com.google.firebase.messaging.zzt;

public final class zzr {
    private static final DataEncoder zza = new JsonDataEncoderBuilder().registerEncoder(FirelogAnalyticsEvent.zza.class, (ObjectEncoder)new FirelogAnalyticsEvent.zzc()).registerEncoder(FirelogAnalyticsEvent.class, (ObjectEncoder)new FirelogAnalyticsEvent.zzb()).build();

    public static void zza(Intent intent, @Nullable Transport<String> transport) {
        zzr.zza("_nr", intent);
        if (transport != null) {
            Transport<String> transport2 = transport;
            Intent intent2 = intent;
            String string = "MESSAGE_DELIVERED";
            FirelogAnalyticsEvent firelogAnalyticsEvent = new FirelogAnalyticsEvent(string, intent2);
            FirelogAnalyticsEvent.zza zza2 = new FirelogAnalyticsEvent.zza(firelogAnalyticsEvent);
            try {
                transport2.send(Event.ofTelemetry((Object)zza.encode((Object)zza2)));
                return;
            }
            catch (EncodingException encodingException) {
                Log.d((String)"FirebaseMessaging", (String)"Failed to encode big query analytics payload. Skip sending");
            }
        }
    }

    public static void zza(Intent intent) {
        Intent intent2 = intent;
        if (intent2 != null) {
            String string = intent2.getStringExtra("google.c.a.tc");
            if ("1".equals(string)) {
                AnalyticsConnector analyticsConnector = (AnalyticsConnector)FirebaseApp.getInstance().get(AnalyticsConnector.class);
                if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                    Log.d((String)"FirebaseMessaging", (String)"Received event with track-conversion=true. Setting user property and reengagement event");
                }
                if (analyticsConnector != null) {
                    String string2 = intent2.getStringExtra("google.c.a.c_id");
                    analyticsConnector.setUserProperty("fcm", "_ln", (Object)string2);
                    Bundle bundle = new Bundle();
                    bundle.putString("source", "Firebase");
                    bundle.putString("medium", "notification");
                    bundle.putString("campaign", string2);
                    analyticsConnector.logEvent("fcm", "_cmp", bundle);
                } else {
                    Log.w((String)"FirebaseMessaging", (String)"Unable to set user property for conversion tracking:  analytics library is missing");
                }
            } else if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)"Received event with track-conversion=false. Do not set user property");
            }
        }
        zzr.zza("_no", intent);
    }

    public static void zzb(Intent intent) {
        zzr.zza("_nd", intent);
    }

    public static void zzc(Intent intent) {
        zzr.zza("_nf", intent);
    }

    public static boolean zzd(Intent intent) {
        if (intent == null || zzr.zzn(intent)) {
            return false;
        }
        return "1".equals(intent.getStringExtra("google.c.a.e"));
    }

    public static boolean zze(Intent intent) {
        if (intent == null || zzr.zzn(intent)) {
            return false;
        }
        return zzr.zza();
    }

    private static boolean zzn(Intent intent) {
        return "com.google.firebase.messaging.RECEIVE_DIRECT_BOOT".equals(intent.getAction());
    }

    static boolean zza() {
        try {
            FirebaseApp.getInstance();
        }
        catch (IllegalStateException illegalStateException) {
            Log.i((String)"FirebaseMessaging", (String)"FirebaseApp has not being initialized. Device might be in direct boot mode. Skip exporting delivery metrics to Big Query");
            return false;
        }
        Context context = FirebaseApp.getInstance().getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
        if (sharedPreferences.contains("export_to_big_query")) {
            return sharedPreferences.getBoolean("export_to_big_query", false);
        }
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("delivery_metrics_exported_to_big_query_enabled")) {
                return applicationInfo.metaData.getBoolean("delivery_metrics_exported_to_big_query_enabled", false);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @VisibleForTesting
    private static void zza(String string, Intent intent) {
        String string2;
        String string3;
        Intent intent2;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        Bundle bundle = new Bundle();
        String string10 = intent.getStringExtra("google.c.a.c_id");
        if (string10 != null) {
            bundle.putString("_nmid", string10);
        }
        if ((string9 = intent.getStringExtra("google.c.a.c_l")) != null) {
            bundle.putString("_nmn", string9);
        }
        if (!TextUtils.isEmpty((CharSequence)(string8 = intent.getStringExtra("google.c.a.m_l")))) {
            bundle.putString("label", string8);
        }
        if (!TextUtils.isEmpty((CharSequence)(string7 = intent.getStringExtra("google.c.a.m_c")))) {
            bundle.putString("message_channel", string7);
        }
        if ((string6 = zzr.zzl(intent)) != null) {
            bundle.putString("_nt", string6);
        }
        if ((string5 = intent.getStringExtra("google.c.a.ts")) != null) {
            try {
                bundle.putInt("_nmt", Integer.parseInt(string5));
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)"FirebaseMessaging", (String)"Error while parsing timestamp in GCM event", (Throwable)numberFormatException);
            }
        }
        if ((string4 = (intent2 = intent).hasExtra("google.c.a.udt") ? intent2.getStringExtra("google.c.a.udt") : null) != null) {
            try {
                bundle.putInt("_ndt", Integer.parseInt(string4));
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)"FirebaseMessaging", (String)"Error while parsing use_device_time in GCM event", (Throwable)numberFormatException);
            }
        }
        String string11 = string3 = (intent2 = intent).getExtras() != null && zzt.zza(intent2.getExtras()) ? "display" : "data";
        if ("_nr".equals(string) || "_nf".equals(string)) {
            bundle.putString("_nmc", string3);
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            string2 = String.valueOf(bundle);
            Log.d((String)"FirebaseMessaging", (String)new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Logging to scion event=").append(string).append(" scionPayload=").append(string2).toString());
        }
        if ((string2 = (AnalyticsConnector)FirebaseApp.getInstance().get(AnalyticsConnector.class)) != null) {
            string2.logEvent("fcm", string, bundle);
            return;
        }
        Log.w((String)"FirebaseMessaging", (String)"Unable to log event: analytics library is missing");
    }

    static void zza(boolean bl) {
        FirebaseApp.getInstance().getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit().putBoolean("export_to_big_query", bl).apply();
    }

    @NonNull
    static int zzf(Intent intent) {
        Object object = intent.getExtras().get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string).length()).append("Invalid TTL: ").append(string).toString());
            }
        }
        return 0;
    }

    @Nullable
    static String zzg(Intent intent) {
        return intent.getStringExtra("collapse_key");
    }

    @Nullable
    static String zzh(Intent intent) {
        return intent.getStringExtra("google.c.a.c_l");
    }

    @Nullable
    static String zzi(Intent intent) {
        return intent.getStringExtra("google.c.a.m_l");
    }

    @Nullable
    static String zzj(Intent intent) {
        String string = intent.getStringExtra("google.message_id");
        if (string == null) {
            string = intent.getStringExtra("message_id");
        }
        return string;
    }

    @NonNull
    static String zzb() {
        return FirebaseApp.getInstance().getApplicationContext().getPackageName();
    }

    @NonNull
    static String zzc() {
        return FirebaseInstanceId.getInstance((FirebaseApp)FirebaseApp.getInstance()).getId();
    }

    @NonNull
    static String zzk(Intent intent) {
        if (intent.getExtras() != null && zzt.zza(intent.getExtras())) {
            return "DISPLAY_NOTIFICATION";
        }
        return "DATA_MESSAGE";
    }

    @Nullable
    static String zzl(Intent intent) {
        String string = intent.getStringExtra("from");
        if (string != null && string.startsWith("/topics/")) {
            return string;
        }
        return null;
    }

    @NonNull
    static int zzm(Intent intent) {
        String string;
        String string2 = intent.getStringExtra("google.delivered_priority");
        if (string2 == null) {
            if ("1".equals(intent.getStringExtra("google.priority_reduced"))) {
                return 2;
            }
            string2 = intent.getStringExtra("google.priority");
        }
        if ("high".equals(string = string2)) {
            return 1;
        }
        if ("normal".equals(string)) {
            return 2;
        }
        return 0;
    }

    @Nullable
    static String zzd() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        String string = firebaseApp.getOptions().getGcmSenderId();
        if (string != null) {
            return string;
        }
        String string2 = firebaseApp.getOptions().getApplicationId();
        if (!string2.startsWith("1:")) {
            return string2;
        }
        String[] stringArray = string2.split(":");
        if (stringArray.length < 2) {
            return null;
        }
        String string3 = stringArray[1];
        if (string3.isEmpty()) {
            return null;
        }
        return string3;
    }
}

