/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.zzao;
import com.google.firebase.iid.zzt;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.messaging.zzaa;
import com.google.firebase.messaging.zzad;
import com.google.firebase.messaging.zzy;
import com.google.firebase.messaging.zzz;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class zzab {
    private static final long zza = TimeUnit.HOURS.toSeconds(8L);
    private final FirebaseInstanceId zzb;
    private final Context zzc;
    private final zzao zzd;
    private final zzt zze;
    @GuardedBy(value="pendingOperations")
    private final Map<String, ArrayDeque<TaskCompletionSource<Void>>> zzf = new ArrayMap();
    private final ScheduledExecutorService zzg;
    @GuardedBy(value="this")
    private boolean zzh = false;
    private final zzy zzi;

    static Task<zzab> zza(FirebaseApp firebaseApp, FirebaseInstanceId firebaseInstanceId, zzao zzao2, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi, Context context, Executor executor, @NonNull ScheduledExecutorService scheduledExecutorService) {
        ScheduledExecutorService scheduledExecutorService2 = scheduledExecutorService;
        Context context2 = context;
        zzt zzt2 = new zzt(firebaseApp, zzao2, executor, userAgentPublisher, heartBeatInfo, firebaseInstallationsApi);
        zzao zzao3 = zzao2;
        FirebaseInstanceId firebaseInstanceId2 = firebaseInstanceId;
        return Tasks.call((Executor)scheduledExecutorService2, (Callable)new zzaa(context2, scheduledExecutorService2, firebaseInstanceId2, zzao3, zzt2));
    }

    private zzab(FirebaseInstanceId firebaseInstanceId, zzao zzao2, zzy zzy2, zzt zzt2, Context context, @NonNull ScheduledExecutorService scheduledExecutorService) {
        this.zzb = firebaseInstanceId;
        this.zzd = zzao2;
        this.zzi = zzy2;
        this.zze = zzt2;
        this.zzc = context;
        this.zzg = scheduledExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final Task<Void> zza(zzz zzz2) {
        TaskCompletionSource taskCompletionSource;
        this.zzi.zza(zzz2);
        TaskCompletionSource taskCompletionSource2 = taskCompletionSource = new TaskCompletionSource();
        zzz zzz3 = zzz2;
        zzab zzab2 = this;
        Map<String, ArrayDeque<TaskCompletionSource<Void>>> map = zzab2.zzf;
        synchronized (map) {
            ArrayDeque<Object> arrayDeque;
            String string = zzz3.zzc();
            if (zzab2.zzf.containsKey(string)) {
                arrayDeque = zzab2.zzf.get(string);
            } else {
                arrayDeque = new ArrayDeque();
                zzab2.zzf.put(string, arrayDeque);
            }
            arrayDeque.add(taskCompletionSource2);
        }
        return taskCompletionSource.getTask();
    }

    final void zza() {
        zzab zzab2;
        if (this.zzi.zza() != null && !(zzab2 = this).zzc()) {
            zzab2.zza(0L);
        }
    }

    final void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zza);
        zzad zzad2 = new zzad(this, this.zzc, this.zzd, l2);
        this.zza(zzad2, l);
        this.zza(true);
    }

    final void zza(Runnable runnable, long l) {
        this.zzg.schedule(runnable, l, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    final boolean zzb() throws IOException {
        while (true) {
            zzz zzz2;
            zzab zzab2 = this;
            synchronized (zzab2) {
                zzz2 = this.zzi.zza();
                if (zzz2 == null) {
                    if (zzab.zzd()) {
                        Log.d((String)"FirebaseMessaging", (String)"topic sync succeeded");
                    }
                    return true;
                }
            }
            if (!this.zzb(zzz2)) {
                return false;
            }
            this.zzi.zzb(zzz2);
            zzz zzz3 = zzz2;
            zzab zzab3 = this;
            Map<String, ArrayDeque<TaskCompletionSource<Void>>> map = zzab3.zzf;
            synchronized (map) {
                String string = zzz3.zzc();
                if (!zzab3.zzf.containsKey(string)) {
                    continue;
                }
                ArrayDeque<TaskCompletionSource<Void>> arrayDeque = zzab3.zzf.get(string);
                TaskCompletionSource<Void> taskCompletionSource = arrayDeque.poll();
                if (taskCompletionSource != null) {
                    taskCompletionSource.setResult(null);
                }
                if (arrayDeque.isEmpty()) {
                    zzab3.zzf.remove(string);
                }
            }
        }
    }

    @WorkerThread
    private final boolean zzb(zzz zzz2) throws IOException {
        try {
            switch (zzz2.zzb()) {
                case "S": {
                    String string = zzz2.zza();
                    zzab zzab2 = this;
                    InstanceIdResult instanceIdResult = (InstanceIdResult)zzab.zza(zzab2.zzb.getInstanceId());
                    zzab.zza(zzab2.zze.zzc(instanceIdResult.getId(), instanceIdResult.getToken(), string));
                    if (zzab.zzd()) {
                        String string2 = zzz2.zza();
                        Log.d((String)"FirebaseMessaging", (String)new StringBuilder(31 + String.valueOf(string2).length()).append("Subscribe to topic: ").append(string2).append(" succeeded.").toString());
                    }
                    break;
                }
                case "U": {
                    String string = zzz2.zza();
                    zzab zzab3 = this;
                    InstanceIdResult instanceIdResult = (InstanceIdResult)zzab.zza(zzab3.zzb.getInstanceId());
                    zzab.zza(zzab3.zze.zzd(instanceIdResult.getId(), instanceIdResult.getToken(), string));
                    if (zzab.zzd()) {
                        String string3 = zzz2.zza();
                        Log.d((String)"FirebaseMessaging", (String)new StringBuilder(35 + String.valueOf(string3).length()).append("Unsubscribe from topic: ").append(string3).append(" succeeded.").toString());
                    }
                    break;
                }
                default: {
                    if (zzab.zzd()) {
                        String string = String.valueOf(zzz2);
                        Log.d((String)"FirebaseMessaging", (String)new StringBuilder(24 + String.valueOf(string).length()).append("Unknown topic operation").append(string).append(".").toString());
                    }
                    break;
                }
            }
        }
        catch (IOException iOException) {
            if ("SERVICE_NOT_AVAILABLE".equals(iOException.getMessage()) || "INTERNAL_SERVER_ERROR".equals(iOException.getMessage())) {
                String string = iOException.getMessage();
                Log.e((String)"FirebaseMessaging", (String)new StringBuilder(53 + String.valueOf(string).length()).append("Topic operation failed: ").append(string).append(". Will retry Topic operation.").toString());
                return false;
            }
            if (iOException.getMessage() == null) {
                Log.e((String)"FirebaseMessaging", (String)"Topic operation failed without exception message. Will retry Topic operation.");
                return false;
            }
            throw iOException;
        }
        return true;
    }

    @WorkerThread
    private static <T> T zza(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE", exception);
        }
    }

    private final synchronized boolean zzc() {
        return this.zzh;
    }

    final synchronized void zza(boolean bl) {
        this.zzh = bl;
    }

    private static boolean zzd() {
        return Log.isLoggable((String)"FirebaseMessaging", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseMessaging", (int)3);
    }

    static final /* synthetic */ zzab zza(Context context, ScheduledExecutorService scheduledExecutorService, FirebaseInstanceId firebaseInstanceId, zzao zzao2, zzt zzt2) throws Exception {
        zzy zzy2 = zzy.zza(context, scheduledExecutorService);
        return new zzab(firebaseInstanceId, zzao2, zzy2, zzt2, context, scheduledExecutorService);
    }
}

