/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.TransportFactory;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzao;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.zzi;
import com.google.firebase.messaging.zzk;
import com.google.firebase.messaging.zzp;
import com.google.firebase.messaging.zzu;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class FirebaseMessaging {
    public static final String INSTANCE_ID_SCOPE = "FCM";
    private final Context zzb;
    private final FirebaseInstanceId zzc;
    private final zzu zzd;
    @Nullable
    @SuppressLint(value={"FirebaseUnknownNullness"})
    @VisibleForTesting
    static TransportFactory zza;

    @NonNull
    public static synchronized FirebaseMessaging getInstance() {
        return FirebaseMessaging.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    @NonNull
    static synchronized FirebaseMessaging getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseMessaging)firebaseApp.get(FirebaseMessaging.class);
    }

    FirebaseMessaging(FirebaseApp firebaseApp, FirebaseInstanceId firebaseInstanceId, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi, @Nullable TransportFactory transportFactory) {
        zza = transportFactory;
        this.zzc = firebaseInstanceId;
        this.zzb = firebaseApp.getApplicationContext();
        this.zzd = new zzu(firebaseApp, firebaseInstanceId, new zzao(this.zzb), userAgentPublisher, heartBeatInfo, firebaseInstallationsApi, this.zzb, zzi.zza(), new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("Firebase-Messaging-Topics-Io")));
        zzi.zzb().execute(new zzk(this));
    }

    public boolean isAutoInitEnabled() {
        return this.zzc.zzh();
    }

    public void setAutoInitEnabled(boolean bl) {
        this.zzc.zzb(bl);
    }

    @NonNull
    public boolean deliveryMetricsExportToBigQueryEnabled() {
        return zzp.zza();
    }

    public void setDeliveryMetricsExportToBigQuery(boolean bl) {
        zzp.zza(bl);
    }

    @NonNull
    public Task<Void> subscribeToTopic(@NonNull String string) {
        return this.zzd.zza(string);
    }

    @NonNull
    public Task<Void> unsubscribeFromTopic(@NonNull String string) {
        return this.zzd.zzb(string);
    }

    public void send(@NonNull RemoteMessage remoteMessage) {
        if (TextUtils.isEmpty((CharSequence)remoteMessage.getTo())) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        Intent intent2 = new Intent();
        intent2.setPackage("com.google.example.invalidpackage");
        intent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)this.zzb, (int)0, (Intent)intent2, (int)0));
        intent.setPackage("com.google.android.gms");
        Intent intent3 = intent;
        RemoteMessage remoteMessage2 = remoteMessage;
        intent3.putExtras(remoteMessage2.zza);
        this.zzb.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    final /* synthetic */ void zza() {
        if (this.isAutoInitEnabled()) {
            this.zzd.zza();
        }
    }
}

