/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zze;
import com.google.firebase.messaging.zzf;
import java.util.Map;

public final class RemoteMessage
extends com.google.android.gms.common.internal.safeparcel.zza {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzf();
    Bundle mBundle;
    private Map<String, String> zzdkx;
    private Notification zzmjx;

    RemoteMessage(Bundle bundle) {
        this.mBundle = bundle;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RemoteMessage remoteMessage = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Bundle)remoteMessage.mBundle, (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public final String getFrom() {
        return this.mBundle.getString("from");
    }

    public final String getTo() {
        return this.mBundle.getString("google.to");
    }

    public final Map<String, String> getData() {
        if (this.zzdkx == null) {
            this.zzdkx = new ArrayMap();
            for (String string2 : this.mBundle.keySet()) {
                Object object = this.mBundle.get(string2);
                if (!(object instanceof String)) continue;
                String string3 = (String)object;
                if (string2.startsWith("google.") || string2.startsWith("gcm.") || string2.equals("from") || string2.equals("message_type") || string2.equals("collapse_key")) continue;
                this.zzdkx.put(string2, string3);
            }
        }
        return this.zzdkx;
    }

    public final String getCollapseKey() {
        return this.mBundle.getString("collapse_key");
    }

    public final String getMessageId() {
        String string2 = this.mBundle.getString("google.message_id");
        if (string2 == null) {
            string2 = this.mBundle.getString("message_id");
        }
        return string2;
    }

    public final String getMessageType() {
        return this.mBundle.getString("message_type");
    }

    public final long getSentTime() {
        Object object = this.mBundle.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string2).length()).append("Invalid sent time: ").append(string2).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Object object = this.mBundle.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string2).length()).append("Invalid TTL: ").append(string2).toString());
            }
        }
        return 0;
    }

    public final Notification getNotification() {
        if (this.zzmjx == null && zza.zzac(this.mBundle)) {
            this.zzmjx = new Notification(this.mBundle, null);
        }
        return this.zzmjx;
    }

    public static class Notification {
        private final String zzehi;
        private final String zzmjy;
        private final String[] zzmjz;
        private final String zzbrs;
        private final String zzmka;
        private final String[] zzmkb;
        private final String zzmkc;
        private final String zzmkd;
        private final String mTag;
        private final String zzmke;
        private final String zzmkf;
        private final Uri zzmkg;

        private Notification(Bundle bundle) {
            this.zzehi = zza.zze(bundle, "gcm.n.title");
            this.zzmjy = zza.zzh(bundle, "gcm.n.title");
            this.zzmjz = Notification.zzk(bundle, "gcm.n.title");
            this.zzbrs = zza.zze(bundle, "gcm.n.body");
            this.zzmka = zza.zzh(bundle, "gcm.n.body");
            this.zzmkb = Notification.zzk(bundle, "gcm.n.body");
            this.zzmkc = zza.zze(bundle, "gcm.n.icon");
            this.zzmkd = zza.zzae(bundle);
            this.mTag = zza.zze(bundle, "gcm.n.tag");
            this.zzmke = zza.zze(bundle, "gcm.n.color");
            this.zzmkf = zza.zze(bundle, "gcm.n.click_action");
            this.zzmkg = zza.zzad(bundle);
        }

        private static String[] zzk(Bundle bundle, String string2) {
            Object[] objectArray = zza.zzi(bundle, string2);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.zzehi;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zzmjy;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zzmjz;
        }

        @Nullable
        public String getBody() {
            return this.zzbrs;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zzmka;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zzmkb;
        }

        @Nullable
        public String getIcon() {
            return this.zzmkc;
        }

        @Nullable
        public String getSound() {
            return this.zzmkd;
        }

        @Nullable
        public String getTag() {
            return this.mTag;
        }

        @Nullable
        public String getColor() {
            return this.zzmke;
        }

        @Nullable
        public String getClickAction() {
            return this.zzmkf;
        }

        @Nullable
        public Uri getLink() {
            return this.zzmkg;
        }

        /* synthetic */ Notification(Bundle bundle, zze zze2) {
            this(bundle);
        }
    }

    public static class Builder {
        private final Bundle mBundle = new Bundle();
        private final Map<String, String> zzdkx = new ArrayMap();

        public Builder(String string2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = String.valueOf(string2);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid to: ".concat(string3) : new String("Invalid to: "));
            }
            this.mBundle.putString("google.to", string2);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzdkx.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.mBundle);
            String string2 = FirebaseInstanceId.getInstance().getToken();
            if (string2 != null) {
                this.mBundle.putString("from", string2);
            } else {
                this.mBundle.remove("from");
            }
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string2, String string3) {
            this.zzdkx.put(string2, string3);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzdkx.clear();
            this.zzdkx.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzdkx.clear();
            return this;
        }

        public Builder setMessageId(String string2) {
            this.mBundle.putString("google.message_id", string2);
            return this;
        }

        public Builder setMessageType(String string2) {
            this.mBundle.putString("message_type", string2);
            return this;
        }

        public Builder setTtl(int n) {
            this.mBundle.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string2) {
            this.mBundle.putString("collapse_key", string2);
            return this;
        }
    }
}

