/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zze;
import java.util.Map;

public final class RemoteMessage
extends com.google.android.gms.common.internal.safeparcel.zza {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zze();
    Bundle zzaic;
    private Map<String, String> zzacc;
    private Notification zzclD;

    RemoteMessage(Bundle bundle) {
        this.zzaic = bundle;
    }

    void zzM(Intent intent) {
        intent.putExtras(this.zzaic);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    public String getFrom() {
        return this.zzaic.getString("from");
    }

    public String getTo() {
        return this.zzaic.getString("google.to");
    }

    public Map<String, String> getData() {
        if (this.zzacc == null) {
            this.zzacc = new ArrayMap();
            for (String string : this.zzaic.keySet()) {
                Object object = this.zzaic.get(string);
                if (!(object instanceof String)) continue;
                String string2 = (String)object;
                if (string.startsWith("google.") || string.startsWith("gcm.") || string.equals("from") || string.equals("message_type") || string.equals("collapse_key")) continue;
                this.zzacc.put(string, string2);
            }
        }
        return this.zzacc;
    }

    public String getCollapseKey() {
        return this.zzaic.getString("collapse_key");
    }

    public String getMessageId() {
        String string = this.zzaic.getString("google.message_id");
        if (string == null) {
            string = this.zzaic.getString("message_id");
        }
        return string;
    }

    public String getMessageType() {
        return this.zzaic.getString("message_type");
    }

    public long getSentTime() {
        Object object = this.zzaic.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string).length()).append("Invalid sent time: ").append(string).toString());
            }
        }
        return 0L;
    }

    public int getTtl() {
        Object object = this.zzaic.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string).length()).append("Invalid TTL: ").append(string).toString());
            }
        }
        return 0;
    }

    public Notification getNotification() {
        if (this.zzclD == null && zza.zzE(this.zzaic)) {
            this.zzclD = new Notification(this.zzaic);
        }
        return this.zzclD;
    }

    public static class Notification {
        private final String zzamJ;
        private final String zzclE;
        private final String[] zzclF;
        private final String zzGr;
        private final String zzclG;
        private final String[] zzclH;
        private final String zzclI;
        private final String zzclJ;
        private final String mTag;
        private final String zzaQM;
        private final String zzclK;
        private final Uri zzclL;

        private Notification(Bundle bundle) {
            this.zzamJ = zza.zzf(bundle, "gcm.n.title");
            this.zzclE = zza.zzi(bundle, "gcm.n.title");
            this.zzclF = this.zzk(bundle, "gcm.n.title");
            this.zzGr = zza.zzf(bundle, "gcm.n.body");
            this.zzclG = zza.zzi(bundle, "gcm.n.body");
            this.zzclH = this.zzk(bundle, "gcm.n.body");
            this.zzclI = zza.zzf(bundle, "gcm.n.icon");
            this.zzclJ = zza.zzU(bundle);
            this.mTag = zza.zzf(bundle, "gcm.n.tag");
            this.zzaQM = zza.zzf(bundle, "gcm.n.color");
            this.zzclK = zza.zzf(bundle, "gcm.n.click_action");
            this.zzclL = zza.zzT(bundle);
        }

        private String[] zzk(Bundle bundle, String string) {
            Object[] objectArray = zza.zzj(bundle, string);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.zzamJ;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zzclE;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zzclF;
        }

        @Nullable
        public String getBody() {
            return this.zzGr;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zzclG;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zzclH;
        }

        @Nullable
        public String getIcon() {
            return this.zzclI;
        }

        @Nullable
        public String getSound() {
            return this.zzclJ;
        }

        @Nullable
        public String getTag() {
            return this.mTag;
        }

        @Nullable
        public String getColor() {
            return this.zzaQM;
        }

        @Nullable
        public String getClickAction() {
            return this.zzclK;
        }

        @Nullable
        public Uri getLink() {
            return this.zzclL;
        }
    }

    public static class Builder {
        private final Bundle zzaic = new Bundle();
        private final Map<String, String> zzacc = new ArrayMap();

        public Builder(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid to: ".concat(string2) : new String("Invalid to: "));
            }
            this.zzaic.putString("google.to", string);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzacc.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.zzaic);
            String string = FirebaseInstanceId.getInstance().getToken();
            if (string != null) {
                this.zzaic.putString("from", string);
            } else {
                this.zzaic.remove("from");
            }
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string, String string2) {
            this.zzacc.put(string, string2);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzacc.clear();
            this.zzacc.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzacc.clear();
            return this;
        }

        public Builder setMessageId(String string) {
            this.zzaic.putString("google.message_id", string);
            return this;
        }

        public Builder setMessageType(String string) {
            this.zzaic.putString("message_type", string);
            return this;
        }

        public Builder setTtl(int n) {
            this.zzaic.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string) {
            this.zzaic.putString("collapse_key", string);
            return this;
        }
    }
}

