/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.firebase.iid.zzg;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.SendException;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzb;
import java.util.Iterator;

public class FirebaseMessagingService
extends com.google.firebase.iid.zzb {
    @WorkerThread
    public void onMessageReceived(RemoteMessage remoteMessage) {
    }

    @WorkerThread
    public void onDeletedMessages() {
    }

    @WorkerThread
    public void onMessageSent(String string) {
    }

    @WorkerThread
    public void onSendError(String string, Exception exception) {
    }

    protected Intent zzF(Intent intent) {
        return zzg.zzaaj().zzaal();
    }

    public boolean zzH(Intent intent) {
        if ("com.google.firebase.messaging.NOTIFICATION_OPEN".equals(intent.getAction())) {
            this.zzK(intent);
            return true;
        }
        return false;
    }

    private void zzK(Intent intent) {
        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra("pending_intent");
        if (pendingIntent != null) {
            try {
                pendingIntent.send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.e((String)"FirebaseMessaging", (String)"Notification pending intent canceled");
            }
        }
        if (FirebaseMessagingService.zzW(intent.getExtras())) {
            zzb.zzj((Context)this, intent);
        }
    }

    public void zzm(Intent intent) {
        String string = intent.getAction();
        if (string == null) {
            string = "";
        }
        switch (string) {
            case "com.google.android.c2dm.intent.RECEIVE": {
                this.zzn(intent);
                break;
            }
            case "com.google.firebase.messaging.NOTIFICATION_DISMISS": {
                if (!FirebaseMessagingService.zzW(intent.getExtras())) break;
                zzb.zzk((Context)this, intent);
                break;
            }
            default: {
                String string2 = String.valueOf(intent.getAction());
                Log.d((String)"FirebaseMessaging", (String)(string2.length() != 0 ? "Unknown intent action: ".concat(string2) : new String("Unknown intent action: ")));
            }
        }
    }

    private void zzn(Intent intent) {
        String string = intent.getStringExtra("message_type");
        if (string == null) {
            string = "gcm";
        }
        switch (string) {
            case "gcm": {
                if (FirebaseMessagingService.zzW(intent.getExtras())) {
                    zzb.zzi((Context)this, intent);
                }
                this.zzo(intent);
                break;
            }
            case "deleted_messages": {
                this.onDeletedMessages();
                break;
            }
            case "send_event": {
                this.onMessageSent(intent.getStringExtra("google.message_id"));
                break;
            }
            case "send_error": {
                this.onSendError(this.zzp(intent), new SendException(intent.getStringExtra("error")));
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                Log.w((String)"FirebaseMessaging", (String)(string2.length() != 0 ? "Received message with unknown type: ".concat(string2) : new String("Received message with unknown type: ")));
            }
        }
    }

    private void zzo(Intent intent) {
        Bundle bundle = intent.getExtras();
        bundle.remove("android.support.content.wakelockid");
        if (zza.zzE(bundle)) {
            if (!zza.zzbc((Context)this)) {
                zza.zzca((Context)this).zzT(bundle);
                return;
            }
            if (FirebaseMessagingService.zzW(bundle)) {
                zzb.zzl((Context)this, intent);
            }
        }
        this.onMessageReceived(new RemoteMessage(bundle));
    }

    private String zzp(Intent intent) {
        String string = intent.getStringExtra("google.message_id");
        if (string == null) {
            string = intent.getStringExtra("message_id");
        }
        return string;
    }

    static void zzD(Bundle bundle) {
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || !string.startsWith("google.c.")) continue;
            iterator.remove();
        }
    }

    static boolean zzW(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        return "1".equals(bundle.getString("google.c.a.e"));
    }
}

