/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.firebase.installations.local.PersistedInstallationEntry;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

class Utils {
    public static final long AUTH_TOKEN_EXPIRATION_BUFFER_IN_SECS = TimeUnit.HOURS.toSeconds(1L);
    private static final String APP_ID_IDENTIFICATION_SUBSTRING = ":";
    private static final Pattern API_KEY_FORMAT = Pattern.compile("\\AA[\\w-]{38}\\z");

    Utils() {
    }

    public boolean isAuthTokenExpired(PersistedInstallationEntry entry) {
        if (TextUtils.isEmpty((CharSequence)entry.getAuthToken())) {
            return true;
        }
        return entry.getTokenCreationEpochInSecs() + entry.getExpiresInSecs() < this.currentTimeInSecs() + AUTH_TOKEN_EXPIRATION_BUFFER_IN_SECS;
    }

    public long currentTimeInSecs() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }

    static boolean isValidAppIdFormat(@Nullable String appId) {
        return appId.contains(APP_ID_IDENTIFICATION_SUBSTRING);
    }

    static boolean isValidApiKeyFormat(@Nullable String apiKey) {
        return API_KEY_FORMAT.matcher(apiKey).matches();
    }
}

