/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations;

import androidx.annotation.NonNull;
import com.google.firebase.installations.InstallationTokenResult;

final class AutoValue_InstallationTokenResult
extends InstallationTokenResult {
    private final String token;
    private final long tokenExpirationTimestamp;
    private final long tokenCreationTimestamp;

    private AutoValue_InstallationTokenResult(String token, long tokenExpirationTimestamp, long tokenCreationTimestamp) {
        this.token = token;
        this.tokenExpirationTimestamp = tokenExpirationTimestamp;
        this.tokenCreationTimestamp = tokenCreationTimestamp;
    }

    @Override
    @NonNull
    public String getToken() {
        return this.token;
    }

    @Override
    @NonNull
    public long getTokenExpirationTimestamp() {
        return this.tokenExpirationTimestamp;
    }

    @Override
    @NonNull
    public long getTokenCreationTimestamp() {
        return this.tokenCreationTimestamp;
    }

    public String toString() {
        return "InstallationTokenResult{token=" + this.token + ", tokenExpirationTimestamp=" + this.tokenExpirationTimestamp + ", tokenCreationTimestamp=" + this.tokenCreationTimestamp + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstallationTokenResult) {
            InstallationTokenResult that = (InstallationTokenResult)o;
            return this.token.equals(that.getToken()) && this.tokenExpirationTimestamp == that.getTokenExpirationTimestamp() && this.tokenCreationTimestamp == that.getTokenCreationTimestamp();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.token.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.tokenExpirationTimestamp >>> 32 ^ this.tokenExpirationTimestamp);
        h$ *= 1000003;
        return h$ ^= (int)(this.tokenCreationTimestamp >>> 32 ^ this.tokenCreationTimestamp);
    }

    @Override
    public InstallationTokenResult.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends InstallationTokenResult.Builder {
        private String token;
        private Long tokenExpirationTimestamp;
        private Long tokenCreationTimestamp;

        Builder() {
        }

        private Builder(InstallationTokenResult source) {
            this.token = source.getToken();
            this.tokenExpirationTimestamp = source.getTokenExpirationTimestamp();
            this.tokenCreationTimestamp = source.getTokenCreationTimestamp();
        }

        @Override
        public InstallationTokenResult.Builder setToken(String token) {
            if (token == null) {
                throw new NullPointerException("Null token");
            }
            this.token = token;
            return this;
        }

        @Override
        public InstallationTokenResult.Builder setTokenExpirationTimestamp(long tokenExpirationTimestamp) {
            this.tokenExpirationTimestamp = tokenExpirationTimestamp;
            return this;
        }

        @Override
        public InstallationTokenResult.Builder setTokenCreationTimestamp(long tokenCreationTimestamp) {
            this.tokenCreationTimestamp = tokenCreationTimestamp;
            return this;
        }

        @Override
        public InstallationTokenResult build() {
            String missing = "";
            if (this.token == null) {
                missing = missing + " token";
            }
            if (this.tokenExpirationTimestamp == null) {
                missing = missing + " tokenExpirationTimestamp";
            }
            if (this.tokenCreationTimestamp == null) {
                missing = missing + " tokenCreationTimestamp";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_InstallationTokenResult(this.token, this.tokenExpirationTimestamp, this.tokenCreationTimestamp);
        }
    }
}

