/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import android.app.Application;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import javax.inject.Inject;

public class SharedPreferencesUtils {
    @VisibleForTesting
    static final String PREFERENCES_PACKAGE_NAME = "com.google.firebase.inappmessaging";
    private final FirebaseApp firebaseApp;

    @Inject
    public SharedPreferencesUtils(FirebaseApp firebaseApp) {
        this.firebaseApp = firebaseApp;
    }

    public void setBooleanPreference(String preference, boolean value) {
        Application application = (Application)this.firebaseApp.getApplicationContext();
        SharedPreferences.Editor preferencesEditor = application.getSharedPreferences(PREFERENCES_PACKAGE_NAME, 0).edit();
        preferencesEditor.putBoolean(preference, value);
        preferencesEditor.apply();
    }

    public void clearPreference(String preference) {
        Application application = (Application)this.firebaseApp.getApplicationContext();
        SharedPreferences.Editor preferencesEditor = application.getSharedPreferences(PREFERENCES_PACKAGE_NAME, 0).edit();
        preferencesEditor.remove(preference);
        preferencesEditor.apply();
    }

    public boolean getAndSetBooleanPreference(String preference, boolean defaultValue) {
        Application application = (Application)this.firebaseApp.getApplicationContext();
        SharedPreferences preferences = application.getSharedPreferences(PREFERENCES_PACKAGE_NAME, 0);
        if (preferences.contains(preference)) {
            boolean result = preferences.getBoolean(preference, defaultValue);
            return result;
        }
        this.setBooleanPreference(preference, defaultValue);
        return defaultValue;
    }

    public boolean getBooleanPreference(String preference, boolean defaultValue) {
        Application application = (Application)this.firebaseApp.getApplicationContext();
        SharedPreferences preferences = application.getSharedPreferences(PREFERENCES_PACKAGE_NAME, 0);
        if (preferences.contains(preference)) {
            boolean result = preferences.getBoolean(preference, defaultValue);
            return result;
        }
        return defaultValue;
    }

    public boolean isPreferenceSet(String preference) {
        Application application = (Application)this.firebaseApp.getApplicationContext();
        SharedPreferences preferences = application.getSharedPreferences(PREFERENCES_PACKAGE_NAME, 0);
        return preferences.contains(preference);
    }

    public boolean isManifestSet(String preference) {
        Application application = (Application)this.firebaseApp.getApplicationContext();
        try {
            PackageManager packageManager = application.getPackageManager();
            if (packageManager != null) {
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo(application.getPackageName(), 128);
                return applicationInfo != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey(preference);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public boolean getBooleanManifestValue(String preference, boolean defaultValue) {
        Application application = (Application)this.firebaseApp.getApplicationContext();
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = application.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(application.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey(preference)) {
                return applicationInfo.metaData.getBoolean(preference);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return defaultValue;
    }
}

