// Copyright 2018 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.firebase.inappmessaging.internal.injection.modules;

import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.inappmessaging.internal.AnalyticsEventsManager;
import com.google.firebase.inappmessaging.internal.injection.qualifiers.AnalyticsListener;
import dagger.Module;
import dagger.Provides;
import io.reactivex.flowables.ConnectableFlowable;
import javax.inject.Singleton;

/**
 * Bindings for firebase analytics events generated by listeners registered with scion using {@link
 * com.google.firebase.analytics.connector.AnalyticsConnector}.
 *
 * @hide
 */
@Module
public class AnalyticsEventsModule {

  @Provides
  @AnalyticsListener
  @Singleton
  ConnectableFlowable<String> providesAnalyticsConnectorEvents(
      AnalyticsEventsManager analyticsEventsManager) {
    return analyticsEventsManager.getAnalyticsEventsFlowable();
  }

  @Provides
  @Singleton
  AnalyticsEventsManager providesAnalyticsEventsManager(AnalyticsConnector analyticsConnector) {
    return new AnalyticsEventsManager(analyticsConnector);
  }
}
