/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.model;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.CampaignMetadata;
import com.google.firebase.inappmessaging.model.ImageData;
import com.google.firebase.inappmessaging.model.InAppMessage;
import com.google.firebase.inappmessaging.model.MessageType;
import com.google.firebase.inappmessaging.model.Text;
import java.util.Map;
import javax.annotation.Nullable;

public class ModalMessage
extends InAppMessage {
    @NonNull
    private final Text title;
    @Nullable
    private final Text body;
    @Nullable
    private final ImageData imageData;
    @Nullable
    private final Action action;
    @NonNull
    private final String backgroundHexColor;

    public int hashCode() {
        int bodyHash = this.body != null ? this.body.hashCode() : 0;
        int actionHash = this.action != null ? this.action.hashCode() : 0;
        int imageHash = this.imageData != null ? this.imageData.hashCode() : 0;
        return this.title.hashCode() + bodyHash + this.backgroundHexColor.hashCode() + actionHash + imageHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModalMessage)) {
            return false;
        }
        ModalMessage m = (ModalMessage)o;
        if (this.hashCode() != m.hashCode()) {
            return false;
        }
        if (this.body == null && m.body != null || this.body != null && !this.body.equals(m.body)) {
            return false;
        }
        if (this.action == null && m.action != null || this.action != null && !this.action.equals(m.action)) {
            return false;
        }
        if (this.imageData == null && m.imageData != null || this.imageData != null && !this.imageData.equals(m.imageData)) {
            return false;
        }
        if (!this.title.equals(m.title)) {
            return false;
        }
        return this.backgroundHexColor.equals(m.backgroundHexColor);
    }

    private ModalMessage(@NonNull CampaignMetadata campaignMetadata, @NonNull Text title, @Nullable Text body, @Nullable ImageData imageData, @Nullable Action action, @NonNull String backgroundHexColor, @Nullable Map<String, String> data) {
        super(campaignMetadata, MessageType.MODAL, data);
        this.title = title;
        this.body = body;
        this.imageData = imageData;
        this.action = action;
        this.backgroundHexColor = backgroundHexColor;
    }

    @Override
    @NonNull
    public Text getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public Text getBody() {
        return this.body;
    }

    @Override
    @Nullable
    public ImageData getImageData() {
        return this.imageData;
    }

    @Override
    @NonNull
    public String getBackgroundHexColor() {
        return this.backgroundHexColor;
    }

    @Override
    @Nullable
    public Action getAction() {
        return this.action;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        Text title;
        @Nullable
        Text body;
        @Nullable
        ImageData imageData;
        @Nullable
        Action action;
        @Nullable
        String backgroundHexColor;

        public Builder setTitle(@Nullable Text title) {
            this.title = title;
            return this;
        }

        public Builder setBody(@Nullable Text body) {
            this.body = body;
            return this;
        }

        public Builder setImageData(@Nullable ImageData imageData) {
            this.imageData = imageData;
            return this;
        }

        public Builder setAction(@Nullable Action action) {
            this.action = action;
            return this;
        }

        public Builder setBackgroundHexColor(@Nullable String backgroundHexColor) {
            this.backgroundHexColor = backgroundHexColor;
            return this;
        }

        public ModalMessage build(CampaignMetadata campaignMetadata, @Nullable Map<String, String> data) {
            if (this.title == null) {
                throw new IllegalArgumentException("Modal model must have a title");
            }
            if (this.action != null && this.action.getButton() == null) {
                throw new IllegalArgumentException("Modal model action must be null or have a button");
            }
            if (TextUtils.isEmpty((CharSequence)this.backgroundHexColor)) {
                throw new IllegalArgumentException("Modal model must have a background color");
            }
            return new ModalMessage(campaignMetadata, this.title, this.body, this.imageData, this.action, this.backgroundHexColor, data);
        }
    }
}

