/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal.injection.modules;

import androidx.annotation.NonNull;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.inappmessaging.dagger.Module;
import com.google.firebase.inappmessaging.dagger.Provides;
import java.util.concurrent.Executor;
import javax.inject.Singleton;

@Module
public class ExecutorsModule {
    private final Executor backgroundExecutor;
    private final Executor blockingExecutor;
    private final Executor lightWeightExecutor;

    public ExecutorsModule(@NonNull @Lightweight Executor lightWeightExecutor, @NonNull @Background Executor backgroundExecutor, @NonNull @Blocking Executor blockingExecutor) {
        this.lightWeightExecutor = lightWeightExecutor;
        this.backgroundExecutor = backgroundExecutor;
        this.blockingExecutor = blockingExecutor;
    }

    @Provides
    @Singleton
    @Background
    @NonNull
    public Executor providesBackgroundExecutor() {
        return this.backgroundExecutor;
    }

    @Provides
    @Singleton
    @Lightweight
    @NonNull
    public Executor providesLightWeightExecutor() {
        return this.lightWeightExecutor;
    }

    @Provides
    @Singleton
    @Blocking
    @NonNull
    public Executor providesBlockingExecutor() {
        return this.blockingExecutor;
    }
}

