/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingDisplayCallbacks;
import com.google.firebase.inappmessaging.internal.CampaignCacheClient;
import com.google.firebase.inappmessaging.internal.DataCollectionHelper;
import com.google.firebase.inappmessaging.internal.ImpressionStorageClient;
import com.google.firebase.inappmessaging.internal.InAppMessageStreamManager;
import com.google.firebase.inappmessaging.internal.Logging;
import com.google.firebase.inappmessaging.internal.MetricsLoggerClient;
import com.google.firebase.inappmessaging.internal.RateLimiterClient;
import com.google.firebase.inappmessaging.internal.Schedulers;
import com.google.firebase.inappmessaging.internal.time.Clock;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.InAppMessage;
import com.google.firebase.inappmessaging.model.RateLimit;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.CampaignImpression;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;

public class DisplayCallbacksImpl
implements FirebaseInAppMessagingDisplayCallbacks {
    private final ImpressionStorageClient impressionStorageClient;
    private final Clock clock;
    private final Schedulers schedulers;
    private final RateLimiterClient rateLimiterClient;
    private final CampaignCacheClient campaignCacheClient;
    private final RateLimit appForegroundRateLimit;
    private final MetricsLoggerClient metricsLoggerClient;
    private final DataCollectionHelper dataCollectionHelper;
    private final InAppMessage inAppMessage;
    private final String triggeringEvent;
    private boolean wasImpressed;
    private static final String MESSAGE_CLICK = "message click to metrics logger";

    @VisibleForTesting
    DisplayCallbacksImpl(ImpressionStorageClient impressionStorageClient, Clock clock, Schedulers schedulers, RateLimiterClient rateLimiterClient, CampaignCacheClient campaignCacheClient, RateLimit appForegroundRateLimit, MetricsLoggerClient metricsLoggerClient, DataCollectionHelper dataCollectionHelper, InAppMessage inAppMessage, String triggeringEvent) {
        this.impressionStorageClient = impressionStorageClient;
        this.clock = clock;
        this.schedulers = schedulers;
        this.rateLimiterClient = rateLimiterClient;
        this.campaignCacheClient = campaignCacheClient;
        this.appForegroundRateLimit = appForegroundRateLimit;
        this.metricsLoggerClient = metricsLoggerClient;
        this.dataCollectionHelper = dataCollectionHelper;
        this.inAppMessage = inAppMessage;
        this.triggeringEvent = triggeringEvent;
        this.wasImpressed = false;
    }

    @VisibleForTesting
    boolean wasImpressed() {
        return this.wasImpressed;
    }

    @Override
    public Task<Void> impressionDetected() {
        String MESSAGE_IMPRESSION = "message impression to metrics logger";
        if (this.shouldLog() && !this.wasImpressed) {
            Logging.logd("Attempting to record: " + MESSAGE_IMPRESSION);
            Completable logImpressionToMetricsLogger = Completable.fromAction(() -> this.metricsLoggerClient.logImpression(this.inAppMessage));
            Completable logImpressionCompletable = this.logToImpressionStore().andThen((CompletableSource)logImpressionToMetricsLogger).andThen((CompletableSource)this.updateWasImpressed());
            return DisplayCallbacksImpl.maybeToTask(logImpressionCompletable.toMaybe(), this.schedulers.io());
        }
        this.logActionNotTaken(MESSAGE_IMPRESSION);
        return new TaskCompletionSource().getTask();
    }

    private Completable updateWasImpressed() {
        return Completable.fromAction(() -> {
            this.wasImpressed = true;
        });
    }

    @Override
    public Task<Void> messageDismissed(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingDismissType dismissType) {
        String MESSAGE_DISMISSAL = "message dismissal to metrics logger";
        if (this.shouldLog()) {
            Logging.logd("Attempting to record: " + MESSAGE_DISMISSAL);
            Completable completable = Completable.fromAction(() -> this.metricsLoggerClient.logDismiss(this.inAppMessage, dismissType));
            return this.logImpressionIfNeeded(completable);
        }
        this.logActionNotTaken(MESSAGE_DISMISSAL);
        return new TaskCompletionSource().getTask();
    }

    @Deprecated
    public Task<Void> messageClicked() {
        return this.messageClicked(this.inAppMessage.getAction());
    }

    @Override
    public Task<Void> messageClicked(Action action) {
        if (this.shouldLog()) {
            if (action.getActionUrl() == null) {
                return this.messageDismissed(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingDismissType.CLICK);
            }
            return this.logMessageClick(action);
        }
        this.logActionNotTaken(MESSAGE_CLICK);
        return new TaskCompletionSource().getTask();
    }

    private Task<Void> logMessageClick(Action action) {
        Logging.logd("Attempting to record: message click to metrics logger");
        Completable completable = Completable.fromAction(() -> this.metricsLoggerClient.logMessageClick(this.inAppMessage, action));
        return this.logImpressionIfNeeded(completable);
    }

    private boolean actionMatches(Action messageAction, Action actionTaken) {
        if (messageAction == null) {
            return actionTaken == null || TextUtils.isEmpty((CharSequence)actionTaken.getActionUrl());
        }
        return messageAction.getActionUrl().equals(actionTaken.getActionUrl());
    }

    @Override
    public Task<Void> displayErrorEncountered(FirebaseInAppMessagingDisplayCallbacks.InAppMessagingErrorReason errorReason) {
        String RENDER_ERROR = "render error to metrics logger";
        if (this.shouldLog()) {
            Logging.logd("Attempting to record: " + RENDER_ERROR);
            Completable completable = Completable.fromAction(() -> this.metricsLoggerClient.logRenderError(this.inAppMessage, errorReason));
            return DisplayCallbacksImpl.maybeToTask(this.logToImpressionStore().andThen((CompletableSource)completable).andThen((CompletableSource)this.updateWasImpressed()).toMaybe(), this.schedulers.io());
        }
        this.logActionNotTaken(RENDER_ERROR);
        return new TaskCompletionSource().getTask();
    }

    private boolean shouldLog() {
        return this.dataCollectionHelper.isAutomaticDataCollectionEnabled();
    }

    private Task<Void> logImpressionIfNeeded(Completable actionToTake) {
        if (!this.wasImpressed) {
            this.impressionDetected();
        }
        return DisplayCallbacksImpl.maybeToTask(actionToTake.toMaybe(), this.schedulers.io());
    }

    private void logActionNotTaken(String action, Maybe<String> reason) {
        if (reason != null) {
            Logging.logd(String.format("Not recording: %s. Reason: %s", action, reason));
        } else if (this.inAppMessage.getCampaignMetadata().getIsTestMessage()) {
            Logging.logd(String.format("Not recording: %s. Reason: Message is test message", action));
        } else if (!this.dataCollectionHelper.isAutomaticDataCollectionEnabled()) {
            Logging.logd(String.format("Not recording: %s. Reason: Data collection is disabled", action));
        } else {
            Logging.logd(String.format("Not recording: %s", action));
        }
    }

    private void logActionNotTaken(String action) {
        this.logActionNotTaken(action, null);
    }

    private Completable logToImpressionStore() {
        String campaignId = this.inAppMessage.getCampaignMetadata().getCampaignId();
        Logging.logd("Attempting to record message impression in impression store for id: " + campaignId);
        Completable storeCampaignImpression = this.impressionStorageClient.storeImpression((CampaignImpression)CampaignImpression.newBuilder().setImpressionTimestampMillis(this.clock.now()).setCampaignId(campaignId).build()).doOnError(e -> Logging.loge("Impression store write failure")).doOnComplete(() -> Logging.logd("Impression store write success"));
        if (InAppMessageStreamManager.isAppForegroundEvent(this.triggeringEvent)) {
            Completable incrementAppForegroundRateLimit = this.rateLimiterClient.increment(this.appForegroundRateLimit).doOnError(e -> Logging.loge("Rate limiter client write failure")).doOnComplete(() -> Logging.logd("Rate limiter client write success")).onErrorComplete();
            return incrementAppForegroundRateLimit.andThen((CompletableSource)storeCampaignImpression);
        }
        return storeCampaignImpression;
    }

    private static <T> Task<T> maybeToTask(Maybe<T> maybe, Scheduler scheduler) {
        TaskCompletionSource tcs = new TaskCompletionSource();
        Disposable ignoredDisposable = maybe.doOnSuccess(arg_0 -> ((TaskCompletionSource)tcs).setResult(arg_0)).switchIfEmpty((MaybeSource)Maybe.fromCallable(() -> {
            tcs.setResult(null);
            return null;
        })).onErrorResumeNext(throwable -> {
            if (throwable instanceof Exception) {
                tcs.setException((Exception)throwable);
            } else {
                tcs.setException((Exception)new RuntimeException((Throwable)throwable));
            }
            return Maybe.empty();
        }).subscribeOn(scheduler).subscribe();
        return tcs.getTask();
    }
}

