/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import androidx.annotation.VisibleForTesting;
import com.google.firebase.abt.AbtException;
import com.google.firebase.abt.AbtExperimentInfo;
import com.google.firebase.abt.FirebaseABTesting;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.inappmessaging.ExperimentPayloadProto;
import com.google.firebase.inappmessaging.internal.Logging;
import com.google.firebase.inappmessaging.internal.injection.scopes.FirebaseAppScope;
import com.google.internal.firebase.inappmessaging.v1.CampaignProto;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.FetchEligibleCampaignsResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executor;
import javax.inject.Inject;

@FirebaseAppScope
public class AbtIntegrationHelper {
    private final FirebaseABTesting abTesting;
    @VisibleForTesting
    Executor executor;

    @Inject
    public AbtIntegrationHelper(FirebaseABTesting abTesting, @Blocking Executor blockingExecutor) {
        this.abTesting = abTesting;
        this.executor = blockingExecutor;
    }

    void updateRunningExperiments(FetchEligibleCampaignsResponse response) {
        ArrayList<AbtExperimentInfo> runningExperiments = new ArrayList<AbtExperimentInfo>();
        for (CampaignProto.ThickContent content : response.getMessagesList()) {
            if (content.getIsTestCampaign() || !content.getPayloadCase().equals((Object)CampaignProto.ThickContent.PayloadCase.EXPERIMENTAL_PAYLOAD)) continue;
            ExperimentPayloadProto.ExperimentPayload payload = content.getExperimentalPayload().getExperimentPayload();
            runningExperiments.add(new AbtExperimentInfo(payload.getExperimentId(), payload.getVariantId(), payload.getTriggerEvent(), new Date(payload.getExperimentStartTimeMillis()), payload.getTriggerTimeoutMillis(), payload.getTimeToLiveMillis()));
        }
        if (runningExperiments.isEmpty()) {
            return;
        }
        this.executor.execute(() -> {
            try {
                Logging.logd("Updating running experiments with: " + runningExperiments.size() + " experiments");
                this.abTesting.validateRunningExperiments((List)runningExperiments);
            }
            catch (AbtException e) {
                Logging.loge("Unable to register experiments with ABT, missing analytics?\n" + e.getMessage());
            }
        });
    }

    void setExperimentActive(ExperimentPayloadProto.ExperimentPayload payload) {
        this.executor.execute(() -> {
            try {
                Logging.logd("Updating active experiment: " + payload.toString());
                this.abTesting.reportActiveExperiment(new AbtExperimentInfo(payload.getExperimentId(), payload.getVariantId(), payload.getTriggerEvent(), new Date(payload.getExperimentStartTimeMillis()), payload.getTriggerTimeoutMillis(), payload.getTimeToLiveMillis()));
            }
            catch (AbtException e) {
                Logging.loge("Unable to set experiment as active with ABT, missing analytics?\n" + e.getMessage());
            }
        });
    }
}

