/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.model;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.firebase.inappmessaging.MessagesProto;
import com.google.firebase.inappmessaging.model.Button;

public class Action {
    @Nullable
    private final String actionUrl;
    @Nullable
    private final Button button;

    public int hashCode() {
        int urlHash = this.actionUrl != null ? this.actionUrl.hashCode() : 0;
        int buttonHash = this.button != null ? this.button.hashCode() : 0;
        return urlHash + buttonHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action a = (Action)o;
        if (this.hashCode() != a.hashCode()) {
            return false;
        }
        if (this.actionUrl == null && a.actionUrl != null || this.actionUrl != null && !this.actionUrl.equals(a.actionUrl)) {
            return false;
        }
        return this.button == null && a.button == null || this.button != null && this.button.equals(a.button);
    }

    private Action(@Nullable String actionUrl, @Nullable Button button) {
        this.actionUrl = actionUrl;
        this.button = button;
    }

    @Nullable
    public String getActionUrl() {
        return this.actionUrl;
    }

    @Nullable
    public Button getButton() {
        return this.button;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private String actionUrl;
        @Nullable
        private Button button;

        public Builder setActionUrl(@Nullable String actionUrl) {
            if (!TextUtils.isEmpty((CharSequence)actionUrl)) {
                this.actionUrl = actionUrl;
            }
            return this;
        }

        public Builder setButton(@Nullable Button button) {
            this.button = button;
            return this;
        }

        public Builder setButton(MessagesProto.Button button) {
            Button.Builder buttonBuilder = new Button.Builder();
            buttonBuilder.setButtonHexColor(button.getButtonHexColor());
            buttonBuilder.setText(button.getText());
            return this;
        }

        public Action build() {
            return new Action(this.actionUrl, this.button);
        }
    }
}

