/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import androidx.annotation.NonNull;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingClickListener;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingDismissListener;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingDisplayCallbacks;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingDisplayErrorListener;
import com.google.firebase.inappmessaging.FirebaseInAppMessagingImpressionListener;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.InAppMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DeveloperListenerManager {
    private static final int POOL_SIZE = 1;
    private static final int KEEP_ALIVE_TIME_SECONDS = 15;
    public static DeveloperListenerManager instance = new DeveloperListenerManager();
    private Map<FirebaseInAppMessagingClickListener, ClicksExecutorAndListener> registeredClickListeners = new HashMap<FirebaseInAppMessagingClickListener, ClicksExecutorAndListener>();
    private Map<FirebaseInAppMessagingDismissListener, DismissExecutorAndListener> registeredDismissListeners = new HashMap<FirebaseInAppMessagingDismissListener, DismissExecutorAndListener>();
    private Map<FirebaseInAppMessagingDisplayErrorListener, ErrorsExecutorAndListener> registeredErrorListeners = new HashMap<FirebaseInAppMessagingDisplayErrorListener, ErrorsExecutorAndListener>();
    private Map<FirebaseInAppMessagingImpressionListener, ImpressionExecutorAndListener> registeredImpressionListeners = new HashMap<FirebaseInAppMessagingImpressionListener, ImpressionExecutorAndListener>();
    private static BlockingQueue<Runnable> mCallbackQueue = new LinkedBlockingQueue<Runnable>();
    private static final ThreadPoolExecutor CALLBACK_QUEUE_EXECUTOR = new ThreadPoolExecutor(1, 1, 15L, TimeUnit.SECONDS, mCallbackQueue, new FIAMThreadFactory("EventListeners-"));

    public void impressionDetected(InAppMessage inAppMessage) {
        for (ImpressionExecutorAndListener listener : this.registeredImpressionListeners.values()) {
            listener.withExecutor(CALLBACK_QUEUE_EXECUTOR).execute(() -> listener.getListener().impressionDetected(inAppMessage));
        }
    }

    public void displayErrorEncountered(InAppMessage inAppMessage, FirebaseInAppMessagingDisplayCallbacks.InAppMessagingErrorReason errorReason) {
        for (ErrorsExecutorAndListener listener : this.registeredErrorListeners.values()) {
            listener.withExecutor(CALLBACK_QUEUE_EXECUTOR).execute(() -> listener.getListener().displayErrorEncountered(inAppMessage, errorReason));
        }
    }

    public void messageClicked(InAppMessage inAppMessage, Action action) {
        for (ClicksExecutorAndListener listener : this.registeredClickListeners.values()) {
            listener.withExecutor(CALLBACK_QUEUE_EXECUTOR).execute(() -> listener.getListener().messageClicked(inAppMessage, action));
        }
    }

    public void messageDismissed(InAppMessage inAppMessage) {
        for (DismissExecutorAndListener listener : this.registeredDismissListeners.values()) {
            listener.withExecutor(CALLBACK_QUEUE_EXECUTOR).execute(() -> listener.getListener().messageDismissed(inAppMessage));
        }
    }

    public void addImpressionListener(FirebaseInAppMessagingImpressionListener impressionListener) {
        this.registeredImpressionListeners.put(impressionListener, new ImpressionExecutorAndListener(impressionListener));
    }

    public void addClickListener(FirebaseInAppMessagingClickListener clickListener) {
        this.registeredClickListeners.put(clickListener, new ClicksExecutorAndListener(clickListener));
    }

    public void addDismissListener(FirebaseInAppMessagingDismissListener dismissListener) {
        this.registeredDismissListeners.put(dismissListener, new DismissExecutorAndListener(dismissListener));
    }

    public void addDisplayErrorListener(FirebaseInAppMessagingDisplayErrorListener displayErrorListener) {
        this.registeredErrorListeners.put(displayErrorListener, new ErrorsExecutorAndListener(displayErrorListener));
    }

    public void addImpressionListener(FirebaseInAppMessagingImpressionListener impressionListener, Executor executor) {
        this.registeredImpressionListeners.put(impressionListener, new ImpressionExecutorAndListener(impressionListener, executor));
    }

    public void addClickListener(FirebaseInAppMessagingClickListener clickListener, Executor executor) {
        this.registeredClickListeners.put(clickListener, new ClicksExecutorAndListener(clickListener, executor));
    }

    public void addDismissListener(FirebaseInAppMessagingDismissListener dismissListener, Executor executor) {
        this.registeredDismissListeners.put(dismissListener, new DismissExecutorAndListener(dismissListener, executor));
    }

    public void addDisplayErrorListener(FirebaseInAppMessagingDisplayErrorListener displayErrorListener, Executor executor) {
        this.registeredErrorListeners.put(displayErrorListener, new ErrorsExecutorAndListener(displayErrorListener, executor));
    }

    public void removeImpressionListener(FirebaseInAppMessagingImpressionListener impressionListener) {
        this.registeredImpressionListeners.remove(impressionListener);
    }

    public void removeClickListener(FirebaseInAppMessagingClickListener clickListener) {
        this.registeredClickListeners.remove(clickListener);
    }

    public void removeDisplayErrorListener(FirebaseInAppMessagingDisplayErrorListener displayErrorListener) {
        this.registeredErrorListeners.remove(displayErrorListener);
    }

    public void removeAllListeners() {
        this.registeredClickListeners.clear();
        this.registeredImpressionListeners.clear();
        this.registeredErrorListeners.clear();
    }

    static {
        CALLBACK_QUEUE_EXECUTOR.allowCoreThreadTimeOut(true);
    }

    private static class ErrorsExecutorAndListener
    extends ExecutorAndListener<FirebaseInAppMessagingDisplayErrorListener> {
        FirebaseInAppMessagingDisplayErrorListener listener;

        public ErrorsExecutorAndListener(FirebaseInAppMessagingDisplayErrorListener listener, Executor e) {
            super(e);
            this.listener = listener;
        }

        public ErrorsExecutorAndListener(FirebaseInAppMessagingDisplayErrorListener listener) {
            super(null);
            this.listener = listener;
        }

        @Override
        public FirebaseInAppMessagingDisplayErrorListener getListener() {
            return this.listener;
        }
    }

    private static class DismissExecutorAndListener
    extends ExecutorAndListener<FirebaseInAppMessagingDismissListener> {
        FirebaseInAppMessagingDismissListener listener;

        public DismissExecutorAndListener(FirebaseInAppMessagingDismissListener listener, Executor e) {
            super(e);
            this.listener = listener;
        }

        public DismissExecutorAndListener(FirebaseInAppMessagingDismissListener listener) {
            super(null);
            this.listener = listener;
        }

        @Override
        public FirebaseInAppMessagingDismissListener getListener() {
            return this.listener;
        }
    }

    private static class ClicksExecutorAndListener
    extends ExecutorAndListener<FirebaseInAppMessagingClickListener> {
        FirebaseInAppMessagingClickListener listener;

        public ClicksExecutorAndListener(FirebaseInAppMessagingClickListener listener, Executor e) {
            super(e);
            this.listener = listener;
        }

        public ClicksExecutorAndListener(FirebaseInAppMessagingClickListener listener) {
            super(null);
            this.listener = listener;
        }

        @Override
        public FirebaseInAppMessagingClickListener getListener() {
            return this.listener;
        }
    }

    private static class ImpressionExecutorAndListener
    extends ExecutorAndListener<FirebaseInAppMessagingImpressionListener> {
        FirebaseInAppMessagingImpressionListener listener;

        public ImpressionExecutorAndListener(FirebaseInAppMessagingImpressionListener listener, Executor e) {
            super(e);
            this.listener = listener;
        }

        public ImpressionExecutorAndListener(FirebaseInAppMessagingImpressionListener listener) {
            super(null);
            this.listener = listener;
        }

        @Override
        public FirebaseInAppMessagingImpressionListener getListener() {
            return this.listener;
        }
    }

    private static abstract class ExecutorAndListener<T> {
        private final Executor executor;

        public abstract T getListener();

        public Executor withExecutor(Executor defaultExecutor) {
            if (this.executor == null) {
                return defaultExecutor;
            }
            return this.executor;
        }

        public ExecutorAndListener(Executor e) {
            this.executor = e;
        }
    }

    static class FIAMThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String mNameSuffix;

        FIAMThreadFactory(@NonNull String suffix) {
            this.mNameSuffix = suffix;
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread t = new Thread(r, "FIAM-" + this.mNameSuffix + this.threadNumber.getAndIncrement());
            t.setDaemon(false);
            t.setPriority(9);
            return t;
        }
    }
}

