/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal.layout.util;

import android.view.View;
import android.widget.ScrollView;
import com.google.firebase.inappmessaging.display.internal.layout.util.MeasureUtils;

public class ViewMeasure {
    private View view;
    private boolean flex;
    private int maxWidth;
    private int maxHeight;

    public ViewMeasure(View view, boolean flex) {
        this.view = view;
        this.flex = flex;
    }

    public void preMeasure(int w, int h) {
        MeasureUtils.measureAtMost(this.view, w, h);
    }

    public View getView() {
        return this.view;
    }

    public boolean isFlex() {
        return this.flex;
    }

    public int getDesiredHeight() {
        if (this.view.getVisibility() == 8) {
            return 0;
        }
        if (this.view instanceof ScrollView) {
            ScrollView sv = (ScrollView)this.view;
            return sv.getPaddingBottom() + sv.getPaddingTop() + sv.getChildAt(0).getMeasuredHeight();
        }
        return this.view.getMeasuredHeight();
    }

    public int getDesiredWidth() {
        if (this.view.getVisibility() == 8) {
            return 0;
        }
        return this.view.getMeasuredHeight();
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxDimens(int w, int h) {
        this.maxWidth = w;
        this.maxHeight = h;
    }
}

