/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal.layout;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.google.firebase.inappmessaging.display.R;
import com.google.firebase.inappmessaging.display.internal.Logging;
import com.google.firebase.inappmessaging.display.internal.layout.BaseModalLayout;
import com.google.firebase.inappmessaging.display.internal.layout.util.MeasureUtils;
import com.google.firebase.inappmessaging.display.internal.layout.util.VerticalViewGroupMeasure;
import com.google.firebase.inappmessaging.display.internal.layout.util.ViewMeasure;

public class ModalLayoutPortrait
extends BaseModalLayout {
    private static final int ITEM_SPACING_DP = 24;
    private VerticalViewGroupMeasure vgm = new VerticalViewGroupMeasure();
    private int vertItemSpacing;

    public ModalLayoutPortrait(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.vertItemSpacing = this.dpToPixels(24);
        int horizPadding = this.getPaddingRight() + this.getPaddingLeft();
        int vertPadding = this.getPaddingBottom() + this.getPaddingTop();
        int baseLayoutWidth = this.calculateBaseWidth(widthMeasureSpec);
        int baseLayoutHeight = this.calculateBaseHeight(heightMeasureSpec);
        int totalVerticalSpacing = (this.getVisibleChildren().size() - 1) * this.vertItemSpacing;
        int reservedHeight = vertPadding + totalVerticalSpacing;
        this.vgm.reset(baseLayoutWidth, baseLayoutHeight);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            this.vgm.add(child, this.isFlex(child));
        }
        Logging.logd("Screen dimens: " + this.getDisplayMetrics());
        Logging.logdPair("Max pct", this.getMaxWidthPct(), this.getMaxHeightPct());
        Logging.logdPair("Base dimens", baseLayoutWidth, baseLayoutHeight);
        int totalDesiredHeight = reservedHeight;
        for (ViewMeasure vm : this.vgm.getViews()) {
            Logging.logd("Pre-measure child");
            vm.preMeasure(baseLayoutWidth, baseLayoutHeight);
        }
        Logging.logdNumber("Total reserved height", reservedHeight);
        Logging.logdNumber("Total desired height", totalDesiredHeight += this.vgm.getTotalHeight());
        boolean isHeightConstrained = totalDesiredHeight > baseLayoutHeight;
        Logging.logd("Total height constrained: " + isHeightConstrained);
        if (isHeightConstrained) {
            int vertSpaceAvail = baseLayoutHeight - reservedHeight;
            int flexAvail = vertSpaceAvail - this.vgm.getTotalFixedHeight();
            this.vgm.allocateSpace(flexAvail);
        }
        int heightUsed = reservedHeight;
        int maxChildWidth = baseLayoutWidth - horizPadding;
        for (ViewMeasure vm : this.vgm.getViews()) {
            Logging.logd("Measuring child");
            MeasureUtils.measureAtMost(vm.getView(), maxChildWidth, vm.getMaxHeight());
            heightUsed += this.getDesiredHeight(vm.getView());
        }
        Logging.logdPair("Measured dims", baseLayoutWidth, heightUsed);
        this.setMeasuredDimension(baseLayoutWidth, heightUsed);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int y = this.getPaddingTop();
        int x = this.getPaddingLeft();
        int numVisible = this.getVisibleChildren().size();
        for (int i = 0; i < numVisible; ++i) {
            int childRight;
            int childLeft;
            View child = this.getVisibleChildren().get(i);
            FrameLayout.LayoutParams layoutParams = this.getLayoutParams(child);
            int childHeight = child.getMeasuredHeight();
            int childWidth = child.getMeasuredWidth();
            int childTop = y;
            int childBottom = y + childHeight;
            if ((layoutParams.gravity & 1) == 1) {
                int centerOffset = (right - left) / 2;
                int halfWidth = childWidth / 2;
                childLeft = centerOffset - halfWidth;
                childRight = centerOffset + halfWidth;
            } else {
                childLeft = x;
                childRight = x + childWidth;
            }
            Logging.logd("Layout child " + i);
            Logging.logdPair("\t(top, bottom)", childTop, childBottom);
            Logging.logdPair("\t(left, right)", childLeft, childRight);
            child.layout(childLeft, childTop, childRight, childBottom);
            y += child.getMeasuredHeight();
            if (i >= numVisible - 1) continue;
            y += this.vertItemSpacing;
        }
    }

    private boolean isFlex(View child) {
        return child.getId() == R.id.body_scroll || child.getId() == R.id.image_view;
    }
}

