/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal.layout;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.firebase.inappmessaging.display.R;
import com.google.firebase.inappmessaging.display.internal.Logging;
import com.google.firebase.inappmessaging.display.internal.layout.BaseModalLayout;
import com.google.firebase.inappmessaging.display.internal.layout.util.MeasureUtils;
import java.util.Arrays;
import java.util.List;

public class ModalLayoutLandscape
extends BaseModalLayout {
    private static final int ITEM_SPACING_DP = 24;
    private static final float MAX_IMG_WIDTH_PCT = 0.4f;
    private View imageChild;
    private View titleChild;
    private View scrollChild;
    private View buttonChild;
    private int barrierWidth;
    private int vertItemSpacing;
    private int leftContentHeight;
    private int rightContentHeight;

    public ModalLayoutLandscape(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.imageChild = this.findChildById(R.id.image_view);
        this.titleChild = this.findChildById(R.id.message_title);
        this.scrollChild = this.findChildById(R.id.body_scroll);
        this.buttonChild = this.findChildById(R.id.button);
        this.barrierWidth = this.imageChild.getVisibility() == 8 ? 0 : this.dpToPixels(24);
        this.vertItemSpacing = this.dpToPixels(24);
        List<View> rightCol = Arrays.asList(this.titleChild, this.scrollChild, this.buttonChild);
        int horizPadding = this.getPaddingLeft() + this.getPaddingRight();
        int vertPadding = this.getPaddingBottom() + this.getPaddingTop();
        int baseLayoutWidth = this.calculateBaseWidth(widthMeasureSpec);
        int baseLayoutHeight = this.calculateBaseHeight(heightMeasureSpec);
        int innerHeight = baseLayoutHeight - vertPadding;
        int innerWidth = baseLayoutWidth - horizPadding;
        Logging.logd("Measuring image");
        MeasureUtils.measureAtMost(this.imageChild, (int)((float)innerWidth * 0.4f), innerHeight);
        int leftColumnWidth = this.getDesiredWidth(this.imageChild);
        int rightColumnMaxWidth = innerWidth - (leftColumnWidth + this.barrierWidth);
        Logging.logdPair("Max col widths (l, r)", leftColumnWidth, rightColumnMaxWidth);
        int rightVisible = 0;
        for (View view : rightCol) {
            if (view.getVisibility() == 8) continue;
            ++rightVisible;
        }
        int rightSpacingTotal = Math.max(0, (rightVisible - 1) * this.vertItemSpacing);
        int rightHeightAvail = innerHeight - rightSpacingTotal;
        Logging.logd("Measuring getTitle");
        MeasureUtils.measureAtMost(this.titleChild, rightColumnMaxWidth, rightHeightAvail);
        Logging.logd("Measuring button");
        MeasureUtils.measureAtMost(this.buttonChild, rightColumnMaxWidth, rightHeightAvail);
        Logging.logd("Measuring scroll view");
        int scrollHeight = rightHeightAvail - this.getDesiredHeight(this.titleChild) - this.getDesiredHeight(this.buttonChild);
        MeasureUtils.measureAtMost(this.scrollChild, rightColumnMaxWidth, scrollHeight);
        this.leftContentHeight = this.getDesiredHeight(this.imageChild);
        this.rightContentHeight = rightSpacingTotal;
        for (View view : rightCol) {
            this.rightContentHeight += this.getDesiredHeight(view);
        }
        int leftHeight = this.leftContentHeight + vertPadding;
        int rightHeight = this.rightContentHeight + vertPadding;
        int totalHeight = Math.max(leftHeight, rightHeight);
        int rightColumnWidth = 0;
        for (View view : rightCol) {
            rightColumnWidth = Math.max(this.getDesiredWidth(view), rightColumnWidth);
        }
        Logging.logdPair("Measured columns (l, r)", leftColumnWidth, rightColumnWidth);
        int totalWidth = leftColumnWidth + rightColumnWidth + this.barrierWidth + horizPadding;
        Logging.logdPair("Measured dims", totalWidth, totalHeight);
        this.setMeasuredDimension(totalWidth, totalHeight);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int childrenLeft = this.getPaddingLeft();
        int childrenTop = this.getPaddingTop();
        int childrenRight = this.getMeasuredWidth() - this.getPaddingRight();
        int leftTopOffset = 0;
        int rightTopOffset = 0;
        if (this.leftContentHeight < this.rightContentHeight) {
            leftTopOffset = (this.rightContentHeight - this.leftContentHeight) / 2;
        } else {
            rightTopOffset = (this.leftContentHeight - this.rightContentHeight) / 2;
        }
        Logging.logd("Layout image");
        int imageLeft = childrenLeft;
        int imageTop = childrenTop + leftTopOffset;
        int imageRight = imageLeft + this.getDesiredWidth(this.imageChild);
        int imageBottom = imageTop + this.getDesiredHeight(this.imageChild);
        this.layoutChild(this.imageChild, imageLeft, imageTop, imageRight, imageBottom);
        int rightColLeft = imageRight + this.barrierWidth;
        Logging.logd("Layout getTitle");
        int titleLeft = rightColLeft;
        int titleTop = childrenTop + rightTopOffset;
        int titleRight = childrenRight;
        int titleBottom = titleTop + this.getDesiredHeight(this.titleChild);
        this.layoutChild(this.titleChild, titleLeft, titleTop, titleRight, titleBottom);
        Logging.logd("Layout getBody");
        int scrollMarginTop = this.titleChild.getVisibility() == 8 ? 0 : this.vertItemSpacing;
        int scrollLeft = rightColLeft;
        int scrollTop = titleBottom + scrollMarginTop;
        int scrollBottom = scrollTop + this.getDesiredHeight(this.scrollChild);
        int scrollRight = childrenRight;
        this.layoutChild(this.scrollChild, scrollLeft, scrollTop, scrollRight, scrollBottom);
        Logging.logd("Layout button");
        int buttonMarginTop = this.scrollChild.getVisibility() == 8 ? 0 : this.vertItemSpacing;
        int buttonLeft = rightColLeft;
        int buttonTop = scrollBottom + buttonMarginTop;
        this.layoutChild(this.buttonChild, buttonLeft, buttonTop);
    }

    protected void layoutCenterHorizontal(View child, int left, int top, int right, int bottom) {
        int centerOffset = (right - left) / 2;
        int halfWidth = child.getMeasuredWidth() / 2;
        int childLeft = left + centerOffset - halfWidth;
        int childRight = left + centerOffset + halfWidth;
        this.layoutChild(child, childLeft, top, childRight, bottom);
    }
}

