/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal.bindingwrappers;

import android.graphics.Color;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.inappmessaging.display.R;
import com.google.firebase.inappmessaging.display.internal.InAppMessageLayoutConfig;
import com.google.firebase.inappmessaging.display.internal.bindingwrappers.BindingWrapper;
import com.google.firebase.inappmessaging.display.internal.injection.scopes.InAppMessageScope;
import com.google.firebase.inappmessaging.display.internal.layout.FiamRelativeLayout;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.InAppMessage;
import com.google.firebase.inappmessaging.model.MessageType;
import com.google.firebase.inappmessaging.model.ModalMessage;
import java.util.Map;
import javax.inject.Inject;

@InAppMessageScope
public class ModalBindingWrapper
extends BindingWrapper {
    private FiamRelativeLayout modalRoot;
    private ViewGroup modalContentRoot;
    private ScrollView bodyScroll;
    private Button button;
    private View collapseImage;
    private ImageView imageView;
    private TextView messageBody;
    private TextView messageTitle;
    private ModalMessage modalMessage;
    private ViewTreeObserver.OnGlobalLayoutListener layoutListener = new ScrollViewAdjustableListener();

    @Inject
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public ModalBindingWrapper(InAppMessageLayoutConfig config, LayoutInflater inflater, InAppMessage message) {
        super(config, inflater, message);
    }

    @Override
    @NonNull
    public ViewTreeObserver.OnGlobalLayoutListener inflate(Map<Action, View.OnClickListener> actionListeners, View.OnClickListener dismissOnClickListener) {
        View root = this.inflater.inflate(R.layout.modal, null);
        this.bodyScroll = (ScrollView)root.findViewById(R.id.body_scroll);
        this.button = (Button)root.findViewById(R.id.button);
        this.collapseImage = root.findViewById(R.id.collapse_button);
        this.imageView = (ImageView)root.findViewById(R.id.image_view);
        this.messageBody = (TextView)root.findViewById(R.id.message_body);
        this.messageTitle = (TextView)root.findViewById(R.id.message_title);
        this.modalRoot = (FiamRelativeLayout)root.findViewById(R.id.modal_root);
        this.modalContentRoot = (ViewGroup)root.findViewById(R.id.modal_content_root);
        if (this.message.getMessageType().equals((Object)MessageType.MODAL)) {
            this.modalMessage = (ModalMessage)this.message;
            this.setMessage(this.modalMessage);
            this.setButton(actionListeners);
            this.setLayoutConfig(this.config);
            this.setDismissListener(dismissOnClickListener);
            this.setViewBgColorFromHex((View)this.modalContentRoot, this.modalMessage.getBackgroundHexColor());
        }
        return this.layoutListener;
    }

    @Override
    @NonNull
    public ImageView getImageView() {
        return this.imageView;
    }

    @Override
    @NonNull
    public ViewGroup getRootView() {
        return this.modalRoot;
    }

    @Override
    @NonNull
    public View getDialogView() {
        return this.modalContentRoot;
    }

    @NonNull
    public View getScrollView() {
        return this.bodyScroll;
    }

    @NonNull
    public View getTitleView() {
        return this.messageTitle;
    }

    @Override
    @NonNull
    public InAppMessageLayoutConfig getConfig() {
        return this.config;
    }

    @NonNull
    public Button getActionButton() {
        return this.button;
    }

    @NonNull
    public View getCollapseButton() {
        return this.collapseImage;
    }

    private void setMessage(ModalMessage message) {
        if (message.getImageData() == null || TextUtils.isEmpty((CharSequence)message.getImageData().getImageUrl())) {
            this.imageView.setVisibility(8);
        } else {
            this.imageView.setVisibility(0);
        }
        if (message.getTitle() != null) {
            if (!TextUtils.isEmpty((CharSequence)message.getTitle().getText())) {
                this.messageTitle.setVisibility(0);
                this.messageTitle.setText((CharSequence)message.getTitle().getText());
            } else {
                this.messageTitle.setVisibility(8);
            }
            if (!TextUtils.isEmpty((CharSequence)message.getTitle().getHexColor())) {
                this.messageTitle.setTextColor(Color.parseColor((String)message.getTitle().getHexColor()));
            }
        }
        if (message.getBody() != null && !TextUtils.isEmpty((CharSequence)message.getBody().getText())) {
            this.bodyScroll.setVisibility(0);
            this.messageBody.setVisibility(0);
            this.messageBody.setTextColor(Color.parseColor((String)message.getBody().getHexColor()));
            this.messageBody.setText((CharSequence)message.getBody().getText());
        } else {
            this.bodyScroll.setVisibility(8);
            this.messageBody.setVisibility(8);
        }
    }

    private void setButton(Map<Action, View.OnClickListener> actionListeners) {
        Action modalAction = this.modalMessage.getAction();
        if (modalAction != null && modalAction.getButton() != null && !TextUtils.isEmpty((CharSequence)modalAction.getButton().getText().getText())) {
            ModalBindingWrapper.setupViewButtonFromModel(this.button, modalAction.getButton());
            this.setButtonActionListener(this.button, actionListeners.get(this.modalMessage.getAction()));
            this.button.setVisibility(0);
        } else {
            this.button.setVisibility(8);
        }
    }

    private void setLayoutConfig(InAppMessageLayoutConfig config) {
        this.imageView.setMaxHeight(config.getMaxImageHeight());
        this.imageView.setMaxWidth(config.getMaxImageWidth());
    }

    private void setDismissListener(View.OnClickListener dismissListener) {
        this.collapseImage.setOnClickListener(dismissListener);
        this.modalRoot.setDismissListener(dismissListener);
    }

    @VisibleForTesting
    public void setLayoutListener(ViewTreeObserver.OnGlobalLayoutListener listener) {
        this.layoutListener = listener;
    }

    public class ScrollViewAdjustableListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        public void onGlobalLayout() {
            ModalBindingWrapper.this.imageView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }
}

