/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal.bindingwrappers;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import com.google.firebase.inappmessaging.display.internal.InAppMessageLayoutConfig;
import com.google.firebase.inappmessaging.display.internal.Logging;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.InAppMessage;
import java.util.Map;

public abstract class BindingWrapper {
    protected final InAppMessage message;
    final InAppMessageLayoutConfig config;
    final LayoutInflater inflater;

    protected BindingWrapper(InAppMessageLayoutConfig config, LayoutInflater inflater, InAppMessage message) {
        this.config = config;
        this.inflater = inflater;
        this.message = message;
    }

    @NonNull
    public abstract ImageView getImageView();

    @NonNull
    public abstract ViewGroup getRootView();

    @NonNull
    public abstract View getDialogView();

    @Nullable
    public abstract ViewTreeObserver.OnGlobalLayoutListener inflate(Map<Action, View.OnClickListener> var1, View.OnClickListener var2);

    public boolean canSwipeToDismiss() {
        return false;
    }

    @Nullable
    public View.OnClickListener getDismissListener() {
        return null;
    }

    @NonNull
    public InAppMessageLayoutConfig getConfig() {
        return this.config;
    }

    protected void setViewBgColorFromHex(@Nullable View view, @Nullable String hexColor) {
        if (view == null || TextUtils.isEmpty((CharSequence)hexColor)) {
            return;
        }
        try {
            view.setBackgroundColor(Color.parseColor((String)hexColor));
        }
        catch (IllegalArgumentException e) {
            Logging.loge("Error parsing background color: " + e.toString() + " color: " + hexColor);
        }
    }

    public static void setButtonBgColorFromHex(Button button, String hexColor) {
        try {
            Drawable drawable2 = button.getBackground();
            Drawable compatDrawable = DrawableCompat.wrap((Drawable)drawable2);
            DrawableCompat.setTint((Drawable)compatDrawable, (int)Color.parseColor((String)hexColor));
            button.setBackground(compatDrawable);
        }
        catch (IllegalArgumentException e) {
            Logging.loge("Error parsing background color: " + e.toString());
        }
    }

    public static void setupViewButtonFromModel(Button viewButton, com.google.firebase.inappmessaging.model.Button modelButton) {
        String buttonTextHexColor = modelButton.getText().getHexColor();
        BindingWrapper.setButtonBgColorFromHex(viewButton, modelButton.getButtonHexColor());
        viewButton.setText((CharSequence)modelButton.getText().getText());
        viewButton.setTextColor(Color.parseColor((String)buttonTextHexColor));
    }

    protected void setButtonActionListener(@Nullable Button button, View.OnClickListener actionListener) {
        if (button != null) {
            button.setOnClickListener(actionListener);
        }
    }
}

