/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;
import com.google.firebase.inappmessaging.display.internal.Logging;

public class ResizableImageView
extends AppCompatImageView {
    private int mDensityDpi;

    public ResizableImageView(Context context) {
        super(context);
        this.init(context);
    }

    public ResizableImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ResizableImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(@NonNull Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mDensityDpi = (int)(displayMetrics.density * 160.0f);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (Build.VERSION.SDK_INT > 16) {
            Drawable d = this.getDrawable();
            boolean adjustViewBounds = this.getAdjustViewBounds();
            if (d != null && adjustViewBounds) {
                this.scalePxToDp(d);
                this.checkMinDim();
            }
        }
    }

    private void checkMinDim() {
        float scale;
        int minWidth = Math.max(this.getMinimumWidth(), this.getSuggestedMinimumWidth());
        int minHeight = Math.max(this.getMinimumHeight(), this.getSuggestedMinimumHeight());
        int widthSpec = this.getMeasuredWidth();
        int heightSpec = this.getMeasuredHeight();
        Logging.logdPair("Image: min width, height", minWidth, minHeight);
        Logging.logdPair("Image: actual width, height", widthSpec, heightSpec);
        float scaleW = 1.0f;
        float scaleH = 1.0f;
        if (widthSpec < minWidth) {
            scaleW = (float)minWidth / (float)widthSpec;
        }
        if (heightSpec < minHeight) {
            scaleH = (float)minHeight / (float)heightSpec;
        }
        float f = scale = scaleW > scaleH ? scaleW : scaleH;
        if ((double)scale > 1.0) {
            int targetW = (int)Math.ceil((float)widthSpec * scale);
            int targetH = (int)Math.ceil((float)heightSpec * scale);
            Logging.logd("Measured dimension (" + widthSpec + "x" + heightSpec + ") too small.  Resizing to " + targetW + "x" + targetH);
            Dimensions t = this.bound(targetW, targetH);
            this.setMeasuredDimension(t.w, t.h);
        }
    }

    private void scalePxToDp(Drawable d) {
        int widthSpec = d.getIntrinsicWidth();
        int heightSpec = d.getIntrinsicHeight();
        Logging.logdPair("Image: intrinsic width, height", widthSpec, heightSpec);
        int targetW = (int)Math.ceil(widthSpec * this.mDensityDpi / 160);
        int targetH = (int)Math.ceil(heightSpec * this.mDensityDpi / 160);
        Dimensions t = this.bound(targetW, targetH);
        Logging.logdPair("Image: new target dimensions", t.w, t.h);
        this.setMeasuredDimension(t.w, t.h);
    }

    private Dimensions bound(int targetW, int targetH) {
        int maxWidth = this.getMaxWidth();
        int maxHeight = this.getMaxHeight();
        if (targetW > maxWidth) {
            Logging.logdNumber("Image: capping width", maxWidth);
            targetH = targetH * maxWidth / targetW;
            targetW = maxWidth;
        }
        if (targetH > maxHeight) {
            Logging.logdNumber("Image: capping height", maxHeight);
            targetW = targetW * maxHeight / targetH;
            targetH = maxHeight;
        }
        return new Dimensions(targetW, targetH);
    }

    private static class Dimensions {
        final int w;
        final int h;

        private Dimensions(int w, int h) {
            this.w = w;
            this.h = h;
        }
    }
}

