/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal;

import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.Headers;
import com.bumptech.glide.load.model.LazyHeaders;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.google.firebase.inappmessaging.display.internal.Logging;
import com.google.firebase.inappmessaging.display.internal.injection.scopes.FirebaseAppScope;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

@FirebaseAppScope
public class FiamImageLoader {
    private final RequestManager requestManager;
    private final Map<String, Set<CustomTarget>> tags = new HashMap<String, Set<CustomTarget>>();

    @Inject
    public FiamImageLoader(RequestManager requestManager) {
        this.requestManager = requestManager;
    }

    public FiamImageRequestCreator load(@Nullable String imageUrl) {
        Logging.logd("Starting Downloading Image : " + imageUrl);
        GlideUrl glideUrl = new GlideUrl(imageUrl, (Headers)new LazyHeaders.Builder().addHeader("Accept", "image/*").build());
        RequestBuilder requestBuilder = (RequestBuilder)this.requestManager.load((Object)glideUrl).format(DecodeFormat.PREFER_ARGB_8888);
        return new FiamImageRequestCreator((RequestBuilder<Drawable>)requestBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTag(Class c) {
        String tag;
        String string = tag = c.getSimpleName();
        synchronized (string) {
            if (this.tags.containsKey(tag)) {
                Set<CustomTarget> targets = this.tags.get(tag);
                for (CustomTarget target : targets) {
                    if (target == null) continue;
                    this.requestManager.clear((Target)target);
                }
            }
        }
    }

    @VisibleForTesting
    boolean containsTag(String tag) {
        return this.tags != null && this.tags.containsKey(tag) && this.tags.get(tag) != null && this.tags.get(tag).size() > 0;
    }

    public static abstract class Callback
    extends CustomTarget<Drawable> {
        private ImageView imageView;

        public void onLoadFailed(@Nullable Drawable errorDrawable) {
            Logging.logd("Downloading Image Failed");
            this.setImage(errorDrawable);
            this.onError(new Exception("Image loading failed!"));
        }

        private void setImage(Drawable drawable2) {
            if (this.imageView != null) {
                this.imageView.setImageDrawable(drawable2);
            }
        }

        public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
            Logging.logd("Downloading Image Success!!!");
            this.setImage(resource);
            this.onSuccess();
        }

        public void onLoadCleared(@Nullable Drawable placeholder) {
            Logging.logd("Downloading Image Cleared");
            this.setImage(placeholder);
            this.onSuccess();
        }

        public abstract void onSuccess();

        public abstract void onError(Exception var1);

        void setImageView(ImageView imageView) {
            this.imageView = imageView;
        }
    }

    public class FiamImageRequestCreator {
        private final RequestBuilder<Drawable> requestBuilder;
        private Callback target;
        private String tag;

        public FiamImageRequestCreator(RequestBuilder<Drawable> requestBuilder) {
            this.requestBuilder = requestBuilder;
        }

        public FiamImageRequestCreator placeholder(int placeholderResId) {
            this.requestBuilder.placeholder(placeholderResId);
            Logging.logd("Downloading Image Placeholder : " + placeholderResId);
            return this;
        }

        public FiamImageRequestCreator tag(Class c) {
            this.tag = c.getSimpleName();
            this.checkAndTag();
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkAndTag() {
            if (this.target == null || TextUtils.isEmpty((CharSequence)this.tag)) {
                return;
            }
            Map map = FiamImageLoader.this.tags;
            synchronized (map) {
                Set<Callback> set;
                if (FiamImageLoader.this.tags.containsKey(this.tag)) {
                    set = (Set)FiamImageLoader.this.tags.get(this.tag);
                } else {
                    set = new HashSet();
                    FiamImageLoader.this.tags.put(this.tag, set);
                }
                if (!set.contains((Object)this.target)) {
                    set.add(this.target);
                }
            }
        }

        public void into(ImageView imageView, Callback callback) {
            Logging.logd("Downloading Image Callback : " + (Object)((Object)callback));
            callback.setImageView(imageView);
            this.requestBuilder.into((Target)callback);
            this.target = callback;
            this.checkAndTag();
        }
    }
}

