/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Application;
import android.graphics.Point;
import android.view.View;
import com.google.firebase.inappmessaging.display.internal.injection.scopes.FirebaseAppScope;
import javax.inject.Inject;

@FirebaseAppScope
public class FiamAnimator {
    @Inject
    FiamAnimator() {
    }

    public void slideIntoView(final Application app, final View view, Position startPosition) {
        view.setAlpha(0.0f);
        Point start = Position.getPoint(startPosition, view);
        view.animate().translationX((float)start.x).translationY((float)start.y).setDuration(1L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                view.animate().translationX(0.0f).translationY(0.0f).alpha(1.0f).setDuration((long)app.getResources().getInteger(17694722)).setListener(null);
            }
        });
    }

    public void slideOutOfView(Application app, View view, Position end, final AnimationCompleteListener completeListener) {
        Point start = Position.getPoint(end, view);
        AnimatorListenerAdapter animatorListenerAdapter = new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                completeListener.onComplete();
            }
        };
        view.animate().translationX((float)start.x).translationY((float)start.y).setDuration((long)app.getResources().getInteger(17694722)).setListener((Animator.AnimatorListener)animatorListenerAdapter);
    }

    public static interface AnimationCompleteListener {
        public void onComplete();
    }

    public static enum Position {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;


        private static Point getPoint(Position d, View view) {
            view.measure(-2, -2);
            switch (d) {
                case LEFT: {
                    return new Point(-1 * view.getMeasuredWidth(), 0);
                }
                case RIGHT: {
                    return new Point(1 * view.getMeasuredWidth(), 0);
                }
                case TOP: {
                    return new Point(0, -1 * view.getMeasuredHeight());
                }
                case BOTTOM: {
                    return new Point(0, 1 * view.getMeasuredHeight());
                }
            }
            return new Point(0, -1 * view.getMeasuredHeight());
        }
    }
}

