/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.Bound;
import com.google.firebase.firestore.core.CompositeFilter;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.index.DirectionalIndexByteEncoder;
import com.google.firebase.firestore.index.FirestoreIndexValueWriter;
import com.google.firebase.firestore.index.IndexByteEncoder;
import com.google.firebase.firestore.index.IndexEntry;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.MemoryIndexManager;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.TargetIndexMatcher;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.LogicUtils;
import com.google.firebase.firestore.util.Util;
import com.google.firestore.admin.v1.Index;
import com.google.firestore.v1.Value;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;

final class SQLiteIndexManager
implements IndexManager {
    private static final String TAG = SQLiteIndexManager.class.getSimpleName();
    private static final byte[] EMPTY_BYTES_VALUE = new byte[0];
    private final SQLitePersistence db;
    private final LocalSerializer serializer;
    private final String uid;
    private final Map<Target, List<Target>> targetToDnfSubTargets = new HashMap<Target, List<Target>>();
    private final MemoryIndexManager.MemoryCollectionParentIndex collectionParentsCache = new MemoryIndexManager.MemoryCollectionParentIndex();
    private final Map<String, Map<Integer, FieldIndex>> memoizedIndexes = new HashMap<String, Map<Integer, FieldIndex>>();
    private final Queue<FieldIndex> nextIndexToUpdate = new PriorityQueue<FieldIndex>(10, (l, r) -> {
        int sequenceCmp = Long.compare(l.getIndexState().getSequenceNumber(), r.getIndexState().getSequenceNumber());
        if (sequenceCmp == 0) {
            return l.getCollectionGroup().compareTo(r.getCollectionGroup());
        }
        return sequenceCmp;
    });
    private boolean started = false;
    private int memoizedMaxIndexId = -1;
    private long memoizedMaxSequenceNumber = -1L;

    SQLiteIndexManager(SQLitePersistence persistence, LocalSerializer serializer, User user) {
        this.db = persistence;
        this.serializer = serializer;
        this.uid = user.isAuthenticated() ? user.getUid() : "";
    }

    @Override
    public void start() {
        HashMap indexStates = new HashMap();
        this.db.query("SELECT index_id, sequence_number, read_time_seconds, read_time_nanos, document_key, largest_batch_id FROM index_state WHERE uid = ?").binding(this.uid).forEach(row -> {
            int indexId = row.getInt(0);
            long sequenceNumber = row.getLong(1);
            SnapshotVersion readTime = new SnapshotVersion(new Timestamp(row.getLong(2), row.getInt(3)));
            DocumentKey documentKey = DocumentKey.fromPath(EncodedPath.decodeResourcePath(row.getString(4)));
            int largestBatchId = row.getInt(5);
            indexStates.put(indexId, FieldIndex.IndexState.create(sequenceNumber, readTime, documentKey, largestBatchId));
        });
        this.db.query("SELECT index_id, collection_group, index_proto FROM index_configuration").forEach(row -> {
            try {
                int indexId = row.getInt(0);
                String collectionGroup = row.getString(1);
                List<FieldIndex.Segment> segments = this.serializer.decodeFieldIndexSegments(Index.parseFrom(row.getBlob(2)));
                FieldIndex.IndexState indexState = indexStates.containsKey(indexId) ? (FieldIndex.IndexState)indexStates.get(indexId) : FieldIndex.INITIAL_STATE;
                FieldIndex fieldIndex = FieldIndex.create(indexId, collectionGroup, segments, indexState);
                this.memoizeIndex(fieldIndex);
            }
            catch (InvalidProtocolBufferException e) {
                throw Assert.fail("Failed to decode index: " + (Object)((Object)e), new Object[0]);
            }
        });
        this.started = true;
    }

    @Override
    public void addToCollectionParentIndex(ResourcePath collectionPath) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        Assert.hardAssert(collectionPath.length() % 2 == 1, "Expected a collection path.", new Object[0]);
        if (this.collectionParentsCache.add(collectionPath)) {
            String collectionId = collectionPath.getLastSegment();
            ResourcePath parentPath = (ResourcePath)collectionPath.popLast();
            this.db.execute("INSERT OR REPLACE INTO collection_parents (collection_id, parent) VALUES (?, ?)", collectionId, EncodedPath.encode(parentPath));
        }
    }

    @Override
    public List<ResourcePath> getCollectionParents(String collectionId) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        ArrayList<ResourcePath> parentPaths = new ArrayList<ResourcePath>();
        this.db.query("SELECT parent FROM collection_parents WHERE collection_id = ?").binding(collectionId).forEach(row -> parentPaths.add(EncodedPath.decodeResourcePath(row.getString(0))));
        return parentPaths;
    }

    @Override
    public void addFieldIndex(FieldIndex index) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        int nextIndexId = this.memoizedMaxIndexId + 1;
        index = FieldIndex.create(nextIndexId, index.getCollectionGroup(), index.getSegments(), index.getIndexState());
        this.db.execute("INSERT INTO index_configuration (index_id, collection_group, index_proto) VALUES(?, ?, ?)", nextIndexId, index.getCollectionGroup(), this.encodeSegments(index));
        this.memoizeIndex(index);
    }

    @Override
    public void deleteFieldIndex(FieldIndex index) {
        this.db.execute("DELETE FROM index_configuration WHERE index_id = ?", index.getIndexId());
        this.db.execute("DELETE FROM index_entries WHERE index_id = ?", index.getIndexId());
        this.db.execute("DELETE FROM index_state WHERE index_id = ?", index.getIndexId());
        this.nextIndexToUpdate.remove(index);
        Map<Integer, FieldIndex> collectionIndices = this.memoizedIndexes.get(index.getCollectionGroup());
        if (collectionIndices != null) {
            collectionIndices.remove(index.getIndexId());
        }
    }

    @Override
    public void deleteAllFieldIndexes() {
        this.db.execute("DELETE FROM index_configuration", new Object[0]);
        this.db.execute("DELETE FROM index_entries", new Object[0]);
        this.db.execute("DELETE FROM index_state", new Object[0]);
        this.nextIndexToUpdate.clear();
        this.memoizedIndexes.clear();
    }

    @Override
    public void createTargetIndexes(Target target) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        for (Target subTarget : this.getSubTargets(target)) {
            TargetIndexMatcher targetIndexMatcher;
            FieldIndex fieldIndex;
            IndexManager.IndexType type = this.getIndexType(subTarget);
            if (type != IndexManager.IndexType.NONE && type != IndexManager.IndexType.PARTIAL || (fieldIndex = (targetIndexMatcher = new TargetIndexMatcher(subTarget)).buildTargetIndex()) == null) continue;
            this.addFieldIndex(fieldIndex);
        }
    }

    @Override
    @Nullable
    public String getNextCollectionGroupToUpdate() {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        FieldIndex nextIndex = this.nextIndexToUpdate.peek();
        return nextIndex != null ? nextIndex.getCollectionGroup() : null;
    }

    @Override
    public void updateIndexEntries(ImmutableSortedMap<DocumentKey, Document> documents) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        for (Map.Entry entry : documents) {
            Collection<FieldIndex> fieldIndexes = this.getFieldIndexes(((DocumentKey)entry.getKey()).getCollectionGroup());
            for (FieldIndex fieldIndex : fieldIndexes) {
                SortedSet<IndexEntry> newEntries;
                SortedSet<IndexEntry> existingEntries = this.getExistingIndexEntries((DocumentKey)entry.getKey(), fieldIndex);
                if (existingEntries.equals(newEntries = this.computeIndexEntries((Document)entry.getValue(), fieldIndex))) continue;
                this.updateEntries((Document)entry.getValue(), existingEntries, newEntries);
            }
        }
    }

    private void updateEntries(Document document, SortedSet<IndexEntry> existingEntries, SortedSet<IndexEntry> newEntries) {
        Logger.debug(TAG, "Updating index entries for document '%s'", document.getKey());
        Util.diffCollections(existingEntries, newEntries, entry -> this.addIndexEntry(document, (IndexEntry)entry), entry -> this.deleteIndexEntry(document, (IndexEntry)entry));
    }

    @Override
    public Collection<FieldIndex> getFieldIndexes(String collectionGroup) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        Map<Integer, FieldIndex> indexes = this.memoizedIndexes.get(collectionGroup);
        return indexes == null ? Collections.emptyList() : indexes.values();
    }

    @Override
    public Collection<FieldIndex> getFieldIndexes() {
        ArrayList<FieldIndex> allIndices = new ArrayList<FieldIndex>();
        for (Map<Integer, FieldIndex> indices : this.memoizedIndexes.values()) {
            allIndices.addAll(indices.values());
        }
        return allIndices;
    }

    private FieldIndex.IndexOffset getMinOffset(Collection<FieldIndex> fieldIndexes) {
        Assert.hardAssert(!fieldIndexes.isEmpty(), "Found empty index group when looking for least recent index offset.", new Object[0]);
        Iterator<FieldIndex> it = fieldIndexes.iterator();
        FieldIndex.IndexOffset minOffset = it.next().getIndexState().getOffset();
        int maxBatchId = minOffset.getLargestBatchId();
        while (it.hasNext()) {
            FieldIndex.IndexOffset newOffset = it.next().getIndexState().getOffset();
            if (newOffset.compareTo(minOffset) < 0) {
                minOffset = newOffset;
            }
            maxBatchId = Math.max(newOffset.getLargestBatchId(), maxBatchId);
        }
        return FieldIndex.IndexOffset.create(minOffset.getReadTime(), minOffset.getDocumentKey(), maxBatchId);
    }

    @Override
    public FieldIndex.IndexOffset getMinOffset(String collectionGroup) {
        Collection<FieldIndex> fieldIndexes = this.getFieldIndexes(collectionGroup);
        Assert.hardAssert(!fieldIndexes.isEmpty(), "minOffset was called for collection without indexes", new Object[0]);
        return this.getMinOffset(fieldIndexes);
    }

    @Override
    public IndexManager.IndexType getIndexType(Target target) {
        IndexManager.IndexType result = IndexManager.IndexType.FULL;
        List<Target> subTargets = this.getSubTargets(target);
        for (Target subTarget : subTargets) {
            FieldIndex index = this.getFieldIndex(subTarget);
            if (index == null) {
                result = IndexManager.IndexType.NONE;
                break;
            }
            if (index.getSegments().size() >= subTarget.getSegmentCount()) continue;
            result = IndexManager.IndexType.PARTIAL;
        }
        if (target.hasLimit() && subTargets.size() > 1 && result == IndexManager.IndexType.FULL) {
            return IndexManager.IndexType.PARTIAL;
        }
        return result;
    }

    @Override
    public FieldIndex.IndexOffset getMinOffset(Target target) {
        ArrayList<FieldIndex> fieldIndexes = new ArrayList<FieldIndex>();
        for (Target subTarget : this.getSubTargets(target)) {
            FieldIndex index = this.getFieldIndex(subTarget);
            if (index == null) continue;
            fieldIndexes.add(index);
        }
        return this.getMinOffset(fieldIndexes);
    }

    private List<Target> getSubTargets(Target target) {
        if (this.targetToDnfSubTargets.containsKey(target)) {
            return this.targetToDnfSubTargets.get(target);
        }
        ArrayList<Target> subTargets = new ArrayList<Target>();
        if (target.getFilters().isEmpty()) {
            subTargets.add(target);
        } else {
            List<Filter> dnf = LogicUtils.getDnfTerms(new CompositeFilter(target.getFilters(), CompositeFilter.Operator.AND));
            for (Filter term : dnf) {
                subTargets.add(new Target(target.getPath(), target.getCollectionGroup(), term.getFilters(), target.getOrderBy(), target.getLimit(), target.getStartAt(), target.getEndAt()));
            }
        }
        this.targetToDnfSubTargets.put(target, subTargets);
        return subTargets;
    }

    private void memoizeIndex(FieldIndex fieldIndex) {
        FieldIndex existingIndex;
        Map<Integer, FieldIndex> existingIndexes = this.memoizedIndexes.get(fieldIndex.getCollectionGroup());
        if (existingIndexes == null) {
            existingIndexes = new HashMap<Integer, FieldIndex>();
            this.memoizedIndexes.put(fieldIndex.getCollectionGroup(), existingIndexes);
        }
        if ((existingIndex = existingIndexes.get(fieldIndex.getIndexId())) != null) {
            this.nextIndexToUpdate.remove(existingIndex);
        }
        existingIndexes.put(fieldIndex.getIndexId(), fieldIndex);
        this.nextIndexToUpdate.add(fieldIndex);
        this.memoizedMaxIndexId = Math.max(this.memoizedMaxIndexId, fieldIndex.getIndexId());
        this.memoizedMaxSequenceNumber = Math.max(this.memoizedMaxSequenceNumber, fieldIndex.getIndexState().getSequenceNumber());
    }

    private SortedSet<IndexEntry> computeIndexEntries(Document document, FieldIndex fieldIndex) {
        TreeSet<IndexEntry> result = new TreeSet<IndexEntry>();
        byte[] directionalValue = this.encodeDirectionalElements(fieldIndex, document);
        if (directionalValue == null) {
            return result;
        }
        FieldIndex.Segment arraySegment = fieldIndex.getArraySegment();
        if (arraySegment != null) {
            Value value = document.getField(arraySegment.getFieldPath());
            if (Values.isArray(value)) {
                for (Value arrayValue : value.getArrayValue().getValuesList()) {
                    result.add(IndexEntry.create(fieldIndex.getIndexId(), document.getKey(), this.encodeSingleElement(arrayValue), directionalValue));
                }
            }
        } else {
            result.add(IndexEntry.create(fieldIndex.getIndexId(), document.getKey(), new byte[0], directionalValue));
        }
        return result;
    }

    private void addIndexEntry(Document document, IndexEntry indexEntry) {
        this.db.execute("INSERT INTO index_entries (index_id, uid, array_value, directional_value, document_key) VALUES(?, ?, ?, ?, ?)", indexEntry.getIndexId(), this.uid, indexEntry.getArrayValue(), indexEntry.getDirectionalValue(), document.getKey().toString());
    }

    private void deleteIndexEntry(Document document, IndexEntry indexEntry) {
        this.db.execute("DELETE FROM index_entries WHERE index_id = ? AND uid = ? AND array_value = ? AND directional_value = ? AND document_key = ?", indexEntry.getIndexId(), this.uid, indexEntry.getArrayValue(), indexEntry.getDirectionalValue(), document.getKey().toString());
    }

    private SortedSet<IndexEntry> getExistingIndexEntries(DocumentKey documentKey, FieldIndex fieldIndex) {
        TreeSet<IndexEntry> results = new TreeSet<IndexEntry>();
        this.db.query("SELECT array_value, directional_value FROM index_entries WHERE index_id = ? AND document_key = ? AND uid = ?").binding(fieldIndex.getIndexId(), documentKey.toString(), this.uid).forEach(row -> results.add(IndexEntry.create(fieldIndex.getIndexId(), documentKey, row.getBlob(0), row.getBlob(1))));
        return results;
    }

    @Override
    public List<DocumentKey> getDocumentsMatchingTarget(Target target) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        ArrayList<String> subQueries = new ArrayList<String>();
        ArrayList<Object> bindings = new ArrayList<Object>();
        ArrayList<Pair> indexes = new ArrayList<Pair>();
        for (Target subTarget : this.getSubTargets(target)) {
            FieldIndex fieldIndex = this.getFieldIndex(subTarget);
            if (fieldIndex == null) {
                return null;
            }
            indexes.add(Pair.create((Object)subTarget, (Object)fieldIndex));
        }
        for (Pair pair : indexes) {
            Target subTarget = (Target)pair.first;
            FieldIndex fieldIndex = (FieldIndex)pair.second;
            List<Value> arrayValues = subTarget.getArrayValues(fieldIndex);
            Collection<Value> notInValues = subTarget.getNotInValues(fieldIndex);
            Bound lowerBound = subTarget.getLowerBound(fieldIndex);
            Bound upperBound = subTarget.getUpperBound(fieldIndex);
            if (Logger.isDebugEnabled()) {
                Logger.debug(TAG, "Using index '%s' to execute '%s' (Arrays: %s, Lower bound: %s, Upper bound: %s)", fieldIndex, subTarget, arrayValues, lowerBound, upperBound);
            }
            Object[] lowerBoundEncoded = this.encodeBound(fieldIndex, subTarget, lowerBound);
            String lowerBoundOp = lowerBound.isInclusive() ? ">=" : ">";
            Object[] upperBoundEncoded = this.encodeBound(fieldIndex, subTarget, upperBound);
            String upperBoundOp = upperBound.isInclusive() ? "<=" : "<";
            Object[] notInEncoded = this.encodeValues(fieldIndex, subTarget, notInValues);
            Object[] subQueryAndBindings = this.generateQueryAndBindings(subTarget, fieldIndex.getIndexId(), arrayValues, lowerBoundEncoded, lowerBoundOp, upperBoundEncoded, upperBoundOp, notInEncoded);
            subQueries.add(String.valueOf(subQueryAndBindings[0]));
            bindings.addAll(Arrays.asList(subQueryAndBindings).subList(1, subQueryAndBindings.length));
        }
        String unionSubTargets = TextUtils.join((CharSequence)" UNION ", subQueries) + "ORDER BY directional_value, document_key " + (target.getKeyOrder().equals((Object)OrderBy.Direction.ASCENDING) ? "asc " : "desc ");
        String queryString = "SELECT DISTINCT document_key FROM (" + unionSubTargets + ")";
        if (target.hasLimit()) {
            queryString = queryString + " LIMIT " + target.getLimit();
        }
        Assert.hardAssert(bindings.size() < 1000, "Cannot perform query with more than 999 bind elements", new Object[0]);
        SQLitePersistence.Query query = this.db.query(queryString).binding(bindings.toArray());
        ArrayList<DocumentKey> result = new ArrayList<DocumentKey>();
        query.forEach(row -> result.add(DocumentKey.fromPath(ResourcePath.fromString(row.getString(0)))));
        Logger.debug(TAG, "Index scan returned %s documents", result.size());
        return result;
    }

    private Object[] generateQueryAndBindings(Target target, int indexId, @Nullable List<Value> arrayValues, Object[] lowerBounds, String lowerBoundOp, Object[] upperBounds, String upperBoundOp, @Nullable Object[] notIn) {
        int statementCount = (arrayValues != null ? arrayValues.size() : 1) * Math.max(lowerBounds.length, upperBounds.length);
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT document_key, directional_value FROM index_entries ");
        statement.append("WHERE index_id = ? AND uid = ? ");
        statement.append("AND array_value = ? ");
        statement.append("AND directional_value ").append(lowerBoundOp).append(" ? ");
        statement.append("AND directional_value ").append(upperBoundOp).append(" ? ");
        StringBuilder sql = Util.repeatSequence(statement, statementCount, " UNION ");
        if (notIn != null) {
            sql = new StringBuilder("SELECT document_key, directional_value FROM (").append((CharSequence)sql);
            sql.append(") WHERE directional_value NOT IN (");
            sql.append((CharSequence)Util.repeatSequence("?", notIn.length, ", "));
            sql.append(")");
        }
        Object[] bindArgs = this.fillBounds(statementCount, indexId, arrayValues, lowerBounds, upperBounds, notIn);
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(sql.toString());
        result.addAll(Arrays.asList(bindArgs));
        return result.toArray();
    }

    private Object[] fillBounds(int statementCount, int indexId, @Nullable List<Value> arrayValues, Object[] lowerBounds, Object[] upperBounds, @Nullable Object[] notInValues) {
        int bindsPerStatement = 5;
        int statementsPerArrayValue = statementCount / (arrayValues != null ? arrayValues.size() : 1);
        Object[] bindArgs = new Object[statementCount * bindsPerStatement + (notInValues != null ? notInValues.length : 0)];
        int offset = 0;
        for (int i = 0; i < statementCount; ++i) {
            bindArgs[offset++] = indexId;
            bindArgs[offset++] = this.uid;
            bindArgs[offset++] = arrayValues != null ? this.encodeSingleElement(arrayValues.get(i / statementsPerArrayValue)) : EMPTY_BYTES_VALUE;
            bindArgs[offset++] = lowerBounds[i % statementsPerArrayValue];
            bindArgs[offset++] = upperBounds[i % statementsPerArrayValue];
        }
        if (notInValues != null) {
            for (Object notInValue : notInValues) {
                bindArgs[offset++] = notInValue;
            }
        }
        return bindArgs;
    }

    @Nullable
    private FieldIndex getFieldIndex(Target target) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        TargetIndexMatcher targetIndexMatcher = new TargetIndexMatcher(target);
        String collectionGroup = target.getCollectionGroup() != null ? target.getCollectionGroup() : target.getPath().getLastSegment();
        Collection<FieldIndex> collectionIndexes = this.getFieldIndexes(collectionGroup);
        if (collectionIndexes.isEmpty()) {
            return null;
        }
        FieldIndex matchingIndex = null;
        for (FieldIndex fieldIndex : collectionIndexes) {
            boolean matches = targetIndexMatcher.servedByIndex(fieldIndex);
            if (!matches || matchingIndex != null && fieldIndex.getSegments().size() <= matchingIndex.getSegments().size()) continue;
            matchingIndex = fieldIndex;
        }
        return matchingIndex;
    }

    @Nullable
    private byte[] encodeDirectionalElements(FieldIndex fieldIndex, Document document) {
        IndexByteEncoder encoder = new IndexByteEncoder();
        for (FieldIndex.Segment segment : fieldIndex.getDirectionalSegments()) {
            Value field = document.getField(segment.getFieldPath());
            if (field == null) {
                return null;
            }
            DirectionalIndexByteEncoder directionalEncoder = encoder.forKind(segment.getKind());
            FirestoreIndexValueWriter.INSTANCE.writeIndexValue(field, directionalEncoder);
        }
        return encoder.getEncodedBytes();
    }

    private byte[] encodeSingleElement(Value value) {
        IndexByteEncoder encoder = new IndexByteEncoder();
        FirestoreIndexValueWriter.INSTANCE.writeIndexValue(value, encoder.forKind(FieldIndex.Segment.Kind.ASCENDING));
        return encoder.getEncodedBytes();
    }

    @Nullable
    private Object[] encodeValues(FieldIndex fieldIndex, Target target, @Nullable Collection<Value> values) {
        if (values == null) {
            return null;
        }
        List<IndexByteEncoder> encoders = new ArrayList<IndexByteEncoder>();
        encoders.add(new IndexByteEncoder());
        Iterator<Value> position = values.iterator();
        for (FieldIndex.Segment segment : fieldIndex.getDirectionalSegments()) {
            Value value = position.next();
            for (IndexByteEncoder encoder : encoders) {
                if (this.isInFilter(target, segment.getFieldPath()) && Values.isArray(value)) {
                    encoders = this.expandIndexValues(encoders, segment, value);
                    continue;
                }
                DirectionalIndexByteEncoder directionalEncoder = encoder.forKind(segment.getKind());
                FirestoreIndexValueWriter.INSTANCE.writeIndexValue(value, directionalEncoder);
            }
        }
        return this.getEncodedBytes(encoders);
    }

    private Object[] encodeBound(FieldIndex fieldIndex, Target target, Bound bound) {
        return this.encodeValues(fieldIndex, target, bound.getPosition());
    }

    private Object[] getEncodedBytes(List<IndexByteEncoder> encoders) {
        Object[] result = new Object[encoders.size()];
        for (int i = 0; i < encoders.size(); ++i) {
            result[i] = encoders.get(i).getEncodedBytes();
        }
        return result;
    }

    private List<IndexByteEncoder> expandIndexValues(List<IndexByteEncoder> encoders, FieldIndex.Segment segment, Value value) {
        ArrayList<IndexByteEncoder> prefixes = new ArrayList<IndexByteEncoder>(encoders);
        ArrayList<IndexByteEncoder> results = new ArrayList<IndexByteEncoder>();
        for (Value arrayElement : value.getArrayValue().getValuesList()) {
            for (IndexByteEncoder prefix : prefixes) {
                IndexByteEncoder clonedEncoder = new IndexByteEncoder();
                clonedEncoder.seed(prefix.getEncodedBytes());
                FirestoreIndexValueWriter.INSTANCE.writeIndexValue(arrayElement, clonedEncoder.forKind(segment.getKind()));
                results.add(clonedEncoder);
            }
        }
        return results;
    }

    private boolean isInFilter(Target target, FieldPath fieldPath) {
        for (Filter filter : target.getFilters()) {
            FieldFilter.Operator operator;
            if (!(filter instanceof FieldFilter) || !((FieldFilter)filter).getField().equals(fieldPath) || !(operator = ((FieldFilter)filter).getOperator()).equals((Object)FieldFilter.Operator.IN) && !operator.equals((Object)FieldFilter.Operator.NOT_IN)) continue;
            return true;
        }
        return false;
    }

    private byte[] encodeSegments(FieldIndex fieldIndex) {
        return this.serializer.encodeFieldIndexSegments(fieldIndex.getSegments()).toByteArray();
    }

    @Override
    public void updateCollectionGroup(String collectionGroup, FieldIndex.IndexOffset offset) {
        Assert.hardAssert(this.started, "IndexManager not started", new Object[0]);
        ++this.memoizedMaxSequenceNumber;
        for (FieldIndex fieldIndex : this.getFieldIndexes(collectionGroup)) {
            FieldIndex updatedIndex = FieldIndex.create(fieldIndex.getIndexId(), fieldIndex.getCollectionGroup(), fieldIndex.getSegments(), FieldIndex.IndexState.create(this.memoizedMaxSequenceNumber, offset));
            this.db.execute("REPLACE INTO index_state (index_id, uid,  sequence_number, read_time_seconds, read_time_nanos, document_key, largest_batch_id) VALUES(?, ?, ?, ?, ?, ?, ?)", fieldIndex.getIndexId(), this.uid, this.memoizedMaxSequenceNumber, offset.getReadTime().getTimestamp().getSeconds(), offset.getReadTime().getTimestamp().getNanoseconds(), EncodedPath.encode(offset.getDocumentKey().getPath()), offset.getLargestBatchId());
            this.memoizeIndex(updatedIndex);
        }
    }
}

