/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.TransactionOptions;
import com.google.firebase.firestore.core.Transaction;
import com.google.firebase.firestore.remote.Datastore;
import com.google.firebase.firestore.remote.RemoteStore;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.ExponentialBackoff;
import com.google.firebase.firestore.util.Function;

public class TransactionRunner<TResult> {
    private AsyncQueue asyncQueue;
    private RemoteStore remoteStore;
    private Function<Transaction, Task<TResult>> updateFunction;
    private int attemptsRemaining;
    private ExponentialBackoff backoff;
    private TaskCompletionSource<TResult> taskSource = new TaskCompletionSource();

    public TransactionRunner(AsyncQueue asyncQueue, RemoteStore remoteStore, TransactionOptions options, Function<Transaction, Task<TResult>> updateFunction) {
        this.asyncQueue = asyncQueue;
        this.remoteStore = remoteStore;
        this.updateFunction = updateFunction;
        this.attemptsRemaining = options.getMaxAttempts();
        this.backoff = new ExponentialBackoff(asyncQueue, AsyncQueue.TimerId.RETRY_TRANSACTION);
    }

    public Task<TResult> run() {
        this.runWithBackoff();
        return this.taskSource.getTask();
    }

    private void runWithBackoff() {
        --this.attemptsRemaining;
        this.backoff.backoffAndRun(() -> {
            Transaction transaction = this.remoteStore.createTransaction();
            this.updateFunction.apply(transaction).addOnCompleteListener(this.asyncQueue.getExecutor(), userTask -> {
                if (!userTask.isSuccessful()) {
                    this.handleTransactionError(userTask);
                } else {
                    transaction.commit().addOnCompleteListener(this.asyncQueue.getExecutor(), commitTask -> {
                        if (commitTask.isSuccessful()) {
                            this.taskSource.setResult(userTask.getResult());
                        } else {
                            this.handleTransactionError(commitTask);
                        }
                    });
                }
            });
        });
    }

    private void handleTransactionError(Task task) {
        if (this.attemptsRemaining > 0 && TransactionRunner.isRetryableTransactionError(task.getException())) {
            this.runWithBackoff();
        } else {
            this.taskSource.setException(task.getException());
        }
    }

    private static boolean isRetryableTransactionError(Exception e) {
        if (e instanceof FirebaseFirestoreException) {
            FirebaseFirestoreException.Code code = ((FirebaseFirestoreException)((Object)e)).getCode();
            return code == FirebaseFirestoreException.Code.ABORTED || code == FirebaseFirestoreException.Code.ALREADY_EXISTS || code == FirebaseFirestoreException.Code.FAILED_PRECONDITION || !Datastore.isPermanentError(((FirebaseFirestoreException)((Object)e)).getCode());
        }
        return false;
    }
}

