/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.ListenSource;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Preconditions;
import java.util.concurrent.Executor;

public final class SnapshotListenOptions {
    private final MetadataChanges metadataChanges;
    private final ListenSource source;
    private final Executor executor;
    private final Activity activity;

    private SnapshotListenOptions(Builder builder) {
        this.metadataChanges = builder.metadataChanges;
        this.source = builder.source;
        this.executor = builder.executor;
        this.activity = builder.activity;
    }

    @NonNull
    public MetadataChanges getMetadataChanges() {
        return this.metadataChanges;
    }

    @NonNull
    public ListenSource getSource() {
        return this.source;
    }

    @NonNull
    public Executor getExecutor() {
        return this.executor;
    }

    @Nullable
    public Activity getActivity() {
        return this.activity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotListenOptions that = (SnapshotListenOptions)o;
        return this.metadataChanges == that.metadataChanges && this.source == that.source && this.executor.equals(that.executor) && this.activity.equals(that.activity);
    }

    public int hashCode() {
        int result = this.metadataChanges.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.executor.hashCode();
        result = 31 * result + (this.activity != null ? this.activity.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SnapshotListenOptions{metadataChanges=" + (Object)((Object)this.metadataChanges) + ", source=" + (Object)((Object)this.source) + ", executor=" + this.executor + ", activity=" + this.activity + '}';
    }

    public static class Builder {
        private MetadataChanges metadataChanges = MetadataChanges.EXCLUDE;
        private ListenSource source = ListenSource.DEFAULT;
        private Executor executor = Executors.DEFAULT_CALLBACK_EXECUTOR;
        private Activity activity = null;

        @NonNull
        public Builder setMetadataChanges(@NonNull MetadataChanges metadataChanges) {
            Preconditions.checkNotNull(metadataChanges, "metadataChanges must not be null.");
            this.metadataChanges = metadataChanges;
            return this;
        }

        @NonNull
        public Builder setSource(@NonNull ListenSource source) {
            Preconditions.checkNotNull(source, "listen source must not be null.");
            this.source = source;
            return this;
        }

        @NonNull
        public Builder setExecutor(@NonNull Executor executor) {
            Preconditions.checkNotNull(executor, "executor must not be null.");
            this.executor = executor;
            return this;
        }

        @NonNull
        public Builder setActivity(@NonNull Activity activity) {
            Preconditions.checkNotNull(activity, "activity must not be null.");
            this.activity = activity;
            return this;
        }

        @NonNull
        public SnapshotListenOptions build() {
            return new SnapshotListenOptions(this);
        }
    }
}

