/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.core.OnlineState;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.QueryListener;
import com.google.firebase.firestore.core.SyncEngine;
import com.google.firebase.firestore.core.ViewSnapshot;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Util;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class EventManager
implements SyncEngine.SyncEngineCallback {
    private final SyncEngine syncEngine;
    private final Map<Query, QueryListenersInfo> queries;
    private final Set<EventListener<Void>> snapshotsInSyncListeners = new HashSet<EventListener<Void>>();
    private OnlineState onlineState = OnlineState.UNKNOWN;

    public EventManager(SyncEngine syncEngine) {
        this.syncEngine = syncEngine;
        this.queries = new HashMap<Query, QueryListenersInfo>();
        syncEngine.setCallback(this);
    }

    public int addQueryListener(QueryListener queryListener) {
        boolean firstListen;
        Query query = queryListener.getQuery();
        QueryListenersInfo queryInfo = this.queries.get(query);
        boolean bl = firstListen = queryInfo == null;
        if (firstListen) {
            queryInfo = new QueryListenersInfo();
            this.queries.put(query, queryInfo);
        }
        queryInfo.listeners.add(queryListener);
        boolean raisedEvent = queryListener.onOnlineStateChanged(this.onlineState);
        Assert.hardAssert(!raisedEvent, "onOnlineStateChanged() shouldn't raise an event for brand-new listeners.", new Object[0]);
        if (queryInfo.viewSnapshot != null && (raisedEvent = queryListener.onViewSnapshot(queryInfo.viewSnapshot))) {
            this.raiseSnapshotsInSyncEvent();
        }
        if (firstListen) {
            queryInfo.targetId = this.syncEngine.listen(query);
        }
        return queryInfo.targetId;
    }

    public void removeQueryListener(QueryListener listener) {
        Query query = listener.getQuery();
        QueryListenersInfo queryInfo = this.queries.get(query);
        boolean lastListen = false;
        if (queryInfo != null) {
            queryInfo.listeners.remove(listener);
            lastListen = queryInfo.listeners.isEmpty();
        }
        if (lastListen) {
            this.queries.remove(query);
            this.syncEngine.stopListening(query);
        }
    }

    public void addSnapshotsInSyncListener(EventListener<Void> listener) {
        this.snapshotsInSyncListeners.add(listener);
        listener.onEvent(null, null);
    }

    public void removeSnapshotsInSyncListener(EventListener<Void> listener) {
        this.snapshotsInSyncListeners.remove(listener);
    }

    private void raiseSnapshotsInSyncEvent() {
        for (EventListener<Void> listener : this.snapshotsInSyncListeners) {
            listener.onEvent(null, null);
        }
    }

    @Override
    public void onViewSnapshots(List<ViewSnapshot> snapshotList) {
        boolean raisedEvent = false;
        for (ViewSnapshot viewSnapshot : snapshotList) {
            Query query = viewSnapshot.getQuery();
            QueryListenersInfo info = this.queries.get(query);
            if (info == null) continue;
            for (QueryListener listener : info.listeners) {
                if (!listener.onViewSnapshot(viewSnapshot)) continue;
                raisedEvent = true;
            }
            info.viewSnapshot = viewSnapshot;
        }
        if (raisedEvent) {
            this.raiseSnapshotsInSyncEvent();
        }
    }

    @Override
    public void onError(Query query, Status error) {
        QueryListenersInfo info = this.queries.get(query);
        if (info != null) {
            for (QueryListener listener : info.listeners) {
                listener.onError(Util.exceptionFromStatus(error));
            }
        }
        this.queries.remove(query);
    }

    @Override
    public void handleOnlineStateChange(OnlineState onlineState) {
        boolean raisedEvent = false;
        this.onlineState = onlineState;
        for (QueryListenersInfo info : this.queries.values()) {
            for (QueryListener listener : info.listeners) {
                if (!listener.onOnlineStateChanged(onlineState)) continue;
                raisedEvent = true;
            }
        }
        if (raisedEvent) {
            this.raiseSnapshotsInSyncEvent();
        }
    }

    public static class ListenOptions {
        public boolean includeDocumentMetadataChanges;
        public boolean includeQueryMetadataChanges;
        public boolean waitForSyncWhenOnline;
    }

    private static class QueryListenersInfo {
        private final List<QueryListener> listeners = new ArrayList<QueryListener>();
        private ViewSnapshot viewSnapshot;
        private int targetId;

        QueryListenersInfo() {
        }
    }
}

