/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import java.util.Arrays;
import java.util.List;

public abstract class FieldValue {
    private static final DeleteFieldValue DELETE_INSTANCE = new DeleteFieldValue();
    private static final ServerTimestampFieldValue SERVER_TIMESTAMP_INSTANCE = new ServerTimestampFieldValue();

    FieldValue() {
    }

    abstract String getMethodName();

    @NonNull
    public static FieldValue delete() {
        return DELETE_INSTANCE;
    }

    @NonNull
    public static FieldValue serverTimestamp() {
        return SERVER_TIMESTAMP_INSTANCE;
    }

    @NonNull
    public static FieldValue arrayUnion(Object ... elements) {
        return new ArrayUnionFieldValue(Arrays.asList(elements));
    }

    @NonNull
    public static FieldValue arrayRemove(Object ... elements) {
        return new ArrayRemoveFieldValue(Arrays.asList(elements));
    }

    @NonNull
    public static FieldValue increment(long l) {
        return new NumericIncrementFieldValue(l);
    }

    @NonNull
    public static FieldValue increment(double l) {
        return new NumericIncrementFieldValue(l);
    }

    static class NumericIncrementFieldValue
    extends FieldValue {
        private final Number operand;

        NumericIncrementFieldValue(Number operand) {
            this.operand = operand;
        }

        @Override
        String getMethodName() {
            return "FieldValue.increment";
        }

        Number getOperand() {
            return this.operand;
        }
    }

    static class ArrayRemoveFieldValue
    extends FieldValue {
        private final List<Object> elements;

        ArrayRemoveFieldValue(List<Object> elements) {
            this.elements = elements;
        }

        @Override
        String getMethodName() {
            return "FieldValue.arrayRemove";
        }

        List<Object> getElements() {
            return this.elements;
        }
    }

    static class ArrayUnionFieldValue
    extends FieldValue {
        private final List<Object> elements;

        ArrayUnionFieldValue(List<Object> elements) {
            this.elements = elements;
        }

        @Override
        String getMethodName() {
            return "FieldValue.arrayUnion";
        }

        List<Object> getElements() {
            return this.elements;
        }
    }

    static class ServerTimestampFieldValue
    extends FieldValue {
        ServerTimestampFieldValue() {
        }

        @Override
        String getMethodName() {
            return "FieldValue.serverTimestamp";
        }
    }

    static class DeleteFieldValue
    extends FieldValue {
        DeleteFieldValue() {
        }

        @Override
        String getMethodName() {
            return "FieldValue.delete";
        }
    }
}

